## To submit the job run llsubmit bluegene.cmd 
## llq to see the queue
## llcancel $JOB_ID to cancel the job

#@ job_type = bluegene 
#@ job_name = scrambler_test
#@ error = $(job_name).$(jobid).err 
#@ output = $(job_name).$(jobid).out 
#@ environment = COPY_ALL; 
#@ notification = never
#@ wall_clock_limit = 1:00:00 
#@ bg_size = 64
#@ class = small 
#@ queue 

export BG_MAXALIGNEXP=-1
#  BG_MAXALIGNEXP = 1000  - default, OS handles first 1000 alignment errors and triggers Alignment Exception
#  BG_MAXALIGNEXP =  0    - OS does not handle any alignment errors and triggers Alignment Exception immediately
#  BG_MAXALIGNEXP = -1    - OS handles all alignment errors and never triggers Alignment Exception (very slow)


## Virtual Node mode: each node is allocated 4 separate MPI process (i.e. 1 per CPU core)  
mpirun -exp_env BG_MAXALIGNEXP -np 256 -mode VN -cwd $PWD -exe ./astrobear

## Dual Node mode: 
# mpirun -exp_env BG_MAXALIGNEXP -np 128 -mode DUAL -cwd $PWD -exe ./astrobear

## SMP mode: 
# mpirun -exp_env BG_MAXALIGNEXP -np 64 -mode SMP -cwd $PWD -exe ./astrobear




