!#########################################################################
!		
!    Copyright (C) 2003-2012 Department of Physics and Astronomy,
!                            University of Rochester,
!                            Rochester, NY
!
!    thread_control.f90 is part of AstroBEAR.
!
!    AstroBEAR is free software: you can redistribute it and/or modify	  
!    it under the terms of the GNU General Public License as published by 
!    the Free Software Foundation, either version 3 of the License, or    
!    (at your option) any later version.
!
!    AstroBEAR is distributed in the hope that it will be useful, 
!    but WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!    GNU General Public License for more details.
!
!    You should have received a copy of the GNU General Public License
!    along with AstroBEAR.  If not, see <http://www.gnu.org/licenses/>.
!
!#########################################################################
!> @dir threads
!! @brief Directory contains modules for implementing threading

!> @defgroup Threads Threads
!! @brief Modules for implementing threading

!> @file thread_control.f90
!! @brief Main file for module ThreadControl

!> @defgroup ThreadControl Thread Control
!! @brief Thread control module
!! @ingroup Threads

!> Thread control module
!! @ingroup ThreadControl
MODULE ThreadControl
   USE DataLevelOps
   USE GlobalDeclarations
   USE ThreadDeclarations
   IMPLICIT NONE
   PUBLIC ThreadsInit, LaunchAdvanceThread, JoinAdvanceThread
   SAVE
CONTAINS
   !> Initializes thread variables
   SUBROUTINE ThreadsInit
      INTEGER :: i, ierr
      INTEGER :: stacksize=16777216 !16 MB
      INTEGER :: control_priority
      IF (iThreaded == PSUEDO_THREADED) RETURN
      ALLOCATE(thread_id(-2:MaxLevel))
      ALLOCATE(thread_attr(-2:MaxLevel))
      ALLOCATE(thread_status(-2:MaxLevel))
      ALLOCATE(thread_args(-2:MaxLevel))
      ALLOCATE(thread_priority(-2:MaxLevel))
      thread_priority(-2:MaxLevel)=1
      control_priority=1
      CALL fpthread_self(control_thread, ierr)

      CALL fpthread_setschedparam(control_thread, SCHED_FIFO, control_priority, ierr)      
               write(*,*) "ierr=", ierr
               write(*,*) "control_thread", control_thread
               write(*,*) "control_priority", control_priority
               IF (ierr /= 0) THEN
                  write(*,*) "error setting schedparam for control thread"
                  STOP
               END IF
      IF (iThreaded == THREADED) THEN
         DO i=-2, MaxLevel
            CALL fpthread_attr_init(thread_attr(i), ierr)
            CALL fpthread_attr_setdetachstate(thread_attr(i), FPTHREAD_CREATE_JOINABLE, ierr)
            CALL fpthread_attr_setscope(thread_attr(i), FPTHREAD_SCOPE_SYSTEM, ierr)
            CALL fpthread_attr_setschedpolicy(thread_attr(i), SCHED_OTHER, ierr)
            CALL fpthread_attr_setschedparam(thread_attr(i), 0, ierr)
            CALL fpthread_attr_setstacksize(thread_attr(i),stacksize, ierr)
            thread_args(i)=i
         END DO
      END IF
   END SUBROUTINE ThreadsInit



   !> @name Routines for using advance threads 
   !! @{

   !> Launches an advance thread for a given level
   !! @param n level
   SUBROUTINE LaunchAdvanceThread(n)
      INTEGER :: n, ierr
      levels(n)%id=n
!      CALL fpthread_create_sri(thread_id(n), AdvanceGridsLevel, thread_args(n), ierr)
      
!      CALL fpthread_create_noattr(thread_id(n), AdvanceGridsLevel, thread_args(n), ierr)
      CALL fpthread_create(thread_id(n), thread_attr(n), AdvanceGridsLevel, thread_args(n), ierr)
      IF (iThreaded == THREADED) CALL fpthread_setschedparam(thread_id(n),SCHED_FIFO, thread_priority(n), ierr)
 !      write(*,'(A4,I4,A,I4,A,I)'), "Proc ", MPI_ID, " Created thread for level ", n, ", thread id=", thread_id(n)
!      write(*,*) ierr
   END SUBROUTINE LaunchAdvanceThread


   !> Joins an advance thread for a given level
   !! @param n level
   SUBROUTINE JoinAdvanceThread(n)
      TYPE(IntStatusPointer) :: returnstatus
      INTEGER :: n, ierr
!      write(*,'(A4,I4,A,I4,A,I)'), "Proc ", MPI_ID, " Waiting on thread for level ", n, ", thread id=", thread_id(n)
      CALL fpthread_join(thread_id(n), returnstatus, ierr)
!      write(*,'(A4,I4,A,I4,A,I)'), "Proc ", MPI_ID, " Finished thread on level ", n, ", with status=", returnstatus%status
   END SUBROUTINE JoinAdvanceThread
   
   !> Thread wrapper for AdvanceGrids
   !! @param n level
   SUBROUTINE AdvanceGridsLevel(n)
      INTEGER :: n
      CALL AdvanceGrids(n)
      IF (iThreaded == THREADED) THEN
         thread_status(n)=0
         CALL fpthread_exit(thread_status(n))
      END IF
   END SUBROUTINE AdvanceGridsLevel

end MODULE ThreadControl
