!#########################################################################
!		
!    Copyright (C) 2003-2012 Department of Physics and Astronomy,
!                            University of Rochester,
!                            Rochester, NY
!
!    thread_declarations.f90 is part of AstroBEAR.
!
!    AstroBEAR is free software: you can redistribute it and/or modify	  
!    it under the terms of the GNU General Public License as published by 
!    the Free Software Foundation, either version 3 of the License, or    
!    (at your option) any later version.
!
!    AstroBEAR is distributed in the hope that it will be useful, 
!    but WITHOUT ANY WARRANTY; without even the implied warranty of
!    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!    GNU General Public License for more details.
!
!    You should have received a copy of the GNU General Public License
!    along with AstroBEAR.  If not, see <http://www.gnu.org/licenses/>.
!
!#########################################################################
!> @file thread_declarations.f90
!! @brief Main file for module ThreadDeclarations

!> @defgroup ThreadDeclarations Thread Declarations
!! @brief Module containing variables related to threading
!! @ingroup Threads

!> Module containing variables related to threading
!! @ingroup ThreadDeclarations
module ThreadDeclarations
   USE GlobalDeclarations
   include 'fpthread.f'
   TYPE(fpthread), DIMENSION(:), ALLOCATABLE :: thread_id
   TYPE(fpthread) :: control_thread
   TYPE(fpthread_attr), DIMENSION(:), ALLOCATABLE :: thread_attr
   !> Data type used to pass a pointer to a pointer to the c wrapper
   TYPE IntStatusPointer
      INTEGER, POINTER :: Status
   END TYPE IntStatusPointer
   INTEGER, DIMENSION(:), ALLOCATABLE :: thread_status, thread_args, thread_priority
   SAVE
end module ThreadDeclarations
