#include <ctype.h>
#include <string.h>
#include "Elastic.h"
#include "TGraph.h"
#include "TF1.h"
void CS_2fun(TF1* ,TF1*, std::string , std::string, std::string, std::string);
void CS_2fun
(TF1* fun1,TF1* fun2,std::string title, std::string txttit_1, std::string file ,std::string nu_nub)
{
// nu_num states whether it is nu nub or both
//create titles
  std::string txt_one = "Free Nucleon";
  std::string txt_sam = "Fermi Gas, Carbon";
//  double xtitle=-0.09;
  double xtitle= 0.13;
  double ytitle=1.14;
  double ystep = 0.095;
  float txtsize=0.055;
  Margin( 0.10, 0.04, 0.13, 0.12);
//
  TCanvas *c2 = new TCanvas("c2","",800,350);
  gPad->SetGrid();
  c2->Range(0,0,20,20);
  c2->SetFillColor(10);
  double xlim[2] = {0.10.,11.7};
//  double xlim[2] = {0.10.,1.9};
  if(strcmp(nu_nub.c_str(),"nu")==0||strcmp(nu_nub.c_str(),"nu_nub")==0)
  {
    double xposit=0.75;
    double yposit=1.07;
    double ylim[2]= {0.1,1.35}; // for neutrino or both
  } 
  else if(strcmp(nu_nub.c_str(),"nub")==0)
  {
    double xposit=0.17;
    double yposit=0.171;
    double ylim[2]= {0.1,1.00}; // for antineutrino
  } 
  else
  {
    cout<<" nu_nub ="<<nu_nub.c_str()<<" not correct"<<endl; 
  } 
  TGraph  *gr2 = new TGraph(2,xlim,ylim);
  gr2->SetTitle("");
  TLatex *titl = new TLatex();
  titl->SetTextSize(txtsize+0.01);
  titl->SetTextColor(1);
  double xtxt=start_text(xlim,xtitle);
  double ytxt=start_text(ylim,ytitle);
  cout<<" ytxt="<<ytxt<<endl;
  titl->DrawLatex(xtxt,ytxt,title.c_str());
  gr2->SetMarkerSize(0);
  gr2->Draw("AP");
  FormatGraph(gr2);
  gr2->GetXaxis()->SetTitle("E_{#nu} (GeV)");
  gr2->GetYaxis()->SetTitle("#sigma( 10^{-38}cm^{2} )");
  gr2->GetXaxis()->SetLabelSize(txtsize);
  gr2->Draw("AP");
// now start plotting
  double xtxt=start_text(xlim,xposit);
  double ytxt=start_text(ylim,yposit);
  double xline1=start_text(xlim,xposit-0.08);
  double xline2=start_text(xlim,xposit-0.01);
  double yline1=start_text(ylim,yposit+0.01);
//  if(strcmp(nu_nub.c_str(),"nu")==0||strcmp(nu_nub.c_str(),"nu_nub")==0)
//  {
    FormatFunc(fun1,2,1);
    fun1->Draw("same"); 
    TLatex *nu1 = new TLatex();
    nu1->SetTextSize(txtsize+0.002);
    nu1->SetTextColor(2);
    double ytxt=move_text(ylim,ytxt,ystep);
    std::string text_title1;
    text_title1.append(txt_one);
    text_title1.append(txttit_1);
    nu1->DrawLatex(xtxt,ytxt,text_title1.c_str());
    double yline1=move_text(ylim,yline1,ystep);
//  put in ine for label 
    TLine *line = new TLine(xline1,yline1,xline2,yline1);
    FormatLine(line,2,1);
    line->Draw();
//  }
// 
//  if(strcmp(nu_nub.c_str(),"nub")==0||strcmp(nu_nub.c_str(),"nu_nub")==0)
//  {
    FormatFunc(fun2,4,2);
    fun2->Draw("same"); 
    TLatex *nubar1 = new TLatex();
    nubar1->SetTextSize(txtsize+0.002);
    nubar1->SetTextColor(4);
    double ytxt=move_text(ylim,ytxt,ystep);
    std::string text_title2;
    text_title2.append(txt_sam);
    text_title2.append(txttit_1);
    nubar1->DrawLatex(xtxt,ytxt,text_title2.c_str());
    double yline1=move_text(ylim,yline1,ystep);
    TLine *line = new TLine(xline1,yline1,xline2,yline1);
    FormatLine(line,4,2);
    line->Draw();
//  }

//
//  now plot some points
  Int_t marker;
  Int_t iColor;
  float symSize=1.1;
  double xlab_start=0.19;
  double ylab_start=0.171;
  double xstep = 0.305;
  double xposit=xlab_start;
  double yposit=ylab_start;
  int line_width=3;
//
  float xval[20]={0};
  float yval[20]={0};
  float x_err[20]={0};
  float y_err[20]={0};
  if(strcmp(nu_nub.c_str(),"nu")==0||strcmp(nu_nub.c_str(),"nu_nub")==0)
  {
//
    std::string  data_file1 = "data/Kitagaki_nu.dat" ;
    int npoint = NptReadData(data_file1,xval,yval,y_err);
    TGraphErrors *data1 = new TGraphErrors(npoint,xval,yval,x_err,y_err);
    marker=27;
    iColor=13;
    FormatErrors(data1,iColor,marker,symSize+0.5,line_width);
    data1->Draw("P"); 
    TLatex *label1 = new TLatex();
    label1->SetTextSize(txtsize);
    label1->SetTextColor(iColor);
    double xtxt=start_text(xlim,xposit);
    double ytxt=start_text(ylim,yposit);
    std::string txt1 = "#nu FNAL 83, D_{2}";
    label1->DrawLatex(xtxt,ytxt,txt1.c_str());
    double xsym=start_text(xlim,xposit-0.02);
    double ysym=start_text(ylim,yposit+0.01);
    TMarker *symb = new TMarker(xsym,ysym,marker);
    FormatMarker(symb,iColor,marker,symSize+0.5);
    symb->Draw();
//
    std::string  data_file1 = "data/Barish_nu.dat" ;
    int npoint = NptReadData(data_file1,xval,yval,y_err);
//  std::string  data_file1 = "sakuda/ccqe.anl77.vec" ;
//  int npoint = ReadSakuda(data_file1,xval,yval,y_err);
    TGraphErrors *data1 = new TGraphErrors(npoint,xval,yval,x_err,y_err);
    marker=20;
    iColor=2;
    FormatErrors(data1,iColor,marker,symSize,line_width);
    data1->Draw("P"); 
    TLatex *label1 = new TLatex();
    label1->SetTextSize(txtsize);
    label1->SetTextColor(iColor);
    double ytxt=move_text(ylim,ytxt,ystep);
//std::string txt1 = "#nu Barish 1977, D_{2}";
    std::string txt1 = "#nu ANL 77, D_{2}";
    label1->DrawLatex(xtxt,ytxt,txt1.c_str());
    double ysym=move_text(ylim,ysym,ystep);
    TMarker *symb = new TMarker(xsym,ysym,marker);
    FormatMarker(symb,iColor,marker,symSize);
    symb->Draw();
//
//  std::string  data_file2 = "data/Brunner_nu.dat" ;
    std::string  data_file2 = "sakuda/ccqe.nu.skat90.vec" ;
    int npoint = ReadSakuda(data_file2,xval,yval,y_err);
    TGraphErrors *data2 = new TGraphErrors(npoint,xval,yval,x_err,y_err);
    marker=21;
    iColor=6;
    FormatErrors(data2,iColor,marker,symSize,line_width);
    data2->Draw("P"); 
    TLatex *label2 = new TLatex();
    label2->SetTextSize(txtsize);
    label2->SetTextColor(iColor);
    double ytxt=move_text(ylim,ytxt,ystep);
//std::string txt2 = "#nu Brunner 1990, CF_{3}Br";
    std::string txt2 = "#nu SKAT 90, CF_{3}Br";
    label2->DrawLatex(xtxt,ytxt,txt2.c_str());
    double ysym=move_text(ylim,ysym,ystep);
    TMarker *symb = new TMarker(xsym,ysym,marker);
    FormatMarker(symb,iColor,marker,symSize);
    symb->Draw();
//
// reposition the text
    double xposit=xlab_start+xstep;
    double yposit=ylab_start;
//
    std::string  data_file3 = "data/Mann_nu.dat" ;
    int npoint = NptReadData(data_file3,xval,yval,y_err);
    TGraphErrors *data3 = new TGraphErrors(npoint,xval,yval,x_err,y_err);
    marker=30;
    iColor=68;
    FormatErrors(data3,iColor,marker,symSize+0.3,line_width);
    data3->Draw("P"); 
    TLatex *label3 = new TLatex();
    label3->SetTextSize(txtsize);
    label3->SetTextColor(iColor);
    double xtxt=start_text(xlim,xposit);
    double ytxt=start_text(ylim,yposit);
//std::string txt3 = "#nu Mann 1973, D_{2}";
    std::string txt3 = "#nu ANL 73, D_{2}";
    label3->DrawLatex(xtxt,ytxt,txt3.c_str());
    double xsym=start_text(xlim,xposit-0.02);
    double ysym=start_text(ylim,yposit+0.01);
    TMarker *symb = new TMarker(xsym,ysym,marker);
    FormatMarker(symb,iColor,marker,symSize+0.3);
    symb->Draw();
//
    std::string  data_file4 = "sakuda/ccqe.nu.ggm79.vec" ;
 //  M.~Pohl  Lett. Nuovo Cimento 26 (1979) 332
    int npoint = ReadSakuda(data_file4,xval,yval,y_err);
    TGraphErrors *data4 = new TGraphErrors(npoint,xval,yval,x_err,y_err);
    marker=23;
    iColor=1;
    FormatErrors(data4,iColor,marker,symSize+0.2,line_width);
    data4->Draw("P"); 
    TLatex *label4 = new TLatex();
    label4->SetTextSize(txtsize);
    label4->SetTextColor(iColor);
    double ytxt=move_text(ylim,ytxt,ystep);
    std::string txt4 = "#nu GGM 79, CF_{3}Br";
    label4->DrawLatex(xtxt,ytxt,txt4.c_str());
    double ysym=move_text(ylim,ysym,ystep);
    TMarker *symb = new TMarker(xsym,ysym,marker);
    FormatMarker(symb,iColor,marker,symSize+0.2);
    symb->Draw();
//
    std::string  data_file5 = "data/Baker_nu.dat" ;
    int npoint = NptReadData(data_file5,xval,yval,y_err);
    TGraphErrors *data5 = new TGraphErrors(npoint,xval,yval,x_err,y_err);
    marker=28;
    iColor=3;
    FormatErrors(data5,iColor,marker,symSize+0.5,line_width);
    data5->Draw("P"); 
    TLatex *label5 = new TLatex();
    label5->SetTextSize(txtsize);
    label5->SetTextColor(iColor);
    double ytxt=move_text(ylim,ytxt,ystep);
//std::string txt5 = "#nu Baker 1981, D_{2}";
    std::string txt5 = "#nu BNL 81, D_{2}";
    label5->DrawLatex(xtxt,ytxt,txt5.c_str());
    double ysym=move_text(ylim,ysym,ystep);
    TMarker *symb = new TMarker(xsym,ysym,marker);
    FormatMarker(symb,iColor,marker,symSize+0.5);
    symb->Draw();
//
// reposition the text
    xposit=xlab_start+2.0*xstep;
    double yposit=ylab_start;
//
    std::string  data_file6 = "sakuda/ccqe.ggm77.vec" ;
    int npoint = ReadSakuda(data_file6,xval,yval,y_err);
    TGraphErrors *data6 = new TGraphErrors(npoint,xval,yval,x_err,y_err);
    marker=22;
    iColor=92;
    FormatErrors(data6,iColor,marker,symSize+0.2,line_width);
    data6->Draw("P"); 
    TLatex *label6 = new TLatex();
    label6->SetTextSize(txtsize);
    label6->SetTextColor(iColor);
    double xtxt=start_text(xlim,xposit);
    double ytxt=start_text(ylim,yposit);
    std::string txt6 = "#nu GGM 77, CF_{3}Br";
    label6->DrawLatex(xtxt,ytxt,txt6.c_str());
    double xsym=start_text(xlim,xposit-0.02);
    double ysym=start_text(ylim,yposit+0.01);
    TMarker *symb = new TMarker(xsym,ysym,marker);
    FormatMarker(symb,iColor,marker,symSize+0.2);
    symb->Draw();
//
    std::string  data_file6 = "sakuda/ccqe.serpukhov85.vec" ;
    int npoint = ReadSakuda(data_file6,xval,yval,y_err);
    TGraphErrors *data6 = new TGraphErrors(npoint,xval,yval,x_err,y_err);
    marker=29;
    iColor=50;
    FormatErrors(data6,iColor,marker,symSize+0.6,line_width);
    data6->Draw("P"); 
    TLatex *label6 = new TLatex();
    label6->SetTextSize(txtsize);
    label6->SetTextColor(iColor);
    double ytxt=move_text(ylim,ytxt,ystep);
    std::string txt6 = "#nu Serpukov 85, Al";
    label6->DrawLatex(xtxt,ytxt,txt6.c_str());
    double ysym=move_text(ylim,ysym,ystep);
    TMarker *symb = new TMarker(xsym,ysym,marker);
    FormatMarker(symb,iColor,marker,symSize+0.6);
    symb->Draw();
//
    std::string  data_file5 = "data/Lsnd_nu.dat" ;
    int npoint = NptReadData(data_file5,xval,yval,y_err);
    TGraphErrors *data5 = new TGraphErrors(npoint,xval,yval,x_err,y_err);
    marker=26;
    iColor=4;
    FormatErrors(data5,iColor,marker,symSize+0.2,line_width);
    data5->Draw("P"); 
    TLatex *label5 = new TLatex();
    label5->SetTextSize(txtsize);
    label5->SetTextColor(iColor);
    double ytxt=move_text(ylim,ytxt,ystep);
//std::string txt5 = "#nu Lsnd 1981, D_{2}";
    std::string txt5 = "#nu LSND 02, C_{12}";
    label5->DrawLatex(xtxt,ytxt,txt5.c_str());
    double ysym=move_text(ylim,ysym,ystep);
    TMarker *symb = new TMarker(xsym,ysym,marker);
    FormatMarker(symb,iColor,marker,symSize+0.2);
    symb->Draw();
//
  }
//
  if(strcmp(nu_nub.c_str(),"nub")==0||strcmp(nu_nub.c_str(),"nu_nub")==0)
  {
// reposition the text
    xposit=xlab_start+1.0*xstep;
    double yposit=ylab_start-ystep;
//  std::string  data_file8 = "data/Brunner_nub.dat" ;
    std::string  data_file8 = "sakuda/ccqe.nub.skat90.vec" ;
    int npoint = ReadSakuda(data_file8,xval,yval,y_err);
    TGraphErrors *data8 = new TGraphErrors(npoint,xval,yval,x_err,y_err);
    marker=21;
    iColor=6;
    FormatErrors(data8,iColor,marker,symSize,line_width);
    data8->Draw("P"); 
    TLatex *label8 = new TLatex();
    label8->SetTextSize(txtsize);
    label8->SetTextColor(iColor);
    double xtxt=start_text(xlim,xposit);
    double ytxt=start_text(ylim,yposit);
    std::string txt8 = "#bar{#nu} SKAT 90, CF_{3}Br";
    label8->DrawLatex(xtxt,ytxt,txt8.c_str());
    double xsym=start_text(xlim,xposit-0.02);
    double ysym=start_text(ylim,yposit+0.01);
    TMarker *symb = new TMarker(xsym,ysym,marker);
    FormatMarker(symb,iColor,marker,symSize);
    symb->Draw();
//
    std::string  data_file9 = "sakuda/ccqe.nub.ggm79.vec" ;
    int npoint = ReadSakuda(data_file9,xval,yval,y_err);
    TGraphErrors *data9 = new TGraphErrors(npoint,xval,yval,x_err,y_err);
    marker=23;
    iColor=1;
    FormatErrors(data9,iColor,marker,symSize+0.2,line_width);
    data9->Draw("P"); 
    TLatex *label9 = new TLatex();
    label9->SetTextSize(txtsize);
    label9->SetTextColor(iColor);
    double ytxt=move_text(ylim,ytxt,ystep);
    std::string txt9 = "#nub GGM 79, C_{3}H_{8}";
    label9->DrawLatex(xtxt,ytxt,txt9.c_str());
    double ysym=move_text(ylim,ysym,ystep);
    TMarker *symb = new TMarker(xsym,ysym,marker);
    FormatMarker(symb,iColor,marker,symSize+0.2);
    symb->Draw();
//
    xposit=xlab_start+2.0*xstep;
    double yposit=ylab_start-ystep;
    std::string data_file10 = "sakuda/ccqe.nub.serpukov.vec" ;
    int npoint = ReadSakuda(data_file10,xval,yval,y_err);
    TGraphErrors *data10 = new TGraphErrors(npoint,xval,yval,x_err,y_err);
    marker=29;
    iColor=50;
    FormatErrors(data10,iColor,marker,symSize+0.5,line_width);
    data10->Draw("P"); 
    TLatex *label10 = new TLatex();
    label10->SetTextSize(txtsize);
    label10->SetTextColor(iColor);
    double xtxt=start_text(xlim,xposit);
    double ytxt=start_text(ylim,yposit);
    std::string txt10 = "#bar{#nu} Serpukov 85, Al";
    label10->DrawLatex(xtxt,ytxt,txt10.c_str());
    double xsym=start_text(xlim,xposit-0.02);
    double ysym=start_text(ylim,yposit+0.01);
    TMarker *symb = new TMarker(xsym,ysym,marker);
    FormatMarker(symb,iColor,marker,symSize+0.5);
    symb->Draw();
//
    std::string  data_file11 = "data/Bonetti_nub.dat" ;
    int npoint = NptReadData(data_file11,xval,yval,y_err);
    TGraphErrors *data11 = new TGraphErrors(npoint,xval,yval,x_err,y_err);
    marker=22;
    iColor=92;
    FormatErrors(data11,iColor,marker,symSize+0.2,line_width);
    data11->Draw("P"); 
    TLatex *label11 = new TLatex();
    label11->SetTextSize(txtsize);
    label11->SetTextColor(iColor);
    double ytxt=move_text(ylim,ytxt,ystep);
    std::string txt11 = "#bar{#nu} GGM 77, CF_{3}Br";
    label11->DrawLatex(xtxt,ytxt,txt11.c_str());
    double ysym=move_text(ylim,ysym,ystep);
    TMarker *symb = new TMarker(xsym,ysym,marker);
    FormatMarker(symb,iColor,marker,symSize+0.2);
    symb->Draw();
  }
//

   c2->Print(file.c_str());
}
