#include <ctype.h>
#include <string.h>
#include "Elastic.h"
#include "TGraph.h"
#include "TF1.h"
void CS_2fun(TF1* ,TF1*, std::string , std::string, std::string);
void CS_2fun(TF1* fun1,TF1* fun2,std::string title, std::string txttit_1, std::string file)
{
//create titles
  std::string txt_nu = "#nu + n #rightarrow p + #mu^{-}";
  std::string txt_nubar = "#bar{#nu} + p #rightarrow n + #mu^{+}";
  double xtitle=-0.12;
  double ytitle=1.14;
  double xposit=0.75;
  double yposit=1.00;
  double ystep=0.08;
  Margin( 0.10, 0.04, 0.13, 0.12);
//
  TCanvas *c2 = new TCanvas("c2","",800,500);
  gPad->SetGrid();
  c2->Range(0,0,20,20);
  c2->SetFillColor(10);
  double xlim[2] = {0.10.,11.7};
  double ylim[2]= {0.1,1.35};
  TGraph  *gr2 = new TGraph(2,xlim,ylim);
  gr2->SetTitle("");
  TLatex *titl = new TLatex();
  titl->SetTextSize(0.05);
  titl->SetTextColor(1);
  double xtxt=start_text(xlim,xtitle);
  double ytxt=start_text(ylim,ytitle);
  titl->DrawLatex(xtxt,ytxt,title.c_str());
  gr2->SetMarkerSize(0);
  gr2->Draw("AP");
  FormatGraph(gr2);
  gr2->GetXaxis()->SetTitle("E_{#nu} (GeV)");
  gr2->GetYaxis()->SetTitle("#sigma( 10^{-38}cm^{2} )");
  gr2->GetXaxis()->SetLabelSize(0.055);
  gr2->Draw("AP");
// now start plotting
  FormatFunc(fun1,2,1);
  fun1->Draw("same"); 
  TLatex *nu1 = new TLatex();
  nu1->SetTextSize(0.0451);
  nu1->SetTextColor(2);
  double xtxt=start_text(xlim,xposit);
  double ytxt=start_text(ylim,yposit);
  std::string text_title1;
  text_title1.append(txt_nu);
  text_title1.append(txttit_1);
  nu1->DrawLatex(xtxt,ytxt,text_title1.c_str());
// put in ine for label 
  double xline1=start_text(xlim,xposit-0.08);
  double xline2=start_text(xlim,xposit-0.01);
  double yline1=start_text(ylim,yposit+0.01);
  TLine *line = new TLine(xline1,yline1,xline2,yline1);
  FormatLine(line,2,1);
  line->Draw();
// 
  FormatFunc(fun2,4,2);
  fun2->Draw("same"); 
  TLatex *nubar1 = new TLatex();
  nubar1->SetTextSize(0.0501);
  nubar1->SetTextColor(4);
  double ytxt=move_text(ylim,ytxt,ystep);
  std::string text_title2;
  text_title2.append(txt_nubar);
  text_title2.append(txttit_1);
  nubar1->DrawLatex(xtxt,ytxt,text_title2.c_str());
  double yline1=move_text(ylim,yline1,ystep);
  TLine *line = new TLine(xline1,yline1,xline2,yline1);
  FormatLine(line,4,2);
  line->Draw();

//
//  now plot some points
  Int_t marker;
  Int_t iColor;
  float symSize=1.1;
  double xposit=0.145;
  double yposit=0.11;
  float txtsize=0.045;
  int line_width=3;
  double ystep=0.075;
//
  float xval[20]={0};
  float yval[20]={0};
  float x_err[20]={0};
  float y_err[20]={0};
//
  std::string  data_file1 = "data/Kitagaki_nu.dat" ;
  int npoint = NptReadData(data_file1,xval,yval,y_err);
  TGraphErrors *data1 = new TGraphErrors(npoint,xval,yval,x_err,y_err);
  marker=27;
  iColor=13;
  FormatErrors(data1,iColor,marker,symSize+0.5,line_width);
  data1->Draw("P"); 
  TLatex *label1 = new TLatex();
  label1->SetTextSize(txtsize);
  label1->SetTextColor(iColor);
  double xtxt=start_text(xlim,xposit);
  double ytxt=start_text(ylim,yposit);
  std::string txt1 = "#nu FNAL 83, D_{2}";
  label1->DrawLatex(xtxt,ytxt,txt1.c_str());
  double xsym=start_text(xlim,xposit-0.02);
  double ysym=start_text(ylim,yposit+0.01);
  TMarker *symb = new TMarker(xsym,ysym,marker);
  FormatMarker(symb,iColor,marker,symSize+0.5);
  symb->Draw();
//
  std::string  data_file1 = "data/Barish_nu.dat" ;
  int npoint = NptReadData(data_file1,xval,yval,y_err);
//  std::string  data_file1 = "sakuda/ccqe.anl77.vec" ;
//  int npoint = ReadSakuda(data_file1,xval,yval,y_err);
  TGraphErrors *data1 = new TGraphErrors(npoint,xval,yval,x_err,y_err);
  marker=20;
  iColor=2;
  FormatErrors(data1,iColor,marker,symSize,line_width);
  data1->Draw("P"); 
  TLatex *label1 = new TLatex();
  label1->SetTextSize(txtsize);
  label1->SetTextColor(iColor);
  double ytxt=move_text(ylim,ytxt,ystep);
//std::string txt1 = "#nu Barish 1977, D_{2}";
  std::string txt1 = "#nu ANL 77, D_{2}";
  label1->DrawLatex(xtxt,ytxt,txt1.c_str());
  double ysym=move_text(ylim,ysym,ystep);
  TMarker *symb = new TMarker(xsym,ysym,marker);
  FormatMarker(symb,iColor,marker,symSize);
  symb->Draw();
//
//  std::string  data_file2 = "data/Brunner_nu.dat" ;
  std::string  data_file2 = "sakuda/ccqe.nu.skat90.vec" ;
  int npoint = ReadSakuda(data_file2,xval,yval,y_err);
  TGraphErrors *data2 = new TGraphErrors(npoint,xval,yval,x_err,y_err);
  marker=21;
  iColor=6;
  FormatErrors(data2,iColor,marker,symSize,line_width);
  data2->Draw("P"); 
  TLatex *label2 = new TLatex();
  label2->SetTextSize(txtsize);
  label2->SetTextColor(iColor);
  double ytxt=move_text(ylim,ytxt,ystep);
//std::string txt2 = "#nu Brunner 1990, CF_{3}Br";
  std::string txt2 = "#nu SKAT 90, CF_{3}Br";
  label2->DrawLatex(xtxt,ytxt,txt2.c_str());
  double ysym=move_text(ylim,ysym,ystep);
  TMarker *symb = new TMarker(xsym,ysym,marker);
  FormatMarker(symb,iColor,marker,symSize);
  symb->Draw();
//
// reposition the text
  double xposit=0.48;;
  double yposit=0.19;
//
  std::string  data_file3 = "data/Mann_nu.dat" ;
  int npoint = NptReadData(data_file3,xval,yval,y_err);
  TGraphErrors *data3 = new TGraphErrors(npoint,xval,yval,x_err,y_err);
  marker=22;
  iColor=92;
  FormatErrors(data3,iColor,marker,symSize+0.3,line_width);
  data3->Draw("P"); 
  TLatex *label3 = new TLatex();
  label3->SetTextSize(txtsize);
  label3->SetTextColor(iColor);
  double xtxt=start_text(xlim,xposit);
  double ytxt=start_text(ylim,yposit);
//std::string txt3 = "#nu Mann 1973, D_{2}";
  std::string txt3 = "#nu ANL 73, D_{2}";
  label3->DrawLatex(xtxt,ytxt,txt3.c_str());
  double xsym=start_text(xlim,xposit-0.02);
  double ysym=start_text(ylim,yposit+0.01);
  TMarker *symb = new TMarker(xsym,ysym,marker);
  FormatMarker(symb,iColor,marker,symSize+0.3);
  symb->Draw();
//
  std::string  data_file4 = "sakuda/ccqe.nu.ggm79.vec" ;
  int npoint = ReadSakuda(data_file4,xval,yval,y_err);
  TGraphErrors *data4 = new TGraphErrors(npoint,xval,yval,x_err,y_err);
  marker=23;
  iColor=1;
  FormatErrors(data4,iColor,marker,symSize+0.3,line_width);
  data4->Draw("P"); 
  TLatex *label4 = new TLatex();
  label4->SetTextSize(txtsize);
  label4->SetTextColor(iColor);
  double ytxt=move_text(ylim,ytxt,ystep);
  std::string txt4 = "#nu GGM 79, CF_{3}Br";
  label4->DrawLatex(xtxt,ytxt,txt4.c_str());
  double ysym=move_text(ylim,ysym,ystep);
  TMarker *symb = new TMarker(xsym,ysym,marker);
  FormatMarker(symb,iColor,marker,symSize+0.3);
  symb->Draw();
//
  std::string  data_file5 = "data/Baker_nu.dat" ;
  int npoint = NptReadData(data_file5,xval,yval,y_err);
  TGraphErrors *data5 = new TGraphErrors(npoint,xval,yval,x_err,y_err);
  marker=28;
  iColor=3;
  FormatErrors(data5,iColor,marker,symSize+0.5,line_width);
  data5->Draw("P"); 
  TLatex *label5 = new TLatex();
  label5->SetTextSize(txtsize);
  label5->SetTextColor(iColor);
  double ytxt=move_text(ylim,ytxt,ystep);
//std::string txt5 = "#nu Baker 1981, D_{2}";
  std::string txt5 = "#nu BNL 81, D_{2}";
  label5->DrawLatex(xtxt,ytxt,txt5.c_str());
  double ysym=move_text(ylim,ysym,ystep);
  TMarker *symb = new TMarker(xsym,ysym,marker);
  FormatMarker(symb,iColor,marker,symSize+0.5);
  symb->Draw();
//
  std::string  data_file6 = "sakuda/ccqe.serpukhov85.vec" ;
  int npoint = ReadSakuda(data_file6,xval,yval,y_err);
  TGraphErrors *data6 = new TGraphErrors(npoint,xval,yval,x_err,y_err);
  marker=29;
  iColor=50;
  FormatErrors(data6,iColor,marker,symSize+0.6,line_width);
  data6->Draw("P"); 
  TLatex *label6 = new TLatex();
  label6->SetTextSize(txtsize);
  label6->SetTextColor(iColor);
  double ytxt=move_text(ylim,ytxt,ystep);
  std::string txt6 = "#nu Serpukov, Al";
  label6->DrawLatex(xtxt,ytxt,txt6.c_str());
  double ysym=move_text(ylim,ysym,ystep);
  TMarker *symb = new TMarker(xsym,ysym,marker);
  FormatMarker(symb,iColor,marker,symSize+0.6);
  symb->Draw();
//
// reposition the text
  double xposit=0.805;
  double yposit=0.11;
//  std::string  data_file8 = "data/Brunner_nub.dat" ;
  std::string  data_file8 = "sakuda/ccqe.nub.skat90.vec" ;
  int npoint = ReadSakuda(data_file8,xval,yval,y_err);
  TGraphErrors *data8 = new TGraphErrors(npoint,xval,yval,x_err,y_err);
  marker=24;
  iColor=4;
  FormatErrors(data8,iColor,marker,symSize+0.4,line_width);
  data8->Draw("P"); 
  TLatex *label8 = new TLatex();
  label8->SetTextSize(txtsize);
  label8->SetTextColor(iColor);
  double xtxt=start_text(xlim,xposit);
  double ytxt=start_text(ylim,yposit);
  std::string txt8 = "#bar{#nu} SKAT 90, CF_{3}Br";
  label8->DrawLatex(xtxt,ytxt,txt8.c_str());
  double xsym=start_text(xlim,xposit-0.02);
  double ysym=start_text(ylim,yposit+0.01);
  TMarker *symb = new TMarker(xsym,ysym,marker);
  FormatMarker(symb,iColor,marker,symSize+0.4);
  symb->Draw();
//
  std::string  data_file9 = "sakuda/ccqe.nub.ggm79.vec" ;
  int npoint = ReadSakuda(data_file9,xval,yval,y_err);
  TGraphErrors *data9 = new TGraphErrors(npoint,xval,yval,x_err,y_err);
  marker=25;
  iColor=38;
  FormatErrors(data9,iColor,marker,symSize+0.1,line_width);
  data9->Draw("P"); 
  TLatex *label9 = new TLatex();
  label9->SetTextSize(txtsize);
  label9->SetTextColor(iColor);
  double ytxt=move_text(ylim,ytxt,ystep);
  std::string txt9 = "#bar{#nu} GGM 79, CF_{3}Br";
  label9->DrawLatex(xtxt,ytxt,txt9.c_str());
  double ysym=move_text(ylim,ysym,ystep);
  TMarker *symb = new TMarker(xsym,ysym,marker);
  FormatMarker(symb,iColor,marker,symSize+0.1);
  symb->Draw();
//
  std::string  data_file10 = "sakuda/ccqe.nub.serpukov.vec" ;
  int npoint = ReadSakuda(data_file10,xval,yval,y_err);
  TGraphErrors *data10 = new TGraphErrors(npoint,xval,yval,x_err,y_err);
  marker=30;
  iColor=68;
  FormatErrors(data10,iColor,marker,symSize+0.5,line_width);
  data10->Draw("P"); 
  TLatex *label10 = new TLatex();
  label10->SetTextSize(txtsize);
  label10->SetTextColor(iColor);
  double ytxt=move_text(ylim,ytxt,ystep);
  std::string txt10 = "#bar{#nu} Serpukov, Al";
  label10->DrawLatex(xtxt,ytxt,txt10.c_str());
  double ysym=move_text(ylim,ysym,ystep);
  TMarker *symb = new TMarker(xsym,ysym,marker);
  FormatMarker(symb,iColor,marker,symSize+0.5);
  symb->Draw();
//

   c2->Print(file.c_str());
}
