#include <ctype.h>
#include <string.h>
#include "Elastic.h"
#include "TGraph.h"
#include "TF1.h"
void CS_2fun(TF1* ,TF1* ,TF1* , std::string , std::string, std::string, std::string, double x_max);
void CS_2fun
(TF1* fun1,TF1* fun2,TF1* fun3
 ,std::string title, std::string txttit, std::string file ,std::string nu_nub,double x_max)
{
// nu_num states whether it is nu nub or both
//create titles
  std::string txt_1 = "Free Nucleon";
//  std::string txt_2 = "Fermi Gas, C_{12}";
  std::string txt_2 = "Fermi Gas,C_{12},E_{B}=25 MeV";
//  std::string txt_3 = "Fermi Gas,C_{12},E_{BIND}=25 MeV,Bd FF";
//  std::string txt_3 = "Fermi Gas    C_{12},E_{BIND}=25 MeV,Bounded FF";
  std::string txt_3 = "Fermi Gas, C_{12} with BFF";
  double xtitle= 0.06;
  double ytitle=1.15;
  double ystep = 0.083;
  float txtsize=0.05;
  Margin( 0.10, 0.04, 0.13, 0.12);
  TCanvas *c2 = new TCanvas("c2","",800,370);
  gPad->SetGrid();
  gPad->SetLogx(1);
  gStyle->SetNdivisions(505,"x");
  c2->Range(0,0,20,20);
  c2->SetFillColor(10);
//  double xlim[2] = {0.20.,11.7};
//  double xlim[2] = {0.15.,11.7};
  double xlim[2] = {0.15.,40.0};
//  xlim[1]=x_max;
  if(strcmp(nu_nub.c_str(),"nu")==0&&x_max>5.0)
  {
    double xposit=0.05;
    double yposit=.475;
    double ylab_start=0.141;
    double ylim[2]= {0.1,1.35}; // for neutrino or both
  } 
  else if(strcmp(nu_nub.c_str(),"nu")==0&&x_max<5.0) 
  {
    double xposit=0.08;
    double yposit=.475;
    double ylab_start=0.141;
    double ylim[2]= {0.1,1.35}; // for neutrino or both
  } 
  else if(strcmp(nu_nub.c_str(),"nub")==0)
  {
    double xposit=0.482;
    double yposit=0.39 ;
    double ylab_start=0.118;
    double ylim[2]= {0.1,1.02}; // for antineutrino
  } 
  else
  {
    cout<<" nu_nub ="<<nu_nub.c_str()<<" not correct"<<endl; 
  } 
  double yposit=.405;
  TGraph  *gr2 = new TGraph(2,xlim,ylim);
  gr2->SetTitle("");
  TLatex *titl = new TLatex();
  titl->SetTextSize(txtsize+0.02);
  titl->SetTextColor(1);
  double xtxt=start_text(xlim,xtitle);
  double xtxt=-0.6;
  double ytxt=start_text(ylim,ytitle);
  cout<<" ytxt="<<ytxt<<endl;
  titl->DrawLatex(xtxt,ytxt,title.c_str());
  gr2->SetMarkerSize(0);
  gr2->Draw("AP");
  FormatGraph(gr2);
  gr2->GetXaxis()->SetTitle("E_{#nu} (GeV)");
  gr2->GetYaxis()->SetTitle("#sigma( 10^{-38}cm^{2} )");
  gr2->GetXaxis()->SetLabelSize(txtsize+0.01);
  gr2->GetYaxis()->SetLabelSize(txtsize+0.01);
  gr2->Draw("AP");
  Int_t iColor;
  Int_t iLineSty; 
// now start plotting
  double xtxt=start_text(xlim,xposit);
  double ytxt=start_text(ylim,yposit);
  double xline1=start_text(xlim,xposit-0.07);
  double xline2=start_text(xlim,xposit-0.01);
  double yline1=start_text(ylim,yposit+0.025);
//
  iColor=2;
  iLineSty=1;
  FormatFunc(fun1,iColor,iLineSty);
  fun1->SetLineWidth(5);
//  fun1->Draw("same"); 
  TLatex *fun_lab1 = new TLatex();
  fun_lab1->SetTextSize(txtsize+0.0001);
  fun_lab1->SetTextColor(iColor);
  double ytxt=move_text(ylim,ytxt,ystep);
  std::string text_title1;
  text_title1.append(txt_1);
  text_title1.append(txttit);
  xtxt=0.98;
//  fun_lab1->DrawLatex(xtxt,ytxt,text_title1.c_str());
  double yline1=move_text(ylim,yline1,ystep);
//  put in ine for label 
   xline1=0.78;
   xline2=0.96;
  TLine *line = new TLine(xline1,yline1,xline2,yline1);
  FormatLine(line,iColor,iLineSty);
//  line->Draw();
//
  iColor=1;
  iLineSty=2;
  FormatFunc(fun2,iColor,iLineSty);
  fun2->SetLineWidth(5);
  fun2->Draw("same"); 
  TLatex *fun_lab2 = new TLatex();
  fun_lab2->SetTextSize(txtsize+0.0001);
  fun_lab2->SetTextColor(iColor);
  fun_lab2->SetIndiceSize(0.55);
  fun_lab2->SetLimitIndiceSize(0.55);
  double ytxt=move_text(ylim,ytxt,ystep);
  std::string text_title2;
  text_title2.append(txt_2);
  text_title2.append(txttit);
  xtxt=0.85;
  fun_lab2->DrawLatex(xtxt,ytxt,text_title2.c_str());
  double yline1=move_text(ylim,yline1,ystep);
   xline1=0.68;
   xline2=0.82;
  TLine *line = new TLine(xline1,yline1,xline2,yline1);
  FormatLine(line,iColor,iLineSty);
  line->Draw();
//
//
  iColor=6;
  iLineSty=3;
  FormatFunc(fun3,iColor,iLineSty);
  fun3->SetLineWidth(5);
//  fun3->Draw("same"); 
  TLatex *fun_lab3 = new TLatex();
  fun_lab3->SetTextSize(txtsize+0.0001);
  fun_lab3->SetTextColor(iColor);
  fun_lab3->SetIndiceSize(0.55);
  fun_lab3->SetLimitIndiceSize(0.55);
  double ytxt=move_text(ylim,ytxt,ystep);
  std::string text_title3;
  text_title3.append(txt_3);
  text_title3.append(txttit);
//  xtxt=0.28;
//  fun_lab3->DrawLatex(xtxt,ytxt,text_title3.c_str());
//  double yline1=move_text(ylim,yline1,ystep);
//   xline1=0.05;
//   xline2=0.25;
  TLine *line = new TLine(xline1,yline1,xline2,yline1);
  FormatLine(line,iColor,iLineSty);
//  line->Draw();
//  now plot some points
  Int_t marker;
  Int_t iColor;
  float symSize=1.1;
  double xlab_start=0.16;
  double xstep = 0.305;
  double xposit=xlab_start;
  double yposit=ylab_start;
  int line_width=2;
//
  float xval[50]={0};
  float yval[50]={0};
  float x_err[50]={0};
  float y_err[50]={0};
  if(strcmp(nu_nub.c_str(),"nu")==0||strcmp(nu_nub.c_str(),"nu_nub")==0)
  {
//
    std::string  data_file1 = "data/Kitagaki_nu.dat" ;
    int npoint = NptReadData(data_file1,xval,yval,y_err);
    TGraphErrors *data1 = new TGraphErrors(npoint,xval,yval,x_err,y_err);
    marker=27;
    iColor=13;
    FormatErrors(data1,iColor,marker,symSize+0.5,line_width);
    data1->Draw("P"); 
    TLatex *label1 = new TLatex();
    label1->SetTextSize(txtsize);
    label1->SetTextColor(iColor);
    double xtxt=start_text(xlim,xposit);
    xtxt=-0.3;
    double ytxt=start_text(ylim,yposit);
    std::string txt1 = "#nu FNAL 83, D_{2}";
    label1->DrawLatex(xtxt,ytxt,txt1.c_str());
    double xsym=start_text(xlim,xposit-0.02);
    xsym=-0.35;
    double ysym=start_text(ylim,yposit+0.01);
    TMarker *symb = new TMarker(xsym,ysym,marker);
    FormatMarker(symb,iColor,marker,symSize+0.5);
    symb->Draw();
//
    std::string  data_file1 = "data/Barish_nu.dat" ;
    int npoint = NptReadData(data_file1,xval,yval,y_err);
//  std::string  data_file1 = "sakuda/ccqe.anl77.vec" ;
//  int npoint = ReadSakuda(data_file1,xval,yval,y_err);
    TGraphErrors *data1 = new TGraphErrors(npoint,xval,yval,x_err,y_err);
    marker=20;
    iColor=65;
    FormatErrors(data1,iColor,marker,symSize,line_width);
    data1->Draw("P"); 
    TLatex *label1 = new TLatex();
    label1->SetTextSize(txtsize);
    label1->SetTextColor(iColor);
    double ytxt=move_text(ylim,ytxt,ystep);
//std::string txt1 = "#nu Barish 1977, D_{2}";
    std::string txt1 = "#nu ANL 77, D_{2}";
    label1->DrawLatex(xtxt,ytxt,txt1.c_str());
    double ysym=move_text(ylim,ysym,ystep);
    TMarker *symb = new TMarker(xsym,ysym,marker);
    FormatMarker(symb,iColor,marker,symSize);
    symb->Draw();
//
//
    std::string  data_file5 = "data/Baker_nu.dat" ;
    int npoint = NptReadData(data_file5,xval,yval,y_err);
    TGraphErrors *data5 = new TGraphErrors(npoint,xval,yval,x_err,y_err);
    marker=28;
    iColor=3;
    FormatErrors(data5,iColor,marker,symSize+0.5,line_width);
    data5->Draw("P"); 
    TLatex *label5 = new TLatex();
    label5->SetTextSize(txtsize);
    label5->SetTextColor(iColor);
    double ytxt=move_text(ylim,ytxt,ystep);
//std::string txt5 = "#nu Baker 1981, D_{2}";
    std::string txt5 = "#nu BNL 81, D_{2}";
    label5->DrawLatex(xtxt,ytxt,txt5.c_str());
    double ysym=move_text(ylim,ysym,ystep);
    TMarker *symb = new TMarker(xsym,ysym,marker);
    FormatMarker(symb,iColor,marker,symSize+0.5);
    symb->Draw();
//
// reposition the text
    double xposit=xlab_start+xstep;
    double yposit=ylab_start;
//
    std::string  data_file3 = "data/Mann_nu.dat" ;
    int npoint = NptReadData(data_file3,xval,yval,y_err);
    TGraphErrors *data3 = new TGraphErrors(npoint,xval,yval,x_err,y_err);
    marker=30;
    iColor=4;
    FormatErrors(data3,iColor,marker,symSize+0.3,line_width);
    data3->Draw("P"); 
    TLatex *label3 = new TLatex();
    label3->SetTextSize(txtsize);
    label3->SetTextColor(iColor);
    double xtxt=start_text(xlim,xposit);
    xtxt=0.3;
    double ytxt=start_text(ylim,yposit);
//std::string txt3 = "#nu Mann 1973, D_{2}";
    std::string txt3 = "#nu ANL 73, D_{2}";
    label3->DrawLatex(xtxt,ytxt,txt3.c_str());
    double xsym=start_text(xlim,xposit-0.02);
    xsym=0.25;
    double ysym=start_text(ylim,yposit+0.01);
    TMarker *symb = new TMarker(xsym,ysym,marker);
    FormatMarker(symb,iColor,marker,symSize+0.3);
    symb->Draw();
//
//  std::string  data_file2 = "data/Brunner_nu.dat" ;
    std::string  data_file2 = "sakuda/ccqe.nu.skat90.vec" ;
    int npoint = ReadSakuda(data_file2,xval,yval,y_err);
    TGraphErrors *data2 = new TGraphErrors(npoint,xval,yval,x_err,y_err);
    marker=21;
    iColor=6;
    FormatErrors(data2,iColor,marker,symSize,line_width);
    data2->Draw("P"); 
    TLatex *label2 = new TLatex();
    label2->SetTextSize(txtsize);
    label2->SetTextColor(iColor);
    double ytxt=move_text(ylim,ytxt,ystep);
//std::string txt2 = "#nu Brunner 1990, CF_{3}Br";
    std::string txt2 = "#nu SKAT 90, CF_{3}Br";
    label2->DrawLatex(xtxt,ytxt,txt2.c_str());
    double ysym=move_text(ylim,ysym,ystep);
    TMarker *symb = new TMarker(xsym,ysym,marker);
    FormatMarker(symb,iColor,marker,symSize);
    symb->Draw();
//
    std::string  data_file4 = "sakuda/ccqe.nu.ggm79.vec" ;
 //  M.~Pohl  Lett. Nuovo Cimento 26 (1979) 332
    int npoint = ReadSakuda(data_file4,xval,yval,y_err);
    TGraphErrors *data4 = new TGraphErrors(npoint,xval,yval,x_err,y_err);
    marker=23;
    iColor=1;
    FormatErrors(data4,iColor,marker,symSize+0.2,line_width);
    data4->Draw("P"); 
    TLatex *label4 = new TLatex();
    label4->SetTextSize(txtsize);
    label4->SetTextColor(iColor);
    double ytxt=move_text(ylim,ytxt,ystep);
    std::string txt4 = "#nu GGM 79, C_{3}H_{8}";
    label4->DrawLatex(xtxt,ytxt,txt4.c_str());
    double ysym=move_text(ylim,ysym,ystep);
    TMarker *symb = new TMarker(xsym,ysym,marker);
    FormatMarker(symb,iColor,marker,symSize+0.2);
    symb->Draw();
//
// reposition the text
    xposit=xlab_start+2.0*xstep;
    double yposit=ylab_start;
//
//
//
    std::string  data_file7 = "sakuda/ccqe.nu.minerva.vec" ;
    int npoint = ReadSakuda(data_file7,xval,yval,y_err);
    TGraphErrors *data7 = new TGraphErrors(npoint,xval,yval,x_err,y_err);
    marker=26;
    iColor=2;
//    FormatErrors(data7,iColor,marker,symSize+0.2,line_width);
    FormatErrors(data7,iColor,marker,0.05,line_width);
    data7->Draw("P"); 
    TLatex *label7 = new TLatex();
    label7->SetTextSize(txtsize);
    label7->SetTextColor(iColor);
    double xtxt=start_text(xlim,xposit);
    xtxt=1.0;
    double ytxt=start_text(ylim,yposit);
//    std::string txt7 = "#nu Lsnd 1981, D_{2}";
    std::string txt7 = "#nu Minerva, C_{12}";
    label7->DrawLatex(xtxt,ytxt,txt7.c_str());
    double xsym=start_text(xlim,xposit-0.02);
    xsym=0.95;
    double ysym=start_text(ylim,yposit+0.01);
    TMarker *symb = new TMarker(xsym,ysym,marker);
    FormatMarker(symb,iColor,marker,symSize+0.2);
    symb->Draw();
//
    std::string  data_file6 = "sakuda/ccqe.serpukhov85.vec" ;
    int npoint = ReadSakuda(data_file6,xval,yval,y_err);
    TGraphErrors *data6 = new TGraphErrors(npoint,xval,yval,x_err,y_err);
    marker=29;
    iColor=50;
//    iColor=28;
    FormatErrors(data6,iColor,marker,symSize+0.6,line_width);
    data6->Draw("P"); 
    TLatex *label6 = new TLatex();
    label6->SetTextSize(txtsize);
    label6->SetTextColor(iColor);
    double ytxt=move_text(ylim,ytxt,ystep);
    std::string txt6 = "#nu Serpukov 85, Al";
    label6->DrawLatex(xtxt,ytxt,txt6.c_str());
    double ysym=move_text(ylim,ysym,ystep);
    TMarker *symb = new TMarker(xsym,ysym,marker);
    FormatMarker(symb,iColor,marker,symSize+0.6);
    symb->Draw();
//
    std::string  data_file6 = "sakuda/ccqe.ggm77.vec" ;
    int npoint = ReadSakuda(data_file6,xval,yval,y_err);
    TGraphErrors *data6 = new TGraphErrors(npoint,xval,yval,x_err,y_err);
    marker=22;
    iColor=93;
    FormatErrors(data6,iColor,marker,symSize+0.2,line_width);
    data6->Draw("P"); 
    TLatex *label6 = new TLatex();
    label6->SetTextSize(txtsize);
    label6->SetTextColor(iColor);
    double ytxt=move_text(ylim,ytxt,ystep);
    std::string txt6 = "#nu GGM 77, CF_{3}Br";
    label6->DrawLatex(xtxt,ytxt,txt6.c_str());
    double ysym=move_text(ylim,ysym,ystep);
    TMarker *symb = new TMarker(xsym,ysym,marker);
    FormatMarker(symb,iColor,marker,symSize+0.2);
    symb->Draw();
// Replot Minerva
    std::string  data_file14 = "sakuda/ccqe.nu.minerva.vec" ;
    int npoint = ReadSakuda(data_file14,xval,yval,y_err);
    TGraphErrors *data14 = new TGraphErrors(npoint,xval,yval,x_err,y_err);
    marker=26;
    iColor=2;
    FormatErrors(data14,iColor,marker,symSize+0.2,line_width);
    data7->Draw("P"); 
// replot Fnal,
    std::string  data_file13 = "data/Kitagaki_nu.dat" ;
    int npoint = NptReadData(data_file13,xval,yval,y_err);
    TGraphErrors *data13 = new TGraphErrors(npoint,xval,yval,x_err,y_err);
    marker=27;
    iColor=13;
    FormatErrors(data13,iColor,marker,symSize+0.5,line_width);
    data13->Draw("P"); 
//    TLatex *label1 = new TLatex();
//    label1->SetTextSize(txtsize);
//    label1->SetTextColor(iColor);
//    double xtxt=start_text(xlim,xposit);
//    xtxt=-0.3;
//    double ytxt=start_text(ylim,yposit);
//    std::string txt1 = "#nu FNAL 83, D_{2}";
//    label1->DrawLatex(xtxt,ytxt,txt1.c_str());
//    double xsym=start_text(xlim,xposit-0.02);
//    xsym=-0.35;
//    double ysym=start_text(ylim,yposit+0.01);
//    TMarker *symb = new TMarker(xsym,ysym,marker);
//    FormatMarker(symb,iColor,marker,symSize+0.5);
//    symb->Draw();
  }
//
  if(strcmp(nu_nub.c_str(),"nub")==0||strcmp(nu_nub.c_str(),"nu_nub")==0)
  {
// reposition the text
    xposit=xlab_start+1.0*xstep;
    double yposit=ylab_start-ystep;
//  std::string  data_file8 = "data/Brunner_nub.dat" ;
    std::string  data_file8 = "sakuda/ccqe.nub.skat90.vec" ;
    int npoint = ReadSakuda(data_file8,xval,yval,y_err);
    TGraphErrors *data8 = new TGraphErrors(npoint,xval,yval,x_err,y_err);
    marker=21;
    iColor=6;
    FormatErrors(data8,iColor,marker,symSize,line_width);
    data8->Draw("P"); 
    TLatex *label8 = new TLatex();
    label8->SetTextSize(txtsize);
    label8->SetTextColor(iColor);
    double xtxt=start_text(xlim,xposit);
    double ytxt=start_text(ylim,yposit);
    std::string txt8 = "#bar{#nu} SKAT 90, CF_{3}Br";
    label8->DrawLatex(xtxt,ytxt,txt8.c_str());
    double xsym=start_text(xlim,xposit-0.02);
    double ysym=start_text(ylim,yposit+0.01);
    TMarker *symb = new TMarker(xsym,ysym,marker);
    FormatMarker(symb,iColor,marker,symSize);
    symb->Draw();
//
    std::string  data_file9 = "sakuda/ccqe.nub.ggm79.vec" ;
    int npoint = ReadSakuda(data_file9,xval,yval,y_err);
    TGraphErrors *data9 = new TGraphErrors(npoint,xval,yval,x_err,y_err);
    marker=23;
    iColor=1;
    FormatErrors(data9,iColor,marker,symSize+0.2,line_width);
    data9->Draw("P"); 
    TLatex *label9 = new TLatex();
    label9->SetTextSize(txtsize);
    label9->SetTextColor(iColor);
    double ytxt=move_text(ylim,ytxt,ystep);
    std::string txt9 = "#bar{#nu} GGM 79, C_{3}H_{8}";
    label9->DrawLatex(xtxt,ytxt,txt9.c_str());
    double ysym=move_text(ylim,ysym,ystep);
    TMarker *symb = new TMarker(xsym,ysym,marker);
    FormatMarker(symb,iColor,marker,symSize+0.2);
    symb->Draw();
//
    xposit=xlab_start+2.0*xstep;
    double yposit=ylab_start-ystep;
    std::string data_file10 = "sakuda/ccqe.nub.serpukov.vec" ;
    int npoint = ReadSakuda(data_file10,xval,yval,y_err);
    TGraphErrors *data10 = new TGraphErrors(npoint,xval,yval,x_err,y_err);
    marker=29;
    iColor=50;
//    iColor=28;
    FormatErrors(data10,iColor,marker,symSize+0.5,line_width);
    data10->Draw("P"); 
    TLatex *label10 = new TLatex();
    label10->SetTextSize(txtsize);
    label10->SetTextColor(iColor);
    double xtxt=start_text(xlim,xposit);
    double ytxt=start_text(ylim,yposit);
    std::string txt10 = "#bar{#nu} Serpukov 85, Al";
    label10->DrawLatex(xtxt,ytxt,txt10.c_str());
    double xsym=start_text(xlim,xposit-0.02);
    double ysym=start_text(ylim,yposit+0.01);
    TMarker *symb = new TMarker(xsym,ysym,marker);
    FormatMarker(symb,iColor,marker,symSize+0.5);
    symb->Draw();
//
    std::string  data_file11 = "data/Bonetti_nub.dat" ;
    int npoint = NptReadData(data_file11,xval,yval,y_err);
    TGraphErrors *data11 = new TGraphErrors(npoint,xval,yval,x_err,y_err);
    marker=22;
    iColor=92;
    FormatErrors(data11,iColor,marker,symSize+0.2,line_width);
    data11->Draw("P"); 
    TLatex *label11 = new TLatex();
    label11->SetTextSize(txtsize);
    label11->SetTextColor(iColor);
    double ytxt=move_text(ylim,ytxt,ystep);
    std::string txt11 = "#bar{#nu} GGM 77, CF_{3}Br";
    label11->DrawLatex(xtxt,ytxt,txt11.c_str());
    double ysym=move_text(ylim,ysym,ystep);
    TMarker *symb = new TMarker(xsym,ysym,marker);
    FormatMarker(symb,iColor,marker,symSize+0.2);
    symb->Draw();
  }
  c2->Print(file.c_str());
}
