#! /bin/csh -f
#
cat > CreatFun.C<<EOF
// 
Double_t f1_nu_el_v(Double_t , Double_t );
Double_t f1_nu_el_v(Double_t *x, Double_t *par)
{
  return elas.F1_nu_el_V(-x[0]);
}
Double_t f1_nu_el_a(Double_t , Double_t );
Double_t f1_nu_el_a(Double_t *x, Double_t *par)
{
  return elas.F1_nu_el_A(-x[0]);
}
Double_t f1_nu_el_p(Double_t , Double_t );
Double_t f1_nu_el_p(Double_t *x, Double_t *par)
{
  return elas.F1_nu_el_p(-x[0]);
}
Double_t f1_nu_el_n(Double_t , Double_t );
Double_t f1_nu_el_n(Double_t *x, Double_t *par)
{
  return elas.F1_nu_el_n(-x[0]);
}
Double_t f1_nu_el(Double_t , Double_t );
Double_t f1_nu_el(Double_t *x, Double_t *par)
{
  return elas.F1_nu_el(-x[0]);
}
Double_t f2_nu_el_v(Double_t , Double_t );
Double_t f2_nu_el_v(Double_t *x, Double_t *par)
{
  return elas.F2_nu_el_V(-x[0]);
}
Double_t f2_nu_el_a(Double_t , Double_t );
Double_t f2_nu_el_a(Double_t *x, Double_t *par)
{
  return elas.F2_nu_el_A(-x[0]);
}
Double_t f2_nu_el_p(Double_t , Double_t );
Double_t f2_nu_el_p(Double_t *x, Double_t *par)
{
  return elas.F2_nu_el_p(-x[0]);
}
Double_t f2_nu_el_n(Double_t , Double_t );
Double_t f2_nu_el_n(Double_t *x, Double_t *par)
{
  return elas.F2_nu_el_n(-x[0]);
}
Double_t f2_nu_el(Double_t , Double_t );
Double_t f2_nu_el(Double_t *x, Double_t *par)
{
  return elas.F2_nu_el(-x[0]);
}
Double_t f3_nu_el(Double_t , Double_t );
Double_t f3_nu_el(Double_t *x, Double_t *par)
{
  return -elas.F3_nu_el(-x[0]);
}
Double_t r_nu_el_v(Double_t , Double_t );
Double_t r_nu_el_v(Double_t *x, Double_t *par)
{
  return elas.R_nu_el_V(-x[0]);
}
Double_t r_nu_el_a(Double_t , Double_t );
Double_t r_nu_el_a(Double_t *x, Double_t *par)
{
  return elas.R_nu_el_A(-x[0]);
}
Double_t r_nu_el_p(Double_t , Double_t );
Double_t r_nu_el_p(Double_t *x, Double_t *par)
{
  return elas.R_nu_el_p(-x[0]);
}
Double_t r_nu_el_n(Double_t , Double_t );
Double_t r_nu_el_n(Double_t *x, Double_t *par)
{
  return elas.R_nu_el_n(-x[0]);
}
Double_t r_nu_el(Double_t , Double_t );
Double_t r_nu_el(Double_t *x, Double_t *par)
{
  return elas.R_nu_el(-x[0]);
}
//
Double_t F1_e_el_n_over_p(Double_t , Double_t );
Double_t F1_e_el_n_over_p(Double_t *x, Double_t *par)
{
  return elas.F1_e_el_n(-x[0])/elas.F1_e_el_p(-x[0]);
}
Double_t F2_e_el_n_over_p(Double_t , Double_t );
Double_t F2_e_el_n_over_p(Double_t *x, Double_t *par)
{
  return elas.F2_e_el_n(-x[0])/elas.F2_e_el_p(-x[0]);
}
//
Double_t F1_nu_el_V_over_A(Double_t , Double_t );
Double_t F1_nu_el_V_over_A(Double_t *x, Double_t *par)
{
  return elas.F1_nu_el_V(-x[0])/elas.F1_nu_el_A(-x[0]);
}
Double_t F2_nu_el_V_over_A(Double_t , Double_t );
Double_t F2_nu_el_V_over_A(Double_t *x, Double_t *par)
{
  return elas.F2_nu_el_V(-x[0])/elas.F2_nu_el_A(-x[0]);
}
Double_t FA_over_GMV_2(Double_t , Double_t );
Double_t FA_over_GMV_2(Double_t *x, Double_t *par)
{
  double a=elas.F_A(-x[0])/elas.G_M_V(-x[0]);
  return a*a;
}
// Callen Gross
Double_t F2ep_el_over_2xF1ep(Double_t , Double_t );
Double_t F2ep_el_over_2xF1ep(Double_t *x, Double_t *par)
{
  return elas.F2_e_el_p(-x[0])/(2.0*elas.F1_e_el_p(-x[0]));
}
Double_t F2en_el_over_2xF1en(Double_t , Double_t );
Double_t F2en_el_over_2xF1en(Double_t *x, Double_t *par)
{
  return elas.F2_e_el_n(-x[0])/(2.0*elas.F1_e_el_n(-x[0]));
}
Double_t F2_A_el_over_2xF1_A(Double_t , Double_t );
Double_t F2_A_el_over_2xF1_A(Double_t *x, Double_t *par)
{
  return elas.F2_nu_el_A(-x[0])/(2.0*elas.F1_nu_el_A(-x[0]));
}
Double_t F2_V_el_over_2xF1_V(Double_t , Double_t );
Double_t F2_V_el_over_2xF1_V(Double_t *x, Double_t *par)
{
  return elas.F2_nu_el_V(-x[0])/(2.0*elas.F1_nu_el_V(-x[0]));
}
Double_t FA2_over_xF1_A_el(Double_t , Double_t );
Double_t FA2_over_xF1_A_el(Double_t *x, Double_t *par)
{
  return elas.F_A(-x[0])*elas.F_A(-x[0])/elas.F1_nu_el_A(-x[0]);
}
Double_t GMV_2_over_xF1_V_el(Double_t , Double_t );
Double_t GMV_2_over_xF1_V_el(Double_t *x, Double_t *par)
{
  return elas.G_M_V(-x[0])*elas.G_M_V(-x[0])/elas.F1_nu_el_V(-x[0]);
}

EOF
cat > funct.C<<EOF
#include <ctype.h>
#include <string.h>
#include "Duality.h"
#include "Elastic.h"
#include "TGraph.h"
#include "TF1.h"
void plt_fun(TF1* , std::string , std::string, std::string 
 ,double ,double ,double ,double ,int ,int ,int ); 
void plt_fun(TF1* fun1 ,std::string title ,std::string txttit, std::string file
 ,double x_axis_min ,double x_axis_max ,double y_axis_min ,double y_axis_max
 ,int iColor,int iLineSty,int iEnter)
{
// nu_num states whether it is nu nub or both
//create titles
  double xtitle= 0.02;
  double ytitle=1.02;
//  double ystep = 0.10; // bound form factors
  double ystep = 0.08;
  float txtsize=0.04;
  Margin( 0.10, 0.04, 0.13, 0.12);
  if(iEnter==0)
  {
    TCanvas *c2 = new TCanvas("c2","",800,800);
    gPad->SetGrid();
    c2->Range(0,0,20,20);
    c2->SetFillColor(10);
  }
  double xlim[2];
  double ylim[2];
  xlim[0]=x_axis_min;
  xlim[1]=x_axis_max;
  ylim[0]=y_axis_min;
  ylim[1]=y_axis_max;
//  double xposit=0.1; \\bounded ff
//  double yposit=1.01; \\bounded ff
  double xposit=0.20;
  double yposit=1.00;
  double ylab_start=0.141;
  if(iEnter==0)
  {
//    TGraph  *gr2 = new TGraph(2,xlim,ylim);
    TH2F *gr2  = new TH2F("gr2", "",300,xlim[0],xlim[1],300 ,ylim[0],ylim[1]);
    FormatGraph(gr2,txtsize,txtsize+0.005,1.2,1.3);
    gr2->GetXaxis()->SetTitle("Q^{2} (GeV^{2})");
//    gr2->GetXaxis()->SetTitle("E_{#nu} (GeV)");
//   gr2->GetYaxis()->SetTitle("d#sigma/dQ^{2}");
    gr2->GetYaxis()->SetTitle("");
    gr2->Draw("AP");
    TLatex *titl = new TLatex();
    titl->SetTextSize(txtsize+0.005);
    titl->SetTextColor(1);
    double xtit=start_text(xlim,xtitle);
    double ytit=start_text(ylim,ytitle);
    titl->DrawLatex(xtit,ytit,title.c_str());
  }
// now start plotting
  double xtxt=start_text(xlim,xposit);
  double xline1=start_text(xlim,xposit-0.07);
  double xline2=start_text(xlim,xposit-0.01);
  static double ytxt;
  static double yline1;
  if(iEnter==0)
  {
    ytxt=start_text(ylim,yposit);
//    yline1=start_text(ylim,yposit+0.025); //for form factor plot
    yline1=start_text(ylim,yposit+0.015);
  }
//
  FormatFunc(fun1,iColor,iLineSty);
  fun1->SetLineWidth(5);
  fun1->Draw("same"); 
  TLatex *fun_lab1 = new TLatex();
  fun_lab1->SetTextSize(txtsize+0.0001);
  fun_lab1->SetTextColor(iColor);
  ytxt=move_text(ylim,ytxt,ystep);
  std::string text_title1;
  text_title1.append(txttit);
  fun_lab1->DrawLatex(xtxt,ytxt,text_title1.c_str());
  yline1=move_text(ylim,yline1,ystep);
//  put in line for label 
  TLine *line = new TLine(xline1,yline1,xline2,yline1);
  FormatLine(line,iColor,iLineSty);
  line->Draw();

   c2->Print(file.c_str());
}
EOF
root -b <<EOF
.L Integrate.C
.L Spline.C
.L SplineFile.C
.L NucCorr.C
.L Elastic.C
.L Duality.C
.L SetGraphPt.C
.L CreatFun.C
.L FormatGraph.C
.L funct.C
// this need to be here
// Reference Plots with data
// Define the objects for the functions
// neutrino
  Duality elas("nu","one","JRA_CS_HallA","Krutov","JRA_CS_HallA","JRA",1.014);
//  Duality elas("nu","one","dipole","zero","dipole","dipole",1.014);
  elas.InitDuality();
  elas.WriteDuality();
  double xmin=0.001;
  double xmax=25.0;  
//
  TF1 *f1nu_elv = new TF1("f1nu_elv",f1_nu_el_v,xmin,xmax,0);
  TF1 *f1nu_ela = new TF1("f1nu_ela",f1_nu_el_a,xmin,xmax,0);
  TF1 *f1nu_el  = new TF1("f1nu_el" ,f1_nu_el  ,xmin,xmax,0);
  TF1 *f2nu_elv = new TF1("f2nu_elv",f2_nu_el_v,xmin,xmax,0);
  TF1 *f2nu_ela = new TF1("f2nu_ela",f2_nu_el_a,xmin,xmax,0);
  TF1 *f2nu_el  = new TF1("f2nu_el" ,f2_nu_el  ,xmin,xmax,0);
  TF1 *f2nu_el  = new TF1("f2nu_el" ,f3_nu_el  ,xmin,xmax,0);
// 
  char tit[100]
  char file[100]
  sprintf(tit,"");
  std::string tittxt  = "F1_nu_el_V" ;
  sprintf(file,"f123.eps");
  double x_axis_min=0.0;
  double x_axis_max=6.0;
  double y_axis_min=0.0;
  double y_axis_max=0.8;
  int iColor=2;
  int iLineStyle=0;
  int iEnter=0;
  plt_fun(f1nu_elv,tit,tittxt,file,x_axis_min,x_axis_max,y_axis_min,y_axis_max,iColor,iLineStyle,0);
//
  std::string tittxt  = "F1_nu_el_A" ;
  int iColor=4;
  int iLineStyle=2;
  plt_fun(f1nu_ela,tit,tittxt,file,x_axis_min,x_axis_max,y_axis_min,y_axis_max,iColor,iLineStyle,1);
//
  std::string tittxt  = "F2_nu_el_V" ;
  int iColor=3;
  int iLineStyle=1;
  plt_fun(f2nu_elv,tit,tittxt,file,x_axis_min,x_axis_max,y_axis_min,y_axis_max,iColor,iLineStyle,1);
//
  std::string tittxt  = "F2_nu_el_A" ;
  int iColor=6;
  int iLineStyle=2;
  plt_fun(f2nu_ela,tit,tittxt,file,x_axis_min,x_axis_max,y_axis_min,y_axis_max,iColor,iLineStyle,1);
//
  std::string tittxt  = "F3_nu_el" ;
  int iColor=1;
  int iLineStyle=2;
  plt_fun(f2nu_el,tit,tittxt,file,x_axis_min,x_axis_max,y_axis_min,y_axis_max,iColor,iLineStyle,1);
//
  sprintf(file,"r_nu_el.eps");
  double x_axis_min=0.001;
  double x_axis_max=4.0;
  double y_axis_min=-0.01;
  double y_axis_max=1.2;
  TF1 *rnu_elv  = new TF1("rnu_elv" ,r_nu_el_v ,xmin,xmax,0);
  std::string tittxt  = "R_nu_el_V" ;
  int iColor=2;
  int iLineStyle=0;
  int iEnter=0;
  plt_fun(rnu_elv,tit,tittxt,file,x_axis_min,x_axis_max,y_axis_min,y_axis_max,iColor,iLineStyle,0);
//
  TF1 *rnu_ela  = new TF1("rnu_ela" ,r_nu_el_a  ,xmin,xmax,0);
  std::string tittxt  = "R_nu_el_A" ;
  int iColor=4;
  int iLineStyle=2;
  plt_fun(rnu_ela,tit,tittxt,file,x_axis_min,x_axis_max,y_axis_min,y_axis_max,iColor,iLineStyle,1);
//
  TF1 *rnu_elp  = new TF1("rnu_elp" ,r_nu_el_p  ,xmin,xmax,0);
  std::string tittxt  = "R_nu_el_p" ;
  int iColor=6;
  int iLineStyle=2;
  plt_fun(rnu_elp,tit,tittxt,file,x_axis_min,x_axis_max,y_axis_min,y_axis_max,iColor,iLineStyle,1);
//
  TF1 *rnu_eln  = new TF1("rnu_eln" ,r_nu_el_n  ,xmin,xmax,0);
  std::string tittxt  = "R_nu_el_n" ;
  int iColor=7;
  int iLineStyle=2;
  plt_fun(rnu_eln,tit,tittxt,file,x_axis_min,x_axis_max,y_axis_min,y_axis_max,iColor,iLineStyle,1);
//
  TF1 *rnu_el  =  new TF1("rnu_el"  ,r_nu_el    ,xmin,xmax,0);
  std::string tittxt  = "R_nu_el" ;
  int iColor=3;
  int iLineStyle=2;
  plt_fun(rnu_el,tit,tittxt,file,x_axis_min,x_axis_max,y_axis_min,y_axis_max,iColor,iLineStyle,1);
//
  sprintf(file,"f_e_el_n_over_p.eps");
  double x_axis_min=0.001;
  double x_axis_max=xmax;
  double y_axis_min=.0;
  double y_axis_max=0.6;
  std::string tittxt  = "F1_e_el_n/F1_e_el_p" ;
  int iColor=2;
  int iLineStyle=0;
  int iEnter=0;
  TF1 *f1_e_el_n_over_p = new TF1("f1_e_el_n_over_p",F1_e_el_n_over_p,xmin,xmax,0);
  int iColor=2;
  int iLineStyle=2;
  plt_fun(f1_e_el_n_over_p,tit,tittxt,file,x_axis_min,x_axis_max,y_axis_min,y_axis_max,iColor,iLineStyle,0);
  std::string tittxt  = "F2_e_el_n/F2_e_el_p" ;
  TF1 *f2_e_el_n_over_p = new TF1("f2_e_el_n_over_p",F2_e_el_n_over_p,xmin,xmax,0);
  int iColor=4;
  int iLineStyle=2;
  plt_fun(f2_e_el_n_over_p,tit,tittxt,file,x_axis_min,x_axis_max,y_axis_min,y_axis_max,iColor,iLineStyle,1);
//
  sprintf(file,"f1f2va.eps");
  double x_axis_min=0.001;
  double x_axis_max=xmax;
  double y_axis_min=.0;
  double y_axis_max=3.0;
  int iEnter=0;
  TF1 *f1_nu_el_V_over_A = new TF1("f1_nu_el_V_over_A",F1_nu_el_V_over_A,xmin,xmax,0);
  std::string tittxt  = "F1_V/F1_A" ;
  int iColor=2;
  int iLineStyle=2;
  plt_fun(f1_nu_el_V_over_A,tit,tittxt,file,x_axis_min,x_axis_max,y_axis_min,y_axis_max,iColor,iLineStyle,0);
  std::string tittxt  = "F2_V/F2_A" ;
  TF1 *f2_nu_el_v_over_a = new TF1("f2_nu_el_v_over_a",F2_nu_el_V_over_A,xmin,xmax,0);
  int iColor=4;
  int iLineStyle=2;
  plt_fun(f2_nu_el_v_over_a,tit,tittxt,file,x_axis_min,x_axis_max,y_axis_min,y_axis_max,iColor,iLineStyle,1);
  std::string tittxt  = "(FA/GMV)^{2}" ;
  TF1 *fa_over_gmv_2 = new TF1("fa_over_gmv_2",FA_over_GMV_2,xmin,xmax,0);
  int iColor=3;
  int iLineStyle=2;
  plt_fun(fa_over_gmv_2,tit,tittxt,file,x_axis_min,x_axis_max,y_axis_min,y_axis_max,iColor,iLineStyle,1);
//
  sprintf(file,"CallenGross.eps");
  double x_axis_min=0.001;
  double x_axis_max=xmax;
  double y_axis_min=0.0;
  double y_axis_max=2.0;
  std::string tittxt  = "F2_e_p/2xF_e_p" ;
  TF1 *f2ep_el_over_2xf1ep = new TF1("F2ep_el_over_2xF1ep",F2ep_el_over_2xF1ep,xmin,xmax,0);
  int iColor=2;
  int iLineStyle=2;
  plt_fun(f2ep_el_over_2xf1ep,tit,tittxt,file,x_axis_min,x_axis_max,y_axis_min,y_axis_max,iColor,iLineStyle,0);
  std::string tittxt  = "F2_e_n/2xF_e_n" ;
  TF1 *f2en_el_over_2xf1en = new TF1("F2en_el_over_2xF1en",F2en_el_over_2xF1en,xmin,xmax,0);
  int iColor=4;
  int iLineStyle=2;
  plt_fun(f2en_el_over_2xf1en,tit,tittxt,file,x_axis_min,x_axis_max,y_axis_min,y_axis_max,iColor,iLineStyle,1);
  std::string tittxt  = "F2_A/2xF1_A" ;
  TF1 *f2_a_el_over_2xf1_a = new TF1("f2_a_el_over_2xf1_a",F2_A_el_over_2xF1_A,xmin,xmax,0);
  int iColor=3;
  int iLineStyle=1;
  plt_fun(f2_a_el_over_2xf1_a,tit,tittxt,file,x_axis_min,x_axis_max,y_axis_min,y_axis_max,iColor,iLineStyle,1);
  std::string tittxt  = "F2_V/2xF1_V" ;
  TF1 *f2_v_el_over_2xf1_v = new TF1("f2_v_el_over_2xf1_v",F2_V_el_over_2xF1_V,xmin,xmax,0);
  int iColor=6;
  int iLineStyle=3;
  plt_fun(f2_v_el_over_2xf1_v,tit,tittxt,file,x_axis_min,x_axis_max,y_axis_min,y_axis_max,iColor,iLineStyle,1);
  std::string tittxt  = "FA^{2}/xF1_A" ;
  TF1 *fa2_over_xf1_a_el = new TF1("fa2_over_xf1_a_el",FA2_over_xF1_A_el,xmin,xmax,0);
  int iColor=7;
  int iLineStyle=2;
  plt_fun(fa2_over_xf1_a_el,tit,tittxt,file,x_axis_min,x_axis_max,y_axis_min,y_axis_max,iColor,iLineStyle,1);
  std::string tittxt  = "GMV^{2}/xF1_V" ;
  TF1 *gmv_2_over_xf1_v_el = new TF1("gmv_2_over_xf1_v_el",GMV_2_over_xF1_V_el,xmin,xmax,0);
  int iColor=94;
  int iLineStyle=2;
  plt_fun(gmv_2_over_xf1_v_el,tit,tittxt,file,x_axis_min,x_axis_max,y_axis_min,y_axis_max,iColor,iLineStyle,1);
EOF
