#! /bin/csh -f
#
cat > CreatFun.C<<EOF
// 
Double_t f1_el_v(Double_t , Double_t );
Double_t f1_el_v(Double_t *x, Double_t *par)
{
  return elas.F1_el_V(-x[0]);
}
Double_t f1_el_a(Double_t , Double_t );
Double_t f1_el_a(Double_t *x, Double_t *par)
{
  return elas.F1_el_A(-x[0]);
}
Double_t f1_el_p(Double_t , Double_t );
Double_t f1_el_p(Double_t *x, Double_t *par)
{
  return elas.F1_el_p(-x[0]);
}
Double_t f1_el_n(Double_t , Double_t );
Double_t f1_el_n(Double_t *x, Double_t *par)
{
  return elas.F1_el_n(-x[0]);
}
Double_t f1_el(Double_t , Double_t );
Double_t f1_el(Double_t *x, Double_t *par)
{
  return elas.F1_el(-x[0]);
}
Double_t f2_el_v(Double_t , Double_t );
Double_t f2_el_v(Double_t *x, Double_t *par)
{
  return elas.F2_el_V(-x[0]);
}
Double_t f2_el_a(Double_t , Double_t );
Double_t f2_el_a(Double_t *x, Double_t *par)
{
  return elas.F2_el_A(-x[0]);
}
Double_t f2_el_p(Double_t , Double_t );
Double_t f2_el_p(Double_t *x, Double_t *par)
{
  return elas.F2_el_p(-x[0]);
}
Double_t f2_el_n(Double_t , Double_t );
Double_t f2_el_n(Double_t *x, Double_t *par)
{
  return elas.F2_el_n(-x[0]);
}
Double_t f2_el(Double_t , Double_t );
Double_t f2_el(Double_t *x, Double_t *par)
{
  return elas.F2_el(-x[0]);
}
Double_t f3_el(Double_t , Double_t );
Double_t f3_el(Double_t *x, Double_t *par)
{
  return -elas.F3_el(-x[0]);
}
Double_t r_el_v(Double_t , Double_t );
Double_t r_el_v(Double_t *x, Double_t *par)
{
  return elas.R_el_V(-x[0]);
}
Double_t r_el_a(Double_t , Double_t );
Double_t r_el_a(Double_t *x, Double_t *par)
{
  return elas.R_el_A(-x[0]);
}
Double_t r_el(Double_t , Double_t );
Double_t r_el(Double_t *x, Double_t *par)
{
  return elas.R_el(-x[0]);
}
EOF
cat > funct.C<<EOF
#include <ctype.h>
#include <string.h>
#include "Duality.h"
#include "Elastic.h"
#include "TGraph.h"
#include "TF1.h"
void plt_fun(TF1* , std::string , std::string, std::string 
 ,double ,double ,double ,double ,int ,int ,int ); 
void plt_fun(TF1* fun1 ,std::string title ,std::string txttit, std::string file
 ,double x_axis_min ,double x_axis_max ,double y_axis_min ,double y_axis_max
 ,int iColor,int iLineSty,int iEnter)
{
// nu_num states whether it is nu nub or both
//create titles
  double xtitle= 0.02;
  double ytitle=1.02;
//  double ystep = 0.10; // bound form factors
  double ystep = 0.08;
  float txtsize=0.04;
  Margin( 0.10, 0.04, 0.13, 0.12);
  if(iEnter==0)
  {
    TCanvas *c2 = new TCanvas("c2","",800,800);
    gPad->SetGrid();
    c2->Range(0,0,20,20);
    c2->SetFillColor(10);
  }
  double xlim[2];
  double ylim[2];
  xlim[0]=x_axis_min;
  xlim[1]=x_axis_max;
  ylim[0]=y_axis_min;
  ylim[1]=y_axis_max;
//  double xposit=0.1; \\bounded ff
//  double yposit=1.01; \\bounded ff
  double xposit=0.50;
  double yposit=1.00;
  double ylab_start=0.141;
  if(iEnter==0)
  {
//    TGraph  *gr2 = new TGraph(2,xlim,ylim);
    TH2F *gr2  = new TH2F("gr2", "",300,xlim[0],xlim[1],300 ,ylim[0],ylim[1]);
    FormatGraph(gr2,txtsize,txtsize+0.005,1.2,1.3);
    gr2->GetXaxis()->SetTitle("Q^{2} (GeV^{2})");
//    gr2->GetXaxis()->SetTitle("E_{#nu} (GeV)");
//   gr2->GetYaxis()->SetTitle("d#sigma/dQ^{2}");
    gr2->GetYaxis()->SetTitle("");
    gr2->Draw("AP");
    TLatex *titl = new TLatex();
    titl->SetTextSize(txtsize+0.005);
    titl->SetTextColor(1);
    double xtit=start_text(xlim,xtitle);
    double ytit=start_text(ylim,ytitle);
    titl->DrawLatex(xtit,ytit,title.c_str());
  }
// now start plotting
  double xtxt=start_text(xlim,xposit);
  double xline1=start_text(xlim,xposit-0.07);
  double xline2=start_text(xlim,xposit-0.01);
  static double ytxt;
  static double yline1;
  if(iEnter==0)
  {
    ytxt=start_text(ylim,yposit);
//    yline1=start_text(ylim,yposit+0.025); //for form factor plot
    yline1=start_text(ylim,yposit+0.015);
  }
//
  FormatFunc(fun1,iColor,iLineSty);
  fun1->SetLineWidth(5);
  fun1->Draw("same"); 
  TLatex *fun_lab1 = new TLatex();
  fun_lab1->SetTextSize(txtsize+0.0001);
  fun_lab1->SetTextColor(iColor);
  ytxt=move_text(ylim,ytxt,ystep);
  std::string text_title1;
  text_title1.append(txttit);
  fun_lab1->DrawLatex(xtxt,ytxt,text_title1.c_str());
  yline1=move_text(ylim,yline1,ystep);
//  put in line for label 
  TLine *line = new TLine(xline1,yline1,xline2,yline1);
  FormatLine(line,iColor,iLineSty);
  line->Draw();

   c2->Print(file.c_str());
}
EOF
root -b <<EOF
.L Integrate.C
.L Spline.C
.L SplineFile.C
.L Elastic.C
.L Duality.C
.L SetGraphPt.C
.L CreatFun.C
.L FormatGraph.C
.L funct.C
// this need to be here
// Reference Plots with data
// Define the objects for the functions
// neutrino
  Duality elas("nu","one","JRA_CS_HallA","Krutov","JRA_CS_HallA","JRA",1.014);
  elas.InitDuality();
  elas.WriteDuality();
  double xmin=0.001;
  double xmax=4.0;  
//
  TF1 *f1elv = new TF1("f1elv",f1_el_v,xmin,xmax,0);
  TF1 *f1ela = new TF1("f1ela",f1_el_a,xmin,xmax,0);
  TF1 *f1el  = new TF1("f1el" ,f1_el  ,xmin,xmax,0);
  TF1 *f2elv = new TF1("f2elv",f2_el_v,xmin,xmax,0);
  TF1 *f2ela = new TF1("f2ela",f2_el_a,xmin,xmax,0);
  TF1 *f2el  = new TF1("f2el" ,f2_el  ,xmin,xmax,0);
  TF1 *f3el  = new TF1("f3el" ,f3_el  ,xmin,xmax,0);
// 
  char tit[100]
  char file[100]
  sprintf(tit,"");
  std::string tittxt  = "F1_el_V" ;
  sprintf(file,"f123.eps");
  double x_axis_min=0.0;
  double x_axis_max=xmax;
  double y_axis_min=0.0;
  double y_axis_max=0.8;
  int iColor=2;
  int iLineStyle=0;
  int iEnter=0;
  plt_fun(f1elv,tit,tittxt,file,x_axis_min,x_axis_max,y_axis_min,y_axis_max,iColor,iLineStyle,0);
//
  std::string tittxt  = "F1_el_A" ;
  int iColor=4;
  int iLineStyle=2;
  plt_fun(f1ela,tit,tittxt,file,x_axis_min,x_axis_max,y_axis_min,y_axis_max,iColor,iLineStyle,1);
//
  std::string tittxt  = "F2_el_V" ;
  int iColor=3;
  int iLineStyle=1;
  plt_fun(f2elv,tit,tittxt,file,x_axis_min,x_axis_max,y_axis_min,y_axis_max,iColor,iLineStyle,1);
//
  std::string tittxt  = "F2_el_A" ;
  int iColor=6;
  int iLineStyle=2;
  plt_fun(f2ela,tit,tittxt,file,x_axis_min,x_axis_max,y_axis_min,y_axis_max,iColor,iLineStyle,1);
//
  std::string tittxt  = "F3_el" ;
  int iColor=1;
  int iLineStyle=2;
  plt_fun(f3el,tit,tittxt,file,x_axis_min,x_axis_max,y_axis_min,y_axis_max,iColor,iLineStyle,1);
//
  TF1 *relv  = new TF1("relv" ,r_el_v ,xmin,xmax,0);
  TF1 *rela  = new TF1("rela" ,r_el_a  ,xmin,xmax,0);
  TF1 *rel  =  new TF1("rel"  ,r_el    ,xmin,xmax,0);
  sprintf(file,"r_el.eps");
  double x_axis_min=0.001;
  double x_axis_max=xmax;
  double y_axis_min=-1.0;
  double y_axis_max=1.0;
  std::string tittxt  = "R_el_V" ;
  int iColor=2;
  int iLineStyle=0;
  int iEnter=0;
  plt_fun(relv,tit,tittxt,file,x_axis_min,x_axis_max,y_axis_min,y_axis_max,iColor,iLineStyle,0);
//
  std::string tittxt  = "R_el_A" ;
  int iColor=4;
  int iLineStyle=2;
  plt_fun(rela,tit,tittxt,file,x_axis_min,x_axis_max,y_axis_min,y_axis_max,iColor,iLineStyle,1);
//
  std::string tittxt  = "R_el" ;
  int iColor=3;
  int iLineStyle=2;
  plt_fun(rel,tit,tittxt,file,x_axis_min,x_axis_max,y_axis_min,y_axis_max,iColor,iLineStyle,1);
//
EOF
