#include "Duality.h"
#include "Elastic.h"
#include "Spline.h"
#include <ctype.h>
#include <cstdlib>
#include <iostream>
#include <fstream>
#include <stdio.h>
#include <cstring>
//#include <string>
#include <math.h>
Duality::Duality(char* nu_nubar
                      ,char* nucCorrectionType
                      ,char* fun_GEp
                      ,char* fun_GEn
                      ,char* fun_GMp
                      ,char* fun_GMn
                      ,double mA
                      ,double gAcon
                      ,double ml
                      ,double gPfact
                      ,double mV
                      ,double accura_int
                      ,double gfermi
                      ,double coscabibo):
Elastic(nu_nubar
       ,nucCorrectionType
       ,fun_GEp
       ,fun_GEn
       ,fun_GMp
       ,fun_GMn
       ,mA
       ,gAcon
       ,ml
       ,gPfact
       ,mV
       ,accura_int
       ,gfermi
       ,coscabibo)
{;}
void Duality::InitDuality()
{
  InitElastic();
}
void Duality::WriteDuality()
{
 WriteElastic();
}
double Duality::F1_nu_el_V(double q2)
{
  return 0.5*m_P*tau(q2)*G_M_V(q2)*G_M_V(q2);
}
double Duality::F1_nu_el_A(double q2)
{
  return 0.5*m_P*(1+tau(q2))*F_A(q2)*F_A(q2);
}
double Duality::F1_nu_el_p(double q2)
{
  return 0.5*m_P*tau(q2)*G_M_p(q2)*G_M_p(q2)+F1_nu_el_A(q2);
}
double Duality::F1_nu_el_n(double q2)
{
  return 0.5*m_P*tau(q2)*G_M_n(q2)*G_M_n(q2)+F1_nu_el_A(q2);
}
double Duality::F1_nu_el(double q2)
{
  return F1_nu_el_V(q2)+F1_nu_el_A(q2);
}
double Duality::F1_e_el_p(double q2)
{
  return 0.5*m_P*tau(q2)*G_M_p(q2)*G_M_p(q2);
}
double Duality::F1_e_el_n(double q2)
{
  return 0.5*m_P*tau(q2)*G_M_n(q2)*G_M_n(q2);
}
double Duality::F2_nu_el_V(double q2)
{
  double gev= G_E_V(q2);
  double gmv= G_M_V(q2);
  return m_P*tau(q2)*(gev*gev+tau(q2)*gmv*gmv)/(1.+tau(q2));
}
double Duality::F2_nu_el_A(double q2)
{
  return  m_P*tau(q2)*F_A(q2)*F_A(q2);
}
double Duality::F2_nu_el_p(double q2)
{
  double gep= G_E_p(q2);
  double gmp= G_M_p(q2);
  return m_P*tau(q2)*(gep*gep+tau(q2)*gmp*gmp)/(1.+tau(q2))+F2_nu_el_A(q2);
}
double Duality::F2_nu_el_n(double q2)
{
  double gen= G_E_n(q2);
  double gmn= G_M_n(q2);
  return m_P*tau(q2)*(gen*gen+tau(q2)*gmn*gmn)/(1.+tau(q2))+F2_nu_el_A(q2);
}
double Duality::F2_nu_el(double q2)
{
  return F2_nu_el_V(q2)+F2_nu_el_A(q2);
}
double Duality::F2_e_el_p(double q2)
{
  double gep= G_E_p(q2);
  double gmp= G_M_p(q2);
  return m_P*tau(q2)*(gep*gep+tau(q2)*gmp*gmp)/(1.+tau(q2));
}
double Duality::F2_e_el_n(double q2)
{
  double gen= G_E_n(q2);
  double gmn= G_M_n(q2);
  return m_P*tau(q2)*(gen*gen+tau(q2)*gmn*gmn)/(1.+tau(q2));
}
double Duality::F3_nu_el(double q2)
{
  return m_P*tau(q2)*2.0*G_M_V(q2)*F_A(q2);
}
double Duality::R_nu_el_V(double q2)
{
  double x=1.0;
  return F2_nu_el_V(q2)*(1.-4.*m_P*m_P*x*x/q2)/(2.*x*F1_nu_el_V(q2))-1.;
}
double Duality::R_nu_el_A(double q2)
{
  double x=1.0;
  return F2_nu_el_A(q2)*(1.-4.*m_P*m_P*x*x/q2)/(2.*x*F1_nu_el_A(q2))-1.;
}
double Duality::R_nu_el_p(double q2)
{
  double x=1.0;
  return F2_nu_el_p(q2)*(1.-4.*m_P*m_P*x*x/q2)/(2.*x*F1_nu_el_p(q2))-1.;
}
double Duality::R_nu_el_n(double q2)
{
  double x=1.0;
  return F2_nu_el_n(q2)*(1.-4.*m_P*m_P*x*x/q2)/(2.*x*F1_nu_el_n(q2))-1.;
}
double Duality::R_nu_el(double q2)
{
  double x=1.0;
  return F2_nu_el(q2)*(1.-4.*m_P*m_P*x*x/q2)/(2.*x*F1_nu_el(q2))-1.;
}

