//Elastic.h
// 
#ifndef ELASTIC_H
#define ELASTIC_H
#include <math.h>
#include "Integrate.h"
#include <iostream>
#include <fstream>
#include <cstring>
#include "NucCorr.h"
#include "Spline.h"
#include "SplineFile.h"
using namespace std;
    const int MAX_CHAR_LENG=100; // max lenght of char
    const double m_P=0.938919;
//  root will not accept M2=m_P*m_P;
    const double M2=0.938919*0.938919;
    const double m_pi=0.13957018;
    const double mu_p= 1.793;
    const double mu_n= -1.913;
    const double pi=3.141592653589793;
    const double hbarc2=0.389379e11; // in 10-38 cm**2
    const double very_small=1.0e-15; // doesn't crash for ratios.
    const double max_integ_times=23; // Not used
    const double q2_GEp_GMp=-6.0; //trans between where GEp is calculated
    const double q2_FF_dipole=-25.0;//trans between where FF become dipole
//
class Elastic : public NucCorr, public Integrate
{
  public:
   Elastic
   (char* nu_nubar = "nu"
   ,char* nucCorrType = "one"
   ,char* fun_GEp = "dipole"
   ,char* fun_GEn = "zero"
   ,char* fun_GMp= "dipole"
   ,char* fun_GMn = "dipole"
   ,double mA=1.00
   ,double gAcon=-1.267
   ,double ml=0.105658
   ,double gPfact=1.0
   ,double mV=0.8426150
   ,double accura_int=0.0005
   ,double gfermi=1.1803e-5
   ,double  coscabibo=0.9740);
//
   void   InitElastic();
   void   InitFF_Tsush_nucl_th_0307013();
   void   InitFF_Tsush_c12_G();
   void   InitFF_Tsush_c12_G_to_1_gt_2GeV(); // sets data file to 1 for Q^2>2GeV
   void   InitFF_Tsush_fe56_G();
   void   InitFF_Klink(); // Bill Klink form factors
   double dipole(double);
   double Olsson(double);
   double G_E_V(double);
   double G_E_p(double);// G_E_p_nucleon*Factor_times_G_E_p
   double Factor_times_G_E_p(double);// nuclear correction
   double G_E_p_nucleon(double);//For single nucleon
   double G_E_p_dipole(double);
   double G_E_p_JRA_CS(double);//May 03 version uses only powers of q**2 to 6th order
   double G_E_p_JRA_CS_7(double);//May 03 version uses only powers of q**2 to 7th order
   double G_E_p_JRA_CS_8(double);//May 03 version uses only powers of q**2 to 8th order
   double G_E_p_JRA_CS_3_03(double);// The Mar 03 version
   double G_E_p_JRA_CS_q(double); //Dec 02 uses powers of q=sqrt(-q**2)
   double G_E_p_JRA_CS_HallA(double);// May 03 version uses only powers of q**2 to 6th order
   double G_E_p_JRA_CS_HallA_7(double);// May 03 version uses only powers of q**2 to 7th order
   double G_E_p_JRA_CS_HallA_8(double);// May 03 version uses only powers of q**2 to 8th order
   double G_E_p_JRA_CS_HallA_3_03(double);// The Mar 03 version
   double G_E_p_JRA_CS_HallA_q(double); //Dec 02 uses powers of q=sqrt(-q**2)
   double G_E_p_Olsson(double);
   double G_E_p_spline(double);
   double G_E_p_AB(double);
   double G_E_p_Kelly(double);
   double G_E_n(double);// G_E_n_nucleon*Factor_times_G_E_n
   double Factor_times_G_E_n(double);// nuclear correction
   double G_E_n_nucleon(double);//For single nucleon
   double G_E_n_zero(double);
   double G_E_n_Krutov(double);
   double G_E_n_Galster(double);
   double G_E_n_JRA(double);
   double G_E_n_spline(double);
   double G_E_n_AB(double);
   double G_E_n_Kelly(double);
   double G_M_V(double);
   double G_M_p(double);// G_M_p_nucleon*Factor_times_G_M_p
   double Factor_times_G_M_p(double);// nuclear correction
   double G_M_p_nucleon(double);//For single nucleon
   double G_M_p_dipole(double);
   double G_M_p_JRA_CS(double); //May 03 version uses only powers of q**2 to 6th order
   double G_M_p_JRA_CS_7(double);//May 03 version uses only powers of q**2 to 7th order
   double G_M_p_JRA_CS_8(double);//May 03 version uses only powers of q**2 to 8th order
   double G_M_p_JRA_CS_3_03(double);// The Mar 03 version
   double G_M_p_JRA_CS_q(double); //uses powers of q=sqrt(-q**2)
   double G_M_p_JRA_CS_HallA(double); //May 03 version uses only powers of q**2 to 6th order
   double G_M_p_JRA_CS_HallA_7(double); //May 03 version uses only powers of q**2 to 7th order
   double G_M_p_JRA_CS_HallA_8(double); //May 03 version uses only powers of q**2 to 8th order
   double G_M_p_JRA_CS_HallA_3_03(double); //uses only powers of q**2
   double G_M_p_JRA_CS_HallA_q(double); //uses powers of q=sqrt(-q**2)
   double G_M_p_Olsson(double);
   double G_M_p_spline(double);
   double G_M_p_AB(double);
   double G_M_p_Kelly(double);
   double G_M_n(double);// G_M_n_nucleon*Factor_times_G_M_n
   double Factor_times_G_M_n(double);// nuclear correction
   double G_M_n_nucleon(double);//For single nucleon
   double G_M_n_dipole(double);
   double G_M_n_JRA(double);
   double G_M_n_JRA_q(double);// The old version
   double G_M_n_Kubon(double);
   double G_M_n_Olsson(double);
   double G_M_n_spline(double);
   double G_M_n_AB(double);
   double G_M_n_Kelly(double);
   double F_1_V(double);
   double Factor_times_F_1_V(double);
   double cF_2_V(double);
   double Factor_times_cF_2_V(double);
   double F_A(double);// 
   double Factor_times_F_A(double);
   double F_A_nucleon(double);// 
   double F_A_dipole(double);
   double F_A_F1_V_eq_A(double);
   double F_A_F2_V_eq_A(double);
   double F_A_spline(double);
   double F_P(double);
   double A(double);
   double B(double);
   double C(double);
   double q2_min(double);
   double q2_max(double);
   double e_lep(double, double);
   double cos_theta(double, double);
   double QE_coef(double);
   double coef_F_A_0(double, double);
   double coef_F_A_1(double, double);
   double coef_F_A_2(double, double);
   double S_U(double,double);
   double e_min();
   double q_squared(double,double,double,double);
   double dsigma_dq2(double, double);
   double sigma(double);//over full range, does not use Integrate
   double FuncToInteg(char*,double,double cPara[nSize_cPara]); //From Integrate
   double sigma_fixed_step( double);
   double Awrite(double);
   double A_q2zero();
   double tau(double);
// return the values in the constructor and other values.
   char* ret_nu_nub();
   char* ret_fun_G_E_p();
   char* ret_fun_G_E_n();
   char* ret_fun_G_M_p();
   char* ret_fun_G_M_n();
   double ret_m_A();
   double ret_g_A_con();
   double ret_m_l();
   double ret_g_P_fact();
   double ret_m_V();
   double ret_fact_G_E_p();
   double ret_fact_G_E_n();
   double ret_fact_G_M_p();
   double ret_fact_G_M_n();
   double ret_fact_F_A();
   double ret_fact_F_1_V();
   double ret_fact_cF_2_V();
   char* ret_fun_times_G_E_p();
   char* ret_fun_times_G_E_n();
   char* ret_fun_times_G_M_p();
   char* ret_fun_times_G_M_n();
   char* ret_fun_times_F_A();
   char* ret_fun_times_F_1_V();
   char* ret_fun_times_cF_2_V();
   char* ret_fun_F_A();
// Set some of the values.
   void set_m_A(double);
   void set_fact_G_E_p(double);
   void set_accurInteg(double);
   void set_fact_G_E_n(double);
   void set_fact_G_M_p(double);
   void set_fact_G_M_n(double);
   void set_fact_F_A(double);
   void set_fact_F_1_V(double);
   void set_fact_cF_2_V(double);
   void set_ff_spline_G_E_p(char*); // spline file for G_E_p
   void set_ff_spline_G_E_n(char*);
   void set_ff_spline_G_M_p(char*);
   void set_ff_spline_G_M_n(char*);
   void set_ff_spline_F_A(char*);
   void set_fun_times_G_E_p(char* fun_mult_G_E_p ="const", char* file_for_spline = "");
   void set_fun_times_G_E_n(char* fun_mult_G_E_n ="const", char* file_for_spline = "");
   void set_fun_times_G_M_p(char* fun_mult_G_M_p ="const", char* file_for_spline = "");
   void set_fun_times_G_M_n(char* fun_mult_G_M_n ="const", char* file_for_spline = "");
   void set_fun_times_F_A(char* fun_mult_F_A ="const", char* file_for_spline = "");
   void set_fun_times_F_1_V(char* fun_mult_F_1_V ="const", char* file_for_spline = "");
   void set_fun_times_cF_2_V(char* fun_mult_cF_2_V ="const", char* file_for_spline = "");
   void set_fun_F_A(char*,char*);
   void set_fun_F_A(char*);
   void WriteElastic(); 
//
  protected:
   double m_A;//old=1.032,  new=1.02, note quoted is m_A**2=1.04; 
   char nu_nub[20];// nu_num="nu"(neutrino) or nub("antineutrino")
   double accurInteg; // the  accuracy on the integation
  private:
   int i_nu_nubar; // nu_nub= "nu => i_ni_nubar=-1 and nu_nub= "nub" => i_ni_nubar= 1
   char nucCorrType[MAX_CHAR_LENG];
   char fun_G_E_p[MAX_CHAR_LENG]; //chooses G_E_p_nucleon(q2)
   char fun_G_E_n[MAX_CHAR_LENG]; //chooses G_E_n_nucleon(q2)
   char fun_G_M_p[MAX_CHAR_LENG]; //chooses G_M_p_nucleon(q2)
   char fun_G_M_n[MAX_CHAR_LENG]; //chooses G_M_n_nucleon(q2)
   char fun_F_A[MAX_CHAR_LENG]; //chooses F_A_nucleon(q2)
// factor which chooses which function to muliply the functions
// if above function is a constant then fact gives the factor;
   double g_A_con;//old = -1.23, new = -1.267;
   double m_l;//nominal value 0.105658;
   double g_P_fact;//g_P_fact=1 satisfies PCAC
   double m_V; // m_V**2=0.71
   double Gfermi;
   double cosCabibo;
// Form factor Nuclear Corrections.
//
   char fun_times_G_E_p[MAX_CHAR_LENG]; // chooses the function to mult G_E_p
   double fact_G_E_p; // if  fun_times_G_E_p="const", fact_G_E_p is the mult factor
   SplineFile splineFile_G_E_p; //Spline fit which multiplies G_E_p
//
   char fun_times_G_E_n[MAX_CHAR_LENG]; // chooses the function to mult G_E_n
   double fact_G_E_n; // if  fun_times_G_E_n="const", fact_G_E_n is the mult factor
   SplineFile splineFile_G_E_n; //Spline fit which multiplies G_E_n
//
   char fun_times_G_M_p[MAX_CHAR_LENG]; // chooses the function to mult G_M_p
   double fact_G_M_p; // if  fun_times_G_M_p="const", fact_G_M_p is the mult factor
   SplineFile splineFile_G_M_p; //Spline fit which multiplies G_M_p
//
   char fun_times_G_M_n[MAX_CHAR_LENG]; // chooses the function to mult G_M_n
   double fact_G_M_n; // if  fun_times_G_M_n="const", fact_G_M_n is the mult factor
   SplineFile splineFile_G_M_n; //Spline fit which multiplies G_M_n
//
   char fun_times_F_1_V[MAX_CHAR_LENG]; // chooses the function to mult F_1_V
   double fact_F_1_V; // if  fun_times_F_1_V="const", fact_F_1_V is the mult factor
   SplineFile splineFile_F_1_V; //Spline fit which multiplies F_1_V
//
   char fun_times_cF_2_V[MAX_CHAR_LENG]; //chooses the function to mult cF_2_V
   double fact_cF_2_V;// if  fun_times_cF_2_V="const", fact_F_1_V is the mult factor
   SplineFile splineFile_cF_2_V;//Spline fit which multiplies cF_2_V
//
   char fun_times_F_A[MAX_CHAR_LENG]; //chooses the function to mult F_A
   double fact_F_A;// if  fun_times_F_A="const", fact_F_1_V is the mult factor
   SplineFile splineFile_F_A;//Spline fit which multiplies F_A
//
   SplineFile G_E_p_Spline; //Spline Fit for G_E_p
   SplineFile G_E_n_Spline; //Spline Fit for G_E_n
   SplineFile G_M_p_Spline; //Spline Fit for G_M_p
   SplineFile G_M_n_Spline; //Spline Fit for G_M_n
   SplineFile F_A_Spline;   //Spline Fit for F_A
//
//   SplineFile splineFile_F_A;//Spline fit which multiplies F_A
// static const double cont=M2*Gfermi*Gfermi*cos2Cabibo*hbarc2/(8*pi);
};
#endif
