//Experiment.h
// note Chisquare (max like) might not work if q2 bins vary in size
// needs to be checked
#ifndef EXPERIMENT_H
#define EXPERIMENT_H
#include <iostream.h>
#include <fstream.h>
#include "Elastic.h"
#include "NucCorr.h"
#include "Spline.h"
#include "SplineArea.h"
#include "SplineFile.h"
#include "FindRoot.h"
#include <cstring>
#include <cmath>
const int NDATA = 100; //number of q**2 points for array
const int NFLUX = 200; // number of flux points
const int NWR = 0; // ********** change for printing out
const int NUM_SPLINES=40; // number of splines for flux
const int FILE_LENGTH=100; // length of the file name 
const int MAX_CHAR_LENGTH=100; // max lenght of char
const int IBIN_CHI_START=0; // the first bin used for chisquare calculation
const int IBIN_CHI_END=0; // the number of bins before the end
const double max_integ_times_q2_flux=20; //the max steps for integration.

//class Elastic;
using namespace std;
class Experiment : public Elastic, public FindRoot
{
  public:
   Experiment(char* exper = "test"
   ,char* nu_bar = "nu"
   ,char* nucCorrectionType = "one"
   ,char* fun_GEp = "dipole"
   ,char* fun_GEn = "zero"
   ,char* fun_GMp= "dipole"
   ,char* fun_GMn = "dipole"
   ,double mA=1.02
   ,double gAcon=-1.267
   ,double ml=0.105658
   ,double gPfact=1.0
   ,double mV=0.8426150
   ,double accura_int=0.0005
   ,double gfermi=1.1803e-5
   ,double  coscabibo=0.9740);
   void  InitExperiment(); //Does the calculations to initialize the arrays
   double ChiMaxl(double, char *, char *);
   int ReadDataq2(char* , float*,float*, float*,float*,float*);// Reads q2 data with err
   int ReadFluxq2(char*,float*,float*,float*,float*,float*,float*);//Read flux with pts & err
   int ReadDataq2Events(char*,float*,float*,float*,float*,float*);//Reads q2 data with events
   int ReadFluxForSpline(char*,float *,float *);// Reads flux which are curves
   double SumFlux_dsigma_dq2_thy(double);
   void GetDataFlux(); // The flux are points with errors
   void GetDataQ2(char*); // The tables are CS with errors
   void GetDataQ2_events(); // the tables is in events, ie no errors
   void WriteQ2Data();
   void FillWithSum_sig_q2_thy();
   void FillWithSpline_sig_q2_thy();
   void FillWithSpline_sig_q2_thy_integ_bin();
   void FillTheoryArrays();
   void Fill_bin_cent_ave_F_A_2_wt_coefFA2();
   void Fill_bin_cent_ave_F_A_1_wt_coefFA1();
   void Fill_ave_F_A_1_wt_coefFA1();
   void Fill_ave_F_A_2_wt_coefFA2();
   void SumSig_q2();
//   void ListChisq();
   void Write_td_file(double,int,char*);
   void Write_td_file_2(double,double,double,int,char*,double,double,double,double);// 1 or 2 theory graphs
   double StartText(double* ,double); // for topdrawer plots
   double MoveText(double* ,double , double ); // for topdrawer plots
   void Write_td_file_flux(int); // write td file of flux
   double FluxSpline(double);// flux for spline fit
   void ReadSplineFile(); // Reads file which gives information about flux files
   void WriteSplineFile(); // Writes out information from ReadSplineFile
   void CreateFluxSplines(); // Creates the spline functions
   void CreateFluxSplineArea(); // Creates the spline area functions
   void CreateQ2FuncSplines();//Create spline fit for paper's q**2 plot
   void FluxCalcEminEmax();// Gets the energy min and max from the flux;
   void Q2DataQ2minQ2max();// Gets q2 min and max for data for plots
   void Solve_F_A_by_integ_bin(); //fill in F_A_calc and F_A_error
//
   double IntegFlux_dsigma_dq2_thy( double, double, double );//q2,elo,ehi
   double IntegFlux_dsigma_dq2_thy( double);//q2, over energy determined by flux
   double Integ_dsigma_dq2_thy(double,double);//qlow,qhi (qlow>qhi), from enuMinFlux to enuMaxFlux
   double Integ_dsigma_dq2_thy(double,double,double,double );//qlow,qhi,elo,ehi(qlow>qhi)
//
   double IntegFlux_coef_F_A_0( double, double, double );//q2,elo,ehi
   double IntegFlux_coef_F_A_0( double);//q2, over energy determined by flux
   double Integ_coef_F_A_0(double,double);//qlow,qhi (qlow>qhi), from enuMinFlux to enuMaxFlux
   double Integ_coef_F_A_0(double,double,double,double );//qlow,qhi,elo,ehi(qlow>qhi)
//
   double IntegFlux_coef_F_A_1( double, double, double );//q2,elo,ehi
   double IntegFlux_coef_F_A_1( double);//q2, over energy determined by flux
   double Integ_coef_F_A_1(double,double);//qlow,qhi (qlow>qhi), from enuMinFlux to enuMaxFlux
   double Integ_coef_F_A_1(double,double,double,double );//qlow,qhi,elo,ehi(qlow>qhi)
//
   double IntegFlux_coef_F_A_2( double, double, double );//q2,elo,ehi
   double IntegFlux_coef_F_A_2( double);//q2, over energy determined by flux
   double Integ_coef_F_A_2(double,double);//qlow,qhi (qlow>qhi), from enuMinFlux to enuMaxFlux
   double Integ_coef_F_A_2(double,double,double,double );//qlow,qhi,elo,ehi(qlow>qhi)
//
   double IntegFlux_F_A_1_coef_F_A_1(double,double,double); // Integ q2 over enu_lo to enu_hi
   double IntegFlux_F_A_1_coef_F_A_1(double); // Integ q2 over enuMinFlux to enuMaxFlux
   double Integ_F_A_1_coef_F_A_1(double,double,double,double);// Integ q2_lo to q2_hi,enu_lo to enu_hi
   double Integ_F_A_1_coef_F_A_1(double,double);// Integ q2_lo to q2_hi,enuMinFlux,enuMaxFlux
//
   double IntegFlux_F_A_2_coef_F_A_2(double,double,double);// Integ q2 over enu_lo to enu_hi
   double IntegFlux_F_A_2_coef_F_A_2(double); // Integ q2 over enuMinFlux to enuMaxFlux
   double Integ_F_A_2_coef_F_A_2(double,double,double,double);// Integ q2_lo to q2_hi,enu_lo to enu_hi
   double Integ_F_A_2_coef_F_A_2(double,double);// Integ q2_lo to q2_hi,enuMinFlux,enuMaxFlux
//
   double trapzdExp(double,int,double,double,double,double);
   double FuncToInteg(char*,double,double cPara[nSize_cPara]); //From Integrate
   double Integ_F_A (double, double);
   double poly_int(double, double,double,double);//test of integration routine;
   double IntegFlux(double,double);//Integrates flux
   double FuncToFindRoot(char*,double,double cPara[nSize_cPara]); //From FindRoot
   double BinCenter_dsigma_dq2(int);
   void   Q2BinCenter();
   double BinCenter_ave_F_A_2_wt_coefFA2(int);//determ q2 FA**2=int coef_F_A_2*F_A*F_A/int coef_F_A_2 over bin
   double BinCenter_ave_F_A_1_wt_coefFA1(int);//determ q2 FA=int coef_F_A_1*F_A/int coef_F_A_1 over bin
// return some private numbers
   char* return_exper();
   double return_enuMinFlux();
   double return_enuMaxFlux();
   double return_q2MinData(); 
   double return_q2MaxData(); 
   double return_sigma_thy();
   double return_sigma_data();
   double return_sigma_data_bin();
   int    return_n_data_pt();
   double* return_Q2();
   double* return_Q2_binlo();
   double* return_Q2_binhi();
   double* return_sig_q2_data();
   double* return_sig_q2_err();
   double* return_sig_q2_thy(); 
   double* return_F_A_calc();
   double* return_F_A_error();
   double* return_Q2_bin_cent_ave_F_A_2_wt_coefFA2();// bin center ave_F_A_2_wt_coefFA2[]
   void WriteExperiment();
   double quadratic_solve(double,double,double,int); // solve quadratic 
  private:
   static const double accur_solve=0.000001; //sets accuracy of solving
   char exper[MAX_CHAR_LENGTH]; // the name of the experiment
// for graph with points for flux
   double enu[NFLUX]; 
   double enu_err[NFLUX];
   double flux[NFLUX];
   double flux_err[NFLUX];
   double totalFlux; // the sum of the flux
   double enuMinFlux; //the Flux minimal energy
   double enuMaxFlux; //the Flux Maximal energy, needed for integration
   double q2MinData; //the Min q2
   double q2MaxData; //the Max value for plots
//
   double Q2[NDATA];// Q2 of data, may be Bin centered if Q2BinCenter is called
   double Q2_binlo[NDATA];//Low value of bin
   double Q2_binhi[NDATA];//high value of bin
   double sig_q2_data[NDATA];// Value of the dsigma_q2;
   double sig_q2_err[NDATA]; // Data error on dsigma_q2
   double sig_q2_thy[NDATA]; // int flux_dsigma_dq2 over bins of data 
// to solve for F_A
   double F_A_calc[NDATA]; // calculated value of F_A
   double F_A_error[NDATA];
   double ave_F_A_2_wt_coefFA2[NDATA]; //int coef_F_A_2*F_A*F_A/int coef_F_A_2 over bin
   double ave_F_A_1_wt_coefFA1[NDATA]; //int coef_F_A_1*F_A/int coef_F_A_1 over bin
   double Q2_bin_cent_ave_F_A_1_wt_coefFA1[NDATA];// bin center ave_F_A_1_wt_coefFA1[]
   double Q2_bin_cent_ave_F_A_2_wt_coefFA2[NDATA];// bin center ave_F_A_2_wt_coefFA2[]
   double ave_bin_width;// the bin width of their histogram not counting overflow. 
   static const int num_bin_width_ave  = 5;// number of bins to get average
// sum over flux dsigma_dq2(q2)*flux*(bin width) 
// or integrate over all flux  and q2 data bin  - dsigma_dq2*flux 
   double sigma_thy; // sum of sig_q2_thy
   double sigma_data; // sum of sig_q2 (not times bin width)
   int n_data_pt; // number of q2 data points
   int n_flux_pt; // number of q2 flux points
//  for spline fits of the flux
   int num_spline; // for a spline fit the number of plots 
   double coef_of_spline[NUM_SPLINES]; 
          // factor times the spline fit for the sum of the flux
   char spline_file[NUM_SPLINES][FILE_LENGTH];
             // factor times the spline fit for the sum of the flux
   Spline spline_flux[NUM_SPLINES]; //the spline fits for the flux
   SplineFile splineQ2Func;//spline fit for q**2 function on their graph
   SplineArea spline_area_flux; //the SplineArea fits for the flux
// for a "data topdrawer plot we need flux_hist_spline = "data"
   static const char* const flux_hist_spline = "spline";//SplineArea flux 
//   static const char* const flux_hist_spline = "data"; //histogram  flux 
//   static const char* const solve_F_A_data_theory = "data";//data or theory to extract F_A
   static const char* const solve_F_A_data_theory = "theory";//data or theory to extract F_A
};
#endif
