#include "Experiment.h"
#include "Elastic.h"
#include "NucCorr.h"
#include "Spline.h"
#include <ctype.h>
#include <cstdlib>
#include <iostream>
#include <fstream>
#include <stdio.h>
#include <cstring>
//#include <string>
#include <math.h>
Experiment::Experiment(char* experi /* the experiment */
                      ,char* nu_nubar
                      ,char* nucCorrectionType
                      ,char* fun_GEp
                      ,char* fun_GEn
                      ,char* fun_GMp
                      ,char* fun_GMn
                      ,double mA
                      ,double gAcon
                      ,double ml
                      ,double gPfact
                      ,double mV
                      ,double accura_int
                      ,double gfermi
                      ,double coscabibo):
Elastic(nu_nubar
       ,nucCorrectionType
       ,fun_GEp
       ,fun_GEn
       ,fun_GMp
       ,fun_GMn
       ,mA
       ,gAcon
       ,ml
       ,gPfact
       ,mV
       ,accura_int
       ,gfermi
       ,coscabibo)
{
  strcpy(exper,experi);
  n_data_pt=0;
  n_flux_pt=0;
  num_spline=0;
}
void Experiment::InitExperiment()
{
  InitElastic();
  if(strcmp(exper,"Barish_77")==0||strcmp(exper,"Miller_82")==0||strncmp(exper,"Minerva",7)==0)
  {
    GetDataQ2("events");
    SumSig_q2();
    Q2DataQ2minQ2max();
    ReadSplineFile();
    CreateFluxSplines();
    FillWithSpline_sig_q2_thy_integ_bin();
    Q2BinCenter();
    Q2DataQ2minQ2max();
  }
  else if(strncmp(exper,"Ahrens",6)==0)
  {
    GetDataQ2("errors");
    SumSig_q2();
    Q2DataQ2minQ2max();
    ReadSplineFile();
    CreateFluxSplines();
    FillWithSpline_sig_q2_thy_integ_bin();
    Q2BinCenter();
    Q2DataQ2minQ2max();
  }
  else
  { 
//    GetDataQ2("errors");
    GetDataQ2("events"); 
    SumSig_q2();
    Q2DataQ2minQ2max();
// can either do spline or hist for flux
    if(strcmp(flux_hist_spline,"spline")==0) 
    {    
      CreateFluxSplineArea();
      FillWithSpline_sig_q2_thy_integ_bin();
      Q2BinCenter();
      Q2DataQ2minQ2max();
    }
    else
    {
      GetDataFlux();
      FillWithSum_sig_q2_thy(); // uses the sum
    }
  }
}
void Experiment::GetDataFlux()
{
  float enu_fl[NFLUX];
  float enu_lo_fl[NFLUX]; // low point of bin
  float enu_hi_fl[NFLUX]; // high point of bin
  float enu_err_fl[NFLUX];
  float flux_fl[NFLUX];
  float flux_err_fl[NFLUX];
  for(int id=0;id<NFLUX;id++)
  {
    enu_fl[id]=0;
    enu_err_fl[id]=0;
    flux_fl[id]=0;
    flux_err_fl[id]=0;
    flux[id]=0;
    enu[id]=0;
    enu_err[id]=0;
    flux_err[id]=0;
  }
  char file2[MAX_CHAR_LENGTH] = "q2data/flux_" ;
  strncat(file2,exper,MAX_CHAR_LENGTH);
  strncat(file2,".dat",MAX_CHAR_LENGTH);
  cout<< " ( flux file ="<<file2<<" in GetDataFlux"<<endl;
//n_flux_pt = ReadFluxq2(file2.c_str(),enu_fl,enu_err_fl,flux_fl,flux_err_fl);
  n_flux_pt = ReadFluxq2
     (file2,enu_fl,enu_err_fl,enu_lo_fl,enu_hi_fl,flux_fl,flux_err_fl);
  for (int i=0; i<n_flux_pt;i++)
  {
    enu[i]=enu_fl[i];
    enu_err[i]=enu_err_fl[i];
    flux[i]=flux_fl[i];
    flux_err[i]=flux_err_fl[i];
  }
  if(NWR>0)
  {
    cout<<" Flux "<<endl;
    cout<<" file =  "<<file2<<endl;
    cout<<"n_flux_pt="<<n_flux_pt<<endl;
    for (int i=0; i<n_flux_pt;i++)
    {
//    cout<<enu[i]<<" "<<enu_err[i]<<" "<<flux[i]<<" "<<flux_err[i]<<endl;
     cout<<enu_lo_fl[i]<<" "<<enu_fl[i]<<" "<<enu_hi_fl[i]<<" "<<flux[i]<<endl;
//    cout<<enu[i]<<" "<<enu_err[i]<<" "<<flux[i]<<" "<<flux_err[i]
//      <<" "<<enu_lo_fl[i]<<" "<<enu_fl[i]<<" "<<enu_hi_fl[i]<<" "<<flux[i]<<endl;
    }
  }
}
void Experiment::CreateFluxSplineArea()
{
  char file[MAX_CHAR_LENGTH] = "q2data/flux_spline_area_" ;
  strncat(file,exper,MAX_CHAR_LENGTH);
  strncat(file,".dat",MAX_CHAR_LENGTH);
  cout<<" ( flux file ="<<file<<" in CreateFluxSplineArea"<<endl;
  spline_area_flux.PutDataInSplineAreaObj(file);
  FluxCalcEminEmax();
}
//
void Experiment::GetDataQ2(char* error_events)
// if error_events = events the data plots is in number of events
// if error_events = errors, there were errors on the plots.
{
  float Q2_fl[NDATA];
  float sig_q2_fl[NDATA];
  float sig_q2_err_fl[NDATA];
  float  Q2_binlo_fl[NDATA];
  float  Q2_binhi_fl[NDATA];
  for(int id=0;id<NDATA;id++)
  {
    Q2_fl[id]=0;
    Q2_binlo_fl[id]=0;
    Q2_binhi_fl[id]=0;
    sig_q2_fl[id]=0;
    sig_q2_err_fl[id]=0;
    Q2[id]=0;
    sig_q2_data[id]=0;
    sig_q2_err[id]=0;
  }
  char file1[MAX_CHAR_LENGTH] = "q2data/q2_" ;
  strncat(file1,nu_nub,MAX_CHAR_LENGTH);
  strncat(file1,"_",MAX_CHAR_LENGTH);
  strncat(file1,exper,MAX_CHAR_LENGTH);
  strncat(file1,".dat",MAX_CHAR_LENGTH);
  if(strcmp( error_events,"events")==0 )
  {
    n_data_pt = ReadDataq2Events(file1,Q2_fl,Q2_binlo_fl,Q2_binhi_fl,sig_q2_fl,sig_q2_err_fl);
  }
  else if( strcmp(error_events,"errors")==0 )
  {
    n_data_pt = ReadDataq2(file1,Q2_fl,Q2_binlo_fl,Q2_binhi_fl,sig_q2_fl,sig_q2_err_fl);
  }
  else
  {
     cout<<" GetDataQ2 parameter incorrect ="<<error_events<<endl;
     exit(1);
  }
  for (int i=0; i<n_data_pt;i++)
  {
    Q2[i]=Q2_fl[i];
    Q2_binlo[i]=Q2_binlo_fl[i];
    Q2_binhi[i]=Q2_binhi_fl[i];
    sig_q2_data[i]=sig_q2_fl[i];
    sig_q2_err[i]=sig_q2_err_fl[i];
  }
  ave_bin_width=0;
// use the first num_bin_width_ave bins to find the average bin width.
  int n_ave_bin_wid = n_data_pt-1 < num_bin_width_ave ? n_data_pt-1 : num_bin_width_ave ;
  for (int i=1; i<n_ave_bin_wid;i++)
  {
    ave_bin_width=((i-1)*ave_bin_width+Q2_binhi[i]-Q2_binlo[i])/i; 
  }
  if(NWR>0)
  { 
    cout<<"q2 data "<<endl;
    cout<<"file =  "<<file1<<endl;
    cout<<"n_data_pt = "<<n_data_pt<<endl;
    for (int i=0; i<n_data_pt;i++)
    {
      cout<<i+1<<" "<<Q2[i]<<" "<< Q2_binlo[i]<<" "<<Q2_binhi[i]<<" "
          <<sig_q2_data[i]<<" "<<sig_q2_err[i]<<endl;
    }
  }
}
void Experiment::FillWithSum_sig_q2_thy()
//dsigma_dq2 summed over flux times with of bin
{
  if(NWR>0)
  {
    cout<<" Calculate theory"<<endl;
  }
  sigma_thy=0;
  for (int i_data_pt=0;i_data_pt<n_data_pt;i_data_pt++)
  {
    sig_q2_thy[i_data_pt]=SumFlux_dsigma_dq2_thy(-Q2[i_data_pt])
           *(Q2_binhi[i_data_pt]-Q2_binlo[i_data_pt]);
    if(i_data_pt>=ibin_chi_start&&i_data_pt<n_data_pt-ibin_chi_end)
    {
      sigma_thy+=sig_q2_thy[i_data_pt];
    }
    if(i_data_pt<NWR)
    {
      cout<<i_data_pt<<" theory="<<sig_q2_thy[i_data_pt]<<" sigma_thy="<<sigma_thy<<endl;
    } 
  } 
}
void Experiment::FillWithSpline_sig_q2_thy()
//  FillWithSpline_sig_q2_thy is superseeded by 
//  FillWithSpline_sig_q2_thy_integ_bin() which integrates over the bin
{
  sigma_thy=0;
  if(NWR>0)
  {
    cout<<" Calculate theory in FillWithSpline_sig_q2_thy"<<endl;
  }
  for (int i_data_pt=0;i_data_pt<n_data_pt;i_data_pt++)
  {
    sig_q2_thy[i_data_pt]=IntegFlux_dsigma_dq2_thy(-Q2[i_data_pt])
                          *(Q2_binhi[i_data_pt]-Q2_binlo[i_data_pt]);
    if(i_data_pt>=ibin_chi_start&&i_data_pt<n_data_pt-ibin_chi_end)
    {
      sigma_thy+=sig_q2_thy[i_data_pt];
    }
    if(i_data_pt<NWR)
    {
      cout<<i_data_pt<<" theory="<<sig_q2_thy[i_data_pt]<<" sigma_thy="<<sigma_thy<<endl;
    } 
  } 
  if(0<NWR)
  {
    cout<<" sigma_thy="<<sigma_thy<<" sigma_data= "<<sigma_data<<endl;
  } 
}
void Experiment::FillWithSpline_sig_q2_thy_integ_bin()
//  FillWithSpline_sig_q2_thy is superseeded by 
//  FillWithSpline_sig_q2_thy_integ_bin() which integrates over the bin
{
  sigma_thy=0;
  if(NWR>0)
  {
    cout<<" Calculate theory in FillWithSpline_sig_q2_thy_integ_bin"<<endl;
  }
  for (int i_data_pt=0;i_data_pt<n_data_pt;i_data_pt++)
  {
    sig_q2_thy[i_data_pt]
    =Integ_dsigma_dq2_thy(-Q2_binlo[i_data_pt],-Q2_binhi[i_data_pt]);
    if(i_data_pt>=ibin_chi_start&&i_data_pt<n_data_pt-ibin_chi_end)
    {
      sigma_thy+=sig_q2_thy[i_data_pt];
    }
    if(i_data_pt<NWR)
    {
      cout<<i_data_pt<<" theory="<<sig_q2_thy[i_data_pt]<<" sigma_thy="<<sigma_thy<<endl;
    } 
  } 
  if(0<NWR)
  {
    cout<<" sigma_thy="<<sigma_thy<<" sigma_data= "<<sigma_data<<endl;
  }
}
void Experiment::Solve_F_A_by_integ_bin()
{
  Fill_ave_F_A_1_wt_coefFA1();// fills ave_F_A_1_wt_coefFA1[]
// find bin center of ave_F_A_1_wt_coefFA1[]
  Fill_bin_cent_ave_F_A_1_wt_coefFA1();//fills Q2_bin_cent_ave_F_A_1_wt_coefFA1[]
  Fill_ave_F_A_2_wt_coefFA2();//fills ave_F_A_2_wt_coefFA2[]
// find bin center of ave_F_A_2_wt_coefFA2[]
  Fill_bin_cent_ave_F_A_2_wt_coefFA2();//fills Q2_bin_cent_ave_F_A_2_wt_coefFA2[]
// F_A is plotted at Q2_bin_cent_ave_F_A_2_wt_coefFA2[]
  int ibin=3;
//  for (int i_data_pt=ibin_chi_start+ibin;i_data_pt<ibin_chi_start+ibin+1;i_data_pt++)
  for (int i_data_pt=ibin_chi_start;i_data_pt<n_data_pt-ibin_chi_end;i_data_pt++)
  {
    double q2=-Q2[i_data_pt];
    double q2_lo=-Q2_binlo[i_data_pt];
    double q2_hi=-Q2_binhi[i_data_pt];
    double coef_FA2=(sigma_data/sigma_thy)*Integ_coef_F_A_2(q2_lo,q2_hi);
    double coef_FA1=(sigma_data/sigma_thy)*Integ_coef_F_A_1(q2_lo,q2_hi);
    double coef_FA0=(sigma_data/sigma_thy)*Integ_coef_F_A_0(q2_lo,q2_hi);
    double sig_q2_thy_nor =(sigma_data/sigma_thy)*sig_q2_thy[i_data_pt];
    double sig_q2_data_nor = sig_q2_data[i_data_pt];
    double del_F_A= F_A(-Q2_bin_cent_ave_F_A_1_wt_coefFA1[i_data_pt])
                   -F_A(-Q2_bin_cent_ave_F_A_2_wt_coefFA2[i_data_pt]);
//  solve using theory as data
    double c_coef=coef_FA0 + del_F_A*coef_FA1 - sig_q2_thy_nor;
    double F_A_calc_thy=quadratic_solve(coef_FA2,coef_FA1,c_coef,-1);
    if(strcmp(solve_F_A_data_theory,"theory")==0 )
    {
      F_A_calc[i_data_pt]=F_A_calc_thy;
    }
    else if( strcmp(solve_F_A_data_theory,"data")==0 )
    {
      c_coef = coef_FA0 + del_F_A*coef_FA1-sig_q2_data_nor;
      F_A_calc[i_data_pt]=quadratic_solve(coef_FA2,coef_FA1,c_coef,-1);
    }
    else
    {
       cout<<" Solve_F_A_by_integ_bin parameter incorrect="<<solve_F_A_data_theory<<endl;
       exit(1);
    }
    if(F_A_calc[i_data_pt]==very_small)
    {
      cout<<" FA "<<i_data_pt<<" bin has no solution"<<endl;
    }
    double dFA_dsigma = 1.0/(2.0*coef_FA2*F_A_calc_thy+coef_FA1);
    if(dFA_dsigma<0)
    {
      dFA_dsigma=-dFA_dsigma;
    }
    double dsigma_dq2_error=sqrt(sigma_data*sig_q2_thy[i_data_pt]/sigma_thy); 
    F_A_error[i_data_pt] = dFA_dsigma*dsigma_dq2_error;
// lets write stuff out
    if(i_data_pt<NWR)
    {
      cout<<" Bin number = "<<i_data_pt<<endl;
      cout<<"   q2 = "<<q2<<endl;
      cout<<"   q2_lo = "<<q2_lo<<endl;
      cout<<"   q2_hi = "<<q2_hi<<endl;
      cout<<"   q2_bc_ave_F_A_1_wt_coefFA1 = "<<-Q2_bin_cent_ave_F_A_1_wt_coefFA1[i_data_pt];
      cout<<"   q2_bc_ave_F_A_2_wt_coefFA2 = "<<-Q2_bin_cent_ave_F_A_2_wt_coefFA2[i_data_pt];
      double  q2_bc_FA2 = -Q2_bin_cent_ave_F_A_2_wt_coefFA2[i_data_pt] ; 
      cout<<"   coef_FA2 = "<<coef_FA2<<endl;
      cout<<"   coef_FA2*F_A*F_A = "<<coef_FA2*F_A(q2_bc_FA2)*F_A(q2_bc_FA2)<<endl;
      cout<<"   coef_FA1 = "<<coef_FA1<<endl;
      cout<<"   coef_FA1*F_A = "<<coef_FA1*F_A(q2_bc_FA2)<<endl;
      cout<<"   coef_FA0 = "<<coef_FA0<<endl;
      cout<<"   sig_q2_thy_nor = "<<sig_q2_thy_nor<<endl;
      cout<<"   sig_q2_data_nor = "<<sig_q2_data_nor<<endl;
      cout<<"   F_A_calc = "<<F_A_calc[i_data_pt]<<endl;
      cout<<"   F_A(Q2_bin_cent_ave_F_A_2_wt_coefFA2) = "<<F_A(q2_bc_FA2)<<endl;
      if(strcmp(solve_F_A_data_theory,"theory")==0 )
      {
        cout<<"   coef_FA1**2-4*(coef_FA0-sig_q2_nor)*coef_FA2 = "
       <<coef_FA1*coef_FA1-4.0*coef_FA2*(coef_FA0+del_F_A*coef_FA1-sig_q2_thy_nor)<<endl;
        cout<<"   diff solu = "<< coef_FA2*F_A_calc[i_data_pt]*F_A_calc[i_data_pt] 
         + coef_FA1*F_A_calc[i_data_pt]+del_F_A*coef_FA1+coef_FA0-sig_q2_thy_nor<<endl;
        cout<<"   diff pnt  = "<< coef_FA2*F_A(q2_bc_FA2)*F_A(q2_bc_FA2) 
         + coef_FA1*F_A(q2_bc_FA2) +del_F_A*coef_FA1+coef_FA0 -  sig_q2_thy_nor<<endl;
      }
      else if( strcmp(solve_F_A_data_theory,"data")==0 )
      {
        cout<<"   coef_FA1**2-4*(coef_FA0-sig_q2_nor)*coef_FA2 = "
        <<coef_FA1*coef_FA1-4.0*coef_FA2*(coef_FA0+del_F_A*coef_FA1-sig_q2_data_nor)<<endl;
        cout<<"   diff solu = "<< coef_FA2*F_A_calc[i_data_pt]*F_A_calc[i_data_pt] 
        + coef_FA1*F_A_calc[i_data_pt] + coef_FA0 +del_F_A*coef_FA1-  sig_q2_data_nor<<endl;
        cout<<"   diff pnt  = "<< coef_FA2*F_A(q2_bc_FA2)*F_A(q2_bc_FA2) 
        + coef_FA1*F_A(q2_bc_FA2) + coef_FA0+del_F_A*coef_FA1 -  sig_q2_data_nor<<endl;
      }
      cout<<"   dFA_dsigma = "<<dFA_dsigma <<endl;
      cout<<"   dsigma_dq2_error = "<<dsigma_dq2_error<<endl;
      cout<<"   FA_error =  "<<F_A_error[i_data_pt] <<endl;
    } 
  } 
}
double Experiment::quadratic_solve(double a,double b,double c, int neg_pos)
{
  double co_factor=b*b-4.0*a*c;
  if(co_factor<0)
  {
    cout<<" cofactor < 0, a = "<<a<<", b = "<<b<<", c ="<<c<<endl;
    return very_small;
  }
  return (-b + neg_pos*pow(co_factor,0.5))/(2.0*a);
}
void Experiment::SumSig_q2()
// sum of sig_q2_data*(bin width)
{
  sigma_data=0;
  for (int i_data_pt=ibin_chi_start;i_data_pt<n_data_pt-ibin_chi_end;i_data_pt++)
  {
    sigma_data+=sig_q2_data[i_data_pt];
  }
}
void Experiment::Q2DataQ2minQ2max()
{
  q2MinData=Q2[0];
  q2MaxData=Q2[n_data_pt-1];
}
void Experiment::FillTheoryArrays()
// a may have changed
{
  if(strcmp(exper,"Barish_77")==0||strcmp(exper,"Miller_82")==0||strncmp(exper,"Minerva",7)==0||strncmp(exper,"Ahrens_87",9)==0)
  {
//  FillWithSpline_sig_q2_thy();
    FillWithSpline_sig_q2_thy_integ_bin();
  }
  else
  { 
    if(strcmp(flux_hist_spline,"spline")==0)
    {
      FillWithSpline_sig_q2_thy_integ_bin();
    }
    else
    {
      FillWithSum_sig_q2_thy(); // uses the sem
    }
  }
  SumSig_q2();
}
double Experiment::ChiMaxl(double norm, char* chi_maxl, char* data_theory)
// Calculates max likely hood or chis
// norm - scales the theory
// chi_maxl decided between chisquare or maximum likelyhood
// data_thy=theory uses data for the errors, otherwise the array
{
  double sum=0.0;
  FillTheoryArrays();
  for(int i_data_pt=ibin_chi_start;i_data_pt<n_data_pt-ibin_chi_end; i_data_pt++)
  {
    double sig_q2_thy_nor =  norm*sigma_data*sig_q2_thy[i_data_pt]/sigma_thy;
    double sig_q2_data_nor = sig_q2_data[i_data_pt];
    if(strcmp(chi_maxl,"chi")==0)
    {
      double error;
      if (strcmp(data_theory,"data")==0) 
      {
        error=sig_q2_err[i_data_pt];
      }
      else
      {
        error=sqrt(sigma_data*sig_q2_thy[i_data_pt]/sigma_thy); // could be wrong
      }
      sum+=pow((sig_q2_thy_nor-sig_q2_data[i_data_pt])/error,2);
      if(NWR>0)
      { 
        cout<<" i_data_pt = "<<i_data_pt<<", sig_q2_data_nor = "<<sig_q2_data_nor
            <<", sig_q2_thy_nor = "<<sig_q2_thy_nor
           <<" error = "<<error<<" sum  =  "<<sum<<endl;
      }
    }
    else if(strcmp(chi_maxl,"maxl")==0)
    {
      double term_ln;
      if(sig_q2_data_nor!=0)
      {
        term_ln=2.0*sig_q2_data_nor*log(sig_q2_data_nor/sig_q2_thy_nor);
      }
      else
      {
        term_ln=0;
      }
      double term_like=2.0*(sig_q2_thy_nor-sig_q2_data_nor)+term_ln;
      sum+=term_like;
//      cout<<sig_q2_data_nor<<" "<<sig_q2_thy_nor<<" "<<term_like<<" "<<sum<<endl;
    }
    else 
    {
      cout<<" parameter for chisq or max like bad ="<<chi_maxl<<endl;
      exit(1);
    }
    if(i_data_pt<NWR)
    {
      cout<<" theory_nor="<<sig_q2_thy_nor<<" data="<<sig_q2_data[i_data_pt]
        <<" error="<<sig_q2_err[i_data_pt]<<" sum="<<sum<<endl;
    }
  }
  return sum;
}
void Experiment::Write_td_file(double xNorm,int numThyPts,char* err_evt)
{
  cout<<" set font duplex"<<endl;
  cout<<" title top \' N0M1 + n R p + M2-3,  M0A1="<<m_A<<", " <<exper<<"\'  size 3.0"<<endl;
  cout<<" case      \' GXGX     W     GX X    X X   \'"<<endl;
  cout<<" title left \' \' size 3.0"<<endl;
  cout<<" title bottom \' Q223 (GeV/c)223 \' size 3.0 "<<endl; 
  cout<<" case         \'  X X        X X \'" <<endl;
  cout<<" set label size 2.5"<<endl;
  cout<<" set intensity 2"<<endl;
  cout<<" set tick size 0.05"<<endl;
  cout<<" set symbol size 2.0"<<endl;
  cout<<" set bar size 0"<<endl;
  cout<<" set symbol 5O"<<endl;
  cout<<" set title size 2.5"<<endl;
  cout<<" set limit x 0.00 "<<q2MaxData+0.2<<" y  0.00  80.0"<<endl;
  cout<<" set color white"<<endl;
  cout<<" 100. 8000."<<endl;
  cout<<" plot"<<endl;
  cout<<" set scale x lin"<<endl;
  if(strcmp(err_evt,"events")==0)
  {
    cout<<" set order x y "<<endl;
  }
  else
  {
    cout<<" set order x y dy "<<endl;
  }
  for (int i_data_pt=0; i_data_pt<n_data_pt; i_data_pt++)
  {
    if(strcmp(err_evt,"events")==0)
    {
      cout<<Q2[i_data_pt]<<" "<<sig_q2_data[i_data_pt]<<endl;
    }
    else
    {
      cout<<Q2[i_data_pt]<<" " <<sig_q2_data[i_data_pt]<<"  "
       <<sig_q2_err[i_data_pt]<<endl;
    }
  }
  if(strcmp(err_evt,"events")==0)
  {
    cout<<"hist"<<endl;
  }
  else
  {
    cout<<"plot"<<endl;
  }
  cout<<" set color red"<<endl;
  double Q2low=0.02;
  double Q2hi=Q2[n_data_pt-ibin_chi_end-1];
  double Q2step= (Q2hi-Q2low)/(numThyPts-1);
  double xnor =sigma_data*ave_bin_width/sigma_thy;
  for(int i_data_pt=0; i_data_pt<numThyPts;i_data_pt++)
  {
    double Qsqar=Q2low+i_data_pt*Q2step; 
    if(strcmp(flux_hist_spline,"spline")==0) 
    {    
      cout<<Qsqar<<" "<<xNorm*xnor*IntegFlux_dsigma_dq2_thy(-Qsqar)<<endl; 
    }
    else
    {
      cout<<Qsqar<<" "<<xNorm*xnor*SumFlux_dsigma_dq2_thy(-Qsqar)<<endl; 
    }
  }
  cout<<" set intensity 2"<<endl;
  cout<<"join dash"<<endl;
// now put their plot on the graph
  CreateQ2FuncSplines();
  Q2low=splineQ2Func.Return_xMinSpline();
  Q2hi=splineQ2Func.Return_xMaxSpline();
  Q2step= (Q2hi-Q2low)/(numThyPts-1);
  cout<<" set color blue"<<endl;
  for(int i_data_pt=0; i_data_pt<numThyPts;i_data_pt++)
  {
    double Qsqar=Q2low+i_data_pt*Q2step; 
    cout<<Qsqar<<" "<<splineQ2Func.Splint(Qsqar)<<endl; 
  }
  cout<<" set intensity 5"<<endl;
  cout<<"join dots"<<endl;

}
void Experiment::Write_td_file_2(double xNorm1, double xNorm2, double mass_a 
,int numThyPts,char* err_evt, double ylim, double xtext, double ytext, double ystep)
// Makes topdrawer plot
// xNorm1is the normalization of the  default ma  plot 
// xNorm2 is the normalization of the ma plot 
// mass_a is a new ma mass, if ma=0 don't do the plot
// numThyPts is the number of points for the plot
// err_evt states whether the errors are put on the plot or histogram
// ylim is the y limit of the plot
// xtext - is the x start of the labels
// ytext is the y start of the labels
// ystep moves the labels
{

  double xAxisLimit[2];
  double yAxisLimit[2];
  xAxisLimit[0]=0;
  xAxisLimit[1]=q2MaxData+0.2;
  yAxisLimit[0]=0;
  yAxisLimit[1]=ylim;
  double y_line_up=0.01; // length the line is above the text
  double x_line_len=0.08;// the length of the line
  double x_space=0.02; //the space between the line and the text
// need to convert the above into top drawer data corrdinates
  double y_line_up_data=y_line_up*(yAxisLimit[1]-yAxisLimit[0]); 
  double x_line_len_data=x_line_len*(xAxisLimit[1]-xAxisLimit[0]); 
  double x_space_data=x_space/(xAxisLimit[1]-xAxisLimit[0]); 
// OK, we have some of the parameters for the td plot, now start the plot
  cout<<" set font duplex"<<endl;
//  cout<<" title top \' N0M1 + n R p + M2-3,  M0A1="<<m_A<<", " <<exper<<"\'  size 3.0"<<endl;
//  cout<<" case      \' GXGX     W     GX X    X X   \'"<<endl;
  cout<<" title top \' N0M1 + n R p + M2-3, "<<exper<<"\'  size 3.0"<<endl;
  cout<<" case      \' GXGX     W     GX X  \'"<<endl;
  cout<<" title left \' \' size 3.0"<<endl;
  cout<<" title bottom \' Q223 (GeV/c)223 \' size 3.0 "<<endl; 
  cout<<" case         \'  X X        X X \'" <<endl;
  cout<<" set label size 2.5"<<endl;
  cout<<" set intensity 2"<<endl;
  cout<<" set tick size 0.05"<<endl;
  cout<<" set symbol size 2.0"<<endl;
  cout<<" set bar size 0"<<endl;
  cout<<" set symbol 5O"<<endl;
  cout<<" set title size 2.5"<<endl;
  cout<<" set limit x "<<xAxisLimit[0]<<" "<<xAxisLimit[1]
	  <<" y "<<yAxisLimit[0]<<" "<<yAxisLimit[1]<<endl;
  cout<<" set color white"<<endl;
  cout<<" 100. 8000."<<endl;
  cout<<" plot"<<endl;
  cout<<" set scale x lin"<<endl;
  if(strcmp(err_evt,"events")==0)
  {
    cout<<" set order x y "<<endl;
  }
  else
  {
    cout<<" set order x y dy "<<endl;
  }
  for (int i_data_pt=0; i_data_pt<n_data_pt; i_data_pt++)
  {
    if(strcmp(err_evt,"events")==0)
    {
      cout<<Q2[i_data_pt]<<" "<<sig_q2_data[i_data_pt]<<endl;
    }
    else
    {
      cout<<Q2[i_data_pt]<<" " <<sig_q2_data[i_data_pt]<<"  "
       <<sig_q2_err[i_data_pt]<<endl;
    }
  }
  if(strcmp(err_evt,"events")==0)
  {
    cout<<"hist"<<endl;
  }
  else
  {
    cout<<"plot"<<endl;
  }
// now put their plot on the graph
  CreateQ2FuncSplines();
  double Q2low=splineQ2Func.Return_xMinSpline();
  double Q2hi=splineQ2Func.Return_xMaxSpline();
  double Q2step= (Q2hi-Q2low)/(numThyPts-1);
  cout<<" set color blue"<<endl;
  for(int i_data_pt=0; i_data_pt<numThyPts;i_data_pt++)
  {
    double Qsqar=Q2low+i_data_pt*Q2step; 
    cout<<Qsqar<<" "<<splineQ2Func.Splint(Qsqar)<<endl; 
  }
  cout<<" set intensity 5"<<endl;
  cout<<"join dots"<<endl;
  double xtxt=StartText(xAxisLimit,xtext);   
  double ytxt=StartText(yAxisLimit,ytext);   
  cout<< xtxt<<" "<<ytxt<<endl;
  cout<< xtxt+x_line_len_data<<" "<<ytxt<<endl; 
  cout<<"join dots"<<endl;
  cout<<" set intensity 2"<<endl;
  cout<<" title " <<xtxt+x_line_len_data+x_space<<" "<<ytxt-y_line_up
            <<" data \' Their calculation M0A1="<<m_A<<"\'"<<endl;
    cout<<" case     \'                    X X   \'"<<endl;
// put our calculation on the plot
  cout<<" set color red"<<endl;
  Q2low=0.02;
  Q2hi=Q2[n_data_pt-ibin_chi_end-1];
  Q2step= (Q2hi-Q2low)/(numThyPts-1);
  double xnor =sigma_data*ave_bin_width/sigma_thy;
  for(int i_data_pt=0; i_data_pt<numThyPts;i_data_pt++)
  {
    double Qsqar=Q2low+i_data_pt*Q2step; 
    if(strcmp(flux_hist_spline,"spline")==0) 
    {    
      cout<<Qsqar<<" "<<xNorm1*xnor*IntegFlux_dsigma_dq2_thy(-Qsqar)<<endl; 
    }
    else
    {
      cout<<Qsqar<<" "<<xNorm1*xnor*SumFlux_dsigma_dq2_thy(-Qsqar)<<endl; 
    }
  }
  cout<<" set intensity 4"<<endl;
  cout<<"join dash"<<endl;
  ytxt=MoveText(yAxisLimit,ytxt,ystep);   
  cout<< xtxt<<" "<<ytxt<<endl;
  cout<< xtxt+x_line_len_data<<" "<<ytxt<<endl; 
  cout<<"join dash"<<endl;
  cout<<" set intensity 4"<<endl;
  cout<<" title " <<xtxt+x_line_len_data+x_space<<" "<<ytxt-y_line_up
	  <<" data \' Our calculation M0A1="<<m_A<<"\'"<<endl; 
  cout<<" case     \'                  X X   \'"<<endl;
// now plot mass_a if mass_a>0 
  if(mass_a>0)
  {
    double mA_old=ret_m_A();  
    set_m_A(mass_a);
    FillTheoryArrays();
    cout<<" set color magenta"<<endl;
    Q2low=0.02;
    Q2hi=Q2[n_data_pt-ibin_chi_end-1];
    Q2step= (Q2hi-Q2low)/(numThyPts-1);
    double xnor =sigma_data*ave_bin_width/sigma_thy;
    for(int i_data_pt=0; i_data_pt<numThyPts;i_data_pt++)
    {
      double Qsqar=Q2low+i_data_pt*Q2step; 
      if(strcmp(flux_hist_spline,"spline")==0) 
      {    
        cout<<Qsqar<<" "<<xNorm2*xnor*IntegFlux_dsigma_dq2_thy(-Qsqar)<<endl; 
      }
      else
      {
        cout<<Qsqar<<" "<<xNorm2*xnor*SumFlux_dsigma_dq2_thy(-Qsqar)<<endl; 
      }
    }
    cout<<" set intensity 4"<<endl;
    cout<<"join "<<endl;
    ytxt=MoveText(yAxisLimit,ytxt,ystep);   
    cout<< xtxt<<" "<<ytxt<<endl;
    cout<< xtxt+x_line_len_data<<" "<<ytxt<<endl; 
    cout<<"join "<<endl;
    cout<<" set intensity 4"<<endl;
    cout<<" title " <<xtxt+x_line_len_data+x_space<<" "<<ytxt-y_line_up
  	  <<" data \' Our calculation M0A1="<<m_A<<"\'"<<endl; 
    cout<<" case     \'                  X X   \'"<<endl;
  }
}
double Experiment::StartText(double* axisLimit,double position)
{
	  return axisLimit[0]*(1.0-position)+axisLimit[1]*position;
}
double Experiment::MoveText(double* axisLimit,double start_txt, double step)
{
	  return start_txt-(axisLimit[1]-axisLimit[0])*step;
}
void Experiment::Write_td_file_flux(int numThyPts)
{
  cout<<" set font duplex"<<endl;
  cout<<" title top ! QE Scattering, "
    <<exper<<", "<<ret_nu_nub()<<", Flux !  size 3.0"<<endl;
  cout<<" title left ! ! size 3.0"<<endl;
  cout<<" title bottom ! E_nu ! size 3.0"<<endl;
  cout<<" set label size 2.5"<<endl;
  cout<<" set intensity 2"<<endl;
  cout<<" set tick size 0.05"<<endl;
  cout<<" set symbol size 2.0"<<endl;
  cout<<" set bar size 0"<<endl;
  cout<<" set symbol 5O"<<endl;
  cout<<" set title size 2.5"<<endl;
  cout<<" set scale x lin"<<endl;
  cout<<" set scale y log"<<endl;
  cout<<" set limit x 0.00 "<<enuMaxFlux<<" y  0.00001  10.0"<<endl;
  cout<<" set color white"<<endl;
  cout<<" 100. 8000."<<endl;
  cout<<" plot"<<endl;
  cout<<" set order x y "<<endl;
  cout<<" set color red"<<endl;
  double e_low=0.0;
  double e_high=enuMaxFlux+0.2;
  double e_step= (e_high-e_low)/(numThyPts-1);
  double sigma_thy_sum=0;
  double xnor=(numThyPts*sigma_data)/(n_data_pt*sigma_thy_sum);
  for(int i_data_pt=0; i_data_pt<numThyPts;i_data_pt++)
  {
    double e_val=e_low+i_data_pt*e_step; 
    cout<<e_val<<" "<<FluxSpline(e_val)<<endl; 
  }
  cout<<"join"<<endl;
}
double Experiment::SumFlux_dsigma_dq2_thy(double q2)
//sum of  cross section(q2)*(flux bins)*(width of flux bin)
{
  double tot_flux=0;
  for(int i_flux_pt=0;i_flux_pt<n_flux_pt;i_flux_pt++)
  {
    tot_flux+=2.0*enu_err[i_flux_pt]*flux[i_flux_pt];
  }
//  cout<<" tot_flux="<<tot_flux<<endl;
  double flx;
  double sig=0;
  for(int i_flux_pt=0;i_flux_pt<n_flux_pt;i_flux_pt++)
  {
//    flx=(2.0*enu_err[i_flux_pt]*flux[i_flux_pt])/tot_flux;
    flx=(2.0*enu_err[i_flux_pt]*flux[i_flux_pt]);
    sig+=dsigma_dq2(q2,enu[i_flux_pt])*flx;
//  cout<<" flx="<<flx<<" enu="<<enu[i_flux_pt]
//  <<" dsigma_dq2="<<dsigma_dq2(q2,  enu[i_flux_pt]) <<" sig="<<sig<<endl;
  }
  return sig;
}
int Experiment::ReadDataq2
(char* file,float *xval,float* xbin_lo,float* xbin_hi,float *yval,float *y_err)
{
//  cout<<file<<endl;
  int npoint=0;
  char string_in[100];
  FILE *fp = fopen(file,"r");
  float enuMinCt;
  float enuMaxCt;
  int fileOK=fscanf(fp,"%d %d %f %f",&ibin_chi_start, &ibin_chi_end, &enuMinCt, &enuMaxCt);
  if(NWR>0)
  {
    cout<<"ibin_chi_start = "<<ibin_chi_start<<",ibin_chi_end = "<<ibin_chi_end
        <<",enuMinCt = "<<enuMinCt<<",enuMaxCt = "<<enuMaxCt<<endl;
  }
  enuMinCut=enuMinCt; 
  enuMaxCut=enuMaxCt;
  fgets( string_in,100,fp);
  fgets( string_in,100,fp);
  if(NWR>0)
  {
    cout<<string_in<<endl;
  }
  fgets( string_in,100,fp);
  float xruler;
  float yruler;
  float ene_scale;
  float q2_scale;
  fileOK=fscanf(fp,"%f %f %f %f",&xruler ,&yruler ,&ene_scale ,&q2_scale);
  if(NWR>0)
  {
    cout<<xruler<<" "<<yruler<<" "<<ene_scale<<" "<<q2_scale<<endl;
  }
  float xscl=ene_scale/xruler;
  float yscl=q2_scale/yruler;
  int ind;
  float xpt;
  float ypt;
  float yer_low;
  float yer_hi;
  float yer;
  while (1)
  {
    fileOK=fscanf(fp,"%d %f %f %f %f %f",&ind,&xpt,&ypt,&yer_low,&yer_hi,&yer);
    if (fileOK < 0) break;
    if(npoint<NWR)
    {
      cout<<" "<<ind<<" "<<xpt<<" "<<ypt<<" "<<yer_low<<" "<<yer_hi<<" "<<yer<<endl;
    }
    xval[npoint]=xpt*xscl;
    yval[npoint]=ypt*yscl;
    y_err[npoint]=(yer_hi-yer_low)*yscl*0.5;
    if(npoint>0)
    {
      xbin_hi[npoint-1]=(xval[npoint]+xval[npoint-1])/2.0;
      xbin_lo[npoint]=xbin_hi[npoint-1];
    }  
    npoint++;
  }
  xbin_lo[0]=(3.0*xval[0]-xval[1])/2.0;
  xbin_hi[npoint-1]=(3.0*xval[npoint-1]-xval[npoint-2])/2.0;
  fclose(fp);
  if(npoint==0)
  {
    cout<<"File "<<file<<"is bad."<<endl;
    exit(1);
  }
  return npoint;
}
int Experiment::ReadDataq2Events
(char* file,float *xval,float* xbin_lo,float* xbin_hi,float *yval,float *y_err)
// Reads in events with no error bars,
// The graph is in number of events
{
//  cout<<file<<endl;
  int npoint=0;
  char string_in[100];
  FILE *fp = fopen(file,"r");
  float enuMinCt;
  float enuMaxCt;
  int fileOK=fscanf(fp,"%d %d %f %f",&ibin_chi_start, &ibin_chi_end, &enuMinCt, &enuMaxCt);
  if(NWR>0)
  {
    cout<<"ibin_chi_start = "<<ibin_chi_start<<" ibin_chi_end = "<<ibin_chi_end
        <<" enuMinCt = "<<enuMinCt<<" enuMaxCt = "<<enuMaxCt<<endl;
  }
  fgets( string_in,100,fp);
  enuMinCut=enuMinCt; 
  enuMaxCut=enuMaxCt;
  fgets( string_in,100,fp);
  if(NWR>0)
  {
    cout<<string_in<<endl;
  }
  fgets( string_in,100,fp);
  if(NWR>0)
  {
    cout<<string_in<<endl;
  }
  float xruler;
  float yruler;
  float ene_scale;
  float q2_scale;
  fileOK=fscanf(fp,"%f %f %f %f",&xruler ,&yruler ,&ene_scale ,&q2_scale);
  if(NWR>0)
  {
    cout<<xruler<<" "<<yruler<<" "<<ene_scale<<" "<<q2_scale<<endl;
  }
  float xscl=ene_scale/xruler;
  float yscl=q2_scale/yruler;
  int ind;
  float xpt;
  float xpt_binlo;
  float xpt_binhi;
  float ypt;
  float bin_width=0;
  while (1)
  {
    fileOK=fscanf(fp,"%f %f %f %f",&xpt,&xpt_binlo,&xpt_binhi,&ypt);
    if (fileOK < 0) break;
    if(npoint<NWR)
    {
      cout<<xpt<<" "<<ypt<<endl;
    }
    xval[npoint]=xpt*xscl;
    xbin_lo[npoint]=xpt_binlo*xscl;
    xbin_hi[npoint]=xpt_binhi*xscl;
    yval[npoint]=ypt*yscl;
    y_err[npoint]=sqrt(yval[npoint]);
    npoint++;
  }
  fclose(fp);
  if(npoint==0)
  {
    cout<<"File "<<file<<"is bad."<<endl;
    exit(1);
  }
  return npoint;
}
int Experiment::ReadFluxq2
(char* file,float *xval,float *x_err,float *x_lo,float *x_hi,float *yval,float *y_err)
{
  if(NWR>0)
  {
    cout<<file<<endl;
  }
  int npoint=0;
  char string_in[100];
  FILE *fp = fopen(file,"r");
  fgets( string_in,100,fp);
  fgets( string_in,100,fp);
  float xruler;
  float yruler; // from flux_high to flux_low with a ruler
  float ene_scale;
  float flux_low; // the y=0 point on the plot
  float flux_high; // the point one measures to 
  int fileOK=fscanf
  (fp,"%f %f %f %f %f",&xruler ,&yruler ,&ene_scale ,&flux_low,&flux_high);
  if(NWR>0)
  {
    cout<<xruler<<" "<<yruler<<" "<<ene_scale
    <<" "<<flux_low<<" "<<flux_high<<endl;
  }
  float xscl=ene_scale/xruler;
  float yscl=log(flux_high/flux_low)/yruler;
  int ind;
  float xpt;
  float xer_low;
  float xer_hi;
  float ypt;
  float yer_low;
  float yer_hi;
  while (1)
  {
    fileOK=fscanf(fp,"%d %f %f %f %f %f %f",&ind,&xpt,&ypt,&xer_low,&xer_hi,&yer_low,&yer_hi);
    if (fileOK < 0) break;
    if(npoint<NWR)
    {
      cout<<ind<<" "<<xpt<<" "<<ypt<<" "<<xer_low<<" "
      <<xer_hi<<" "<<yer_low<<" "<<yer_hi<<endl;
    }
    xval[npoint]=xpt*xscl;
    x_err[npoint]=(xer_hi-xer_low)*xscl*0.5;
    x_lo[npoint]=xer_low*xscl;
    x_hi[npoint]=xer_hi*xscl;
    yval[npoint]=flux_low*exp(ypt*yscl);
    y_err[npoint]=flux_low*(exp(yer_hi*yscl)-exp(yer_low*yscl))*0.5;
    npoint++;
  }
  fclose(fp);
  if(npoint==0)
  {
    cout<<"File "<<file<<"is bad."<<endl;
    exit(1);
  }
  return npoint;
}
void Experiment::CreateFluxSplines()
{
  float enu_fl[NFLUX];
  float flux_fl[NFLUX];
  double enu_doub[NFLUX];
  double flux_doub[NFLUX];
  for(int iSpl=0;iSpl<num_spline;iSpl++)
  {
    for(int id=0;id<NFLUX;id++)
    {
      enu_fl[id]=0;
      flux_fl[id]=0;
    }
    int nFluxPt=ReadFluxForSpline(spline_file[iSpl],enu_fl,flux_fl); 
    for(int id=0;id<nFluxPt;id++)
    {
      enu_doub[id]=enu_fl[id];
      flux_doub[id]=flux_fl[id];
    }
    spline_flux[iSpl].PutDataInSplineObj(nFluxPt,enu_doub,flux_doub); 
  }
  FluxCalcEminEmax();
}
void Experiment::FluxCalcEminEmax()// flux for spline fit
// test to see which spline fit is used
{
  enuMinFlux=10e10; //the Flux minimal energy
  enuMaxFlux=-10e10; //the Flux Maximal energy, needed for integration
  if(spline_area_flux.Return_numDataPts()!=0)
  {
    enuMinFlux=spline_area_flux.Return_xMinSpline();
    enuMaxFlux=spline_area_flux.Return_xMaxSpline();
  }
  else
  {
    for(int iSpl=0;iSpl<num_spline;iSpl++)
    {
      double xMinSpl=spline_flux[iSpl].Return_xMinSpline() ;
      enuMinFlux=(xMinSpl<enuMinFlux)?xMinSpl:enuMinFlux  ;
      double xMaxSpl=spline_flux[iSpl].Return_xMaxSpline() ;
      enuMaxFlux=(xMaxSpl>enuMaxFlux)?xMaxSpl:enuMaxFlux  ;
    }
  }
  if(enuMinFlux<enuMinCut)
  {
    enuMinFlux=enuMinCut;
  }
  if(enuMaxFlux>enuMaxCut)
  {
    enuMaxFlux=enuMaxCut;
  }
}
double Experiment::FluxSpline(double enu)// flux for spline fit
// uses SplineArea if that is non zero, otherwise Spline
{
  double flux_sum=0.0;
  if(spline_area_flux.Return_numDataPts()!=0)
  {
     flux_sum+=spline_area_flux.Splint(enu);
  }
  else
  {
    for(int iSpl=0;iSpl<num_spline;iSpl++)
    {
      flux_sum+=coef_of_spline[iSpl]*spline_flux[iSpl].Splint(enu);
    }
  }
  return flux_sum;
}
int Experiment::ReadFluxForSpline(char* file,float *xval, float *yval)
//Reads flux files which will be used to create splines fits
{
  if(NWR>0)
  {
    cout<<file<<endl;
  }
  int npoint=0;
  char string_in[100];
  FILE *fp = fopen(file,"r");
  fgets( string_in,100,fp); // comment line in file
  fgets( string_in,100,fp);// comment line in file
  int ind;
  float xpt;
  float ypt;
  while (1)
  {
    int fileOK=fscanf(fp,"%f %f",&xpt,&ypt);
    if (fileOK < 0) break;
    xval[npoint]=xpt;
    yval[npoint]=ypt;
    if(npoint<NWR)
    {
//      cout<<xpt<<" "<<ypt<<endl;
      cout<<" "<<xval[npoint]<<" "<<yval[npoint]<<endl;
    }
    npoint++;
  }
  fclose(fp);
  if(npoint==0)
  {
    cout<<"File "<<file<<"is bad."<<endl;
    exit(1);
  }
  return npoint;
}
void Experiment::ReadSplineFile()
{
  char file[MAX_CHAR_LENGTH] = "q2data/flux_" ;
  strncat(file,exper,MAX_CHAR_LENGTH);
  strncat(file,".spl",MAX_CHAR_LENGTH);
  cout<<" ( flux file ="<<file<<" in ReadSplineFile " <<endl;
  FILE *fp = fopen(file,"r");
  int num_spl;
  int fileOK=fscanf(fp,"%d",&num_spl);
  if (fileOK < 0) 
  {
    cout<<"spline file bad"<<endl;
    exit(1);
  }
  num_spline=num_spl;
  float coef;
  for(int n_s=0;n_s<num_spline;n_s++)
  {
    fileOK=fscanf(fp,"%f",&coef);
    if (fileOK < 0) 
    {
      cout<<"spline file bad"<<endl;
      exit(1);
    }
    coef_of_spline[n_s]=coef;
  }
  for(int n_s=0;n_s<num_spline;n_s++)
  {
    char spl_fil[50];
    fileOK=fscanf(fp,"%s",spl_fil);
    strcpy(spline_file[n_s],spl_fil);
  }
}
//
void Experiment::WriteSplineFile()
{
  cout<<"num_spline="<<num_spline<<endl;
  for(int n_s=0;n_s<num_spline;n_s++)
  {
    cout<<"coef_of_spline["<<n_s<<"]="<<coef_of_spline[n_s]<<endl;
    cout<<"spline_file["<<n_s<<"]="<<spline_file[n_s]<<endl;
  }
}
void Experiment::CreateQ2FuncSplines()
// Creates a spline fit for the function on the aurthors q**2 plot
{
  char spline_func_file[MAX_CHAR_LENGTH] = "q2data/func_" ;
  strncat(spline_func_file,nu_nub,MAX_CHAR_LENGTH);
  strncat(spline_func_file,"_",MAX_CHAR_LENGTH);
  strncat(spline_func_file,exper,MAX_CHAR_LENGTH);
  strncat(spline_func_file,".dat",MAX_CHAR_LENGTH);
  splineQ2Func.Set_spline_file(spline_func_file);
  splineQ2Func.MakeSplineObjFromFile();
}
double Experiment::FuncToInteg(char* stg,double xval,double cPara[nSize_cPara])
{
  if(strcmp(stg,"IntegFlux_dsigma_dq2_thy")==0)
  {
    return dsigma_dq2(*cPara,xval)*FluxSpline(xval);
  }
  if(strcmp(stg,"Integ_dsigma_dq2_thy")==0)
  {
    return IntegFlux_dsigma_dq2_thy(xval,cPara[0],cPara[1]);
  }
  if(strcmp(stg,"IntegFlux_coef_F_A_0")==0)
  {
    return coef_F_A_0(*cPara,xval)*FluxSpline(xval);
  }
  if(strcmp(stg,"Integ_coef_F_A_0")==0)
  {
    return IntegFlux_coef_F_A_0(xval,cPara[0],cPara[1]);
  }
  if(strcmp(stg,"IntegFlux_coef_F_A_1")==0)
  {
    return coef_F_A_1(*cPara,xval)*FluxSpline(xval);
  }
  if(strcmp(stg,"Integ_coef_F_A_1")==0)
  {
    return IntegFlux_coef_F_A_1(xval,cPara[0],cPara[1]);
  }
  if(strcmp(stg,"IntegFlux_coef_F_A_2")==0)
  {
    return coef_F_A_2(*cPara,xval)*FluxSpline(xval);
  }
  if(strcmp(stg,"Integ_coef_F_A_2")==0)
  {
    return IntegFlux_coef_F_A_2(xval,cPara[0],cPara[1]);
  }
  if(strcmp(stg,"IntegFlux_F_A_1_coef_F_A_1")==0)
  {
    return F_A(*cPara)*coef_F_A_1(*cPara,xval)*FluxSpline(xval);
  }
  if(strcmp(stg,"Integ_F_A_1_coef_F_A_1")==0)
  {
    return IntegFlux_F_A_1_coef_F_A_1(xval,cPara[0],cPara[1]);
  }
  if(strcmp(stg,"IntegFlux_F_A_2_coef_F_A_2")==0)
  {
    return F_A(*cPara)*F_A(*cPara)*coef_F_A_2(*cPara,xval)*FluxSpline(xval);
  }
  if(strcmp(stg,"Integ_F_A_2_coef_F_A_2")==0)
  {
    return IntegFlux_F_A_2_coef_F_A_2(xval,cPara[0],cPara[1]);
  }
  if(strcmp(stg,"Integ_F_A")==0)
  {
    return F_A(xval);
  }
  if(strcmp(stg,"poly")==0)
  {
    return cPara[0]*pow(xval,3)+cPara[1]*pow(xval,4);
  }
  if(strcmp(stg,"IntegFlux")==0)
  {
    return FluxSpline(xval);
  }
// In Elastic, this is a klug, 
  if(strcmp(stg,"dsigma_dq2")==0)
  {
    return dsigma_dq2(xval,*cPara);
  }
  cout<<" function does not exist, Function = "<<stg<<endl;
  exit(1);
}
double Experiment::IntegFlux_dsigma_dq2_thy(double q2, double enu_low, double enu_high)
// use Integrate.C to do integration
{
  double accur_integ=accurInteg;
  return Integr("IntegFlux_dsigma_dq2_thy",&q2,enu_low,enu_high,accur_integ);
}
double Experiment::IntegFlux_dsigma_dq2_thy(double q2)
// use Integrate.C to do integration
{
  double accur_integ=accurInteg;
  return Integr("IntegFlux_dsigma_dq2_thy",&q2,enuMinFlux,enuMaxFlux,accur_integ);
}
double Experiment::Integ_dsigma_dq2_thy
 (double q2_low, double q2_high,double enu_low,double enu_high)
//  use Integrate.C to do integration
//  Int(from q2_low to q2_high,enu_low to enu_high)dsigma_dq2.
{
  double accur_integ=accurInteg;
  double enu_limit[nSize_cPara];
  enu_limit[0]=enu_low; 
  enu_limit[1]=enu_high; 
  return Integr("Integ_dsigma_dq2_thy",enu_limit,q2_high,q2_low,accur_integ);
}
//
double Experiment::Integ_dsigma_dq2_thy
 (double q2_low, double q2_high)
//  Int(from q2_low to q2_high,enuMinFlux to enuMaxFlux)dsigma_dq2.
{
  return Integ_dsigma_dq2_thy(q2_low,q2_high,enuMinFlux,enuMaxFlux);
}
//
//
double Experiment::IntegFlux_coef_F_A_0(double q2, double enu_low, double enu_high)
// use Integrate.C to do integration
{
  double accur_integ=accurInteg;
  return Integr("IntegFlux_coef_F_A_0",&q2,enu_low,enu_high,accur_integ);
}
double Experiment::IntegFlux_coef_F_A_0(double q2)
// use Integrate.C to do integration
{
  double accur_integ=accurInteg;
  return Integr("IntegFlux_coef_F_A_0",&q2,enuMinFlux,enuMaxFlux,accur_integ);
}
double Experiment::Integ_coef_F_A_0
 (double q2_low, double q2_high,double enu_low,double enu_high)
//  use Integrate.C to do integration
//  Int(from q2_low to q2_high,enu_low to enu_high)dsigma_dq2.
{
  double accur_integ=accurInteg;
  double enu_limit[nSize_cPara];
  enu_limit[0]=enu_low; 
  enu_limit[1]=enu_high; 
  return Integr("Integ_coef_F_A_0",enu_limit,q2_high,q2_low,accur_integ);
}
//
double Experiment::Integ_coef_F_A_0
 (double q2_low, double q2_high)
//  Int(from q2_low to q2_high,enuMinFlux to enuMaxFlux)dsigma_dq2.
{
  return Integ_coef_F_A_0(q2_low,q2_high,enuMinFlux,enuMaxFlux);
}
//
//
double Experiment::IntegFlux_coef_F_A_1(double q2, double enu_low, double enu_high)
// use Integrate.C to do integration
{
  double accur_integ=accurInteg;
  return Integr("IntegFlux_coef_F_A_1",&q2,enu_low,enu_high,accur_integ);
}
double Experiment::IntegFlux_coef_F_A_1(double q2)
// use Integrate.C to do integration
{
  double accur_integ=accurInteg;
  return Integr("IntegFlux_coef_F_A_1",&q2,enuMinFlux,enuMaxFlux,accur_integ);
}
double Experiment::Integ_coef_F_A_1
 (double q2_low, double q2_high,double enu_low,double enu_high)
//  use Integrate.C to do integration
//  Int(from q2_low to q2_high,enu_low to enu_high)dsigma_dq2.
{
  double accur_integ=accurInteg;
  double enu_limit[nSize_cPara];
  enu_limit[0]=enu_low; 
  enu_limit[1]=enu_high; 
  return Integr("Integ_coef_F_A_1",enu_limit,q2_high,q2_low,accur_integ);
}
//
double Experiment::Integ_coef_F_A_1
 (double q2_low, double q2_high)
//  Int(from q2_low to q2_high,enuMinFlux to enuMaxFlux)dsigma_dq2.
{
  return Integ_coef_F_A_1(q2_low,q2_high,enuMinFlux,enuMaxFlux);
}
//
//
//
//
//
double Experiment::IntegFlux_coef_F_A_2(double q2, double enu_low, double enu_high)
// use Integrate.C to do integration
{
  double accur_integ=accurInteg;
  return Integr("IntegFlux_coef_F_A_2",&q2,enu_low,enu_high,accur_integ);
}
double Experiment::IntegFlux_coef_F_A_2(double q2)
// use Integrate.C to do integration
{
  double accur_integ=accurInteg;
  return Integr("IntegFlux_coef_F_A_2",&q2,enuMinFlux,enuMaxFlux,accur_integ);
}
double Experiment::Integ_coef_F_A_2
 (double q2_low, double q2_high,double enu_low,double enu_high)
//  use Integrate.C to do integration
//  Int(from q2_low to q2_high,enu_low to enu_high)dsigma_dq2.
{
  double accur_integ=accurInteg;
  double enu_limit[nSize_cPara];
  enu_limit[0]=enu_low; 
  enu_limit[1]=enu_high; 
  return Integr("Integ_coef_F_A_2",enu_limit,q2_high,q2_low,accur_integ);
}
//
double Experiment::Integ_coef_F_A_2
 (double q2_low, double q2_high)
//  Int(from q2_low to q2_high,enuMinFlux to enuMaxFlux)dsigma_dq2.
{
  return Integ_coef_F_A_2(q2_low,q2_high,enuMinFlux,enuMaxFlux);
}
double Experiment::IntegFlux_F_A_1_coef_F_A_1(double q2, double enu_low, double enu_high)
// use Integrate.C to do integration
{
  double accur_integ=accurInteg;
  return Integr("IntegFlux_F_A_1_coef_F_A_1",&q2,enu_low,enu_high,accur_integ);
}
double Experiment::IntegFlux_F_A_1_coef_F_A_1(double q2)
// use Integrate.C to do integration
{
  double accur_integ=accurInteg;
  return Integr("IntegFlux_F_A_1_coef_F_A_1",&q2,enuMinFlux,enuMaxFlux,accur_integ);
}
double Experiment::Integ_F_A_1_coef_F_A_1
 (double q2_low, double q2_high,double enu_low,double enu_high)
//  use Integrate.C to do integration
//  Int(from q2_low to q2_high,enu_low to enu_high)dsigma_dq2.
{
  double accur_integ=accurInteg;
  double enu_limit[nSize_cPara];
  enu_limit[0]=enu_low; 
  enu_limit[1]=enu_high; 
  return Integr("Integ_F_A_1_coef_F_A_1",enu_limit,q2_high,q2_low,accur_integ);
}
//
double Experiment::Integ_F_A_1_coef_F_A_1
 (double q2_low, double q2_high)
//  Int(from q2_low to q2_high,enuMinFlux to enuMaxFlux)dsigma_dq2.
{
  return Integ_F_A_1_coef_F_A_1(q2_low,q2_high,enuMinFlux,enuMaxFlux);
}
//
//
double Experiment::IntegFlux_F_A_2_coef_F_A_2(double q2, double enu_low, double enu_high)
// use Integrate.C to do integration
{
  double accur_integ=accurInteg;
  return Integr("IntegFlux_F_A_2_coef_F_A_2",&q2,enu_low,enu_high,accur_integ);
}
double Experiment::IntegFlux_F_A_2_coef_F_A_2(double q2)
// use Integrate.C to do integration
{
  double accur_integ=accurInteg;
  return Integr("IntegFlux_F_A_2_coef_F_A_2",&q2,enuMinFlux,enuMaxFlux,accur_integ);
}
double Experiment::Integ_F_A_2_coef_F_A_2
 (double q2_low, double q2_high,double enu_low,double enu_high)
//  use Integrate.C to do integration
//  Int(from q2_low to q2_high,enu_low to enu_high)dsigma_dq2.
{
  double accur_integ=accurInteg;
  double enu_limit[nSize_cPara];
  enu_limit[0]=enu_low; 
  enu_limit[1]=enu_high; 
  return Integr("Integ_F_A_2_coef_F_A_2",enu_limit,q2_high,q2_low,accur_integ);
}
//
double Experiment::Integ_F_A_2_coef_F_A_2
 (double q2_low, double q2_high)
//  Int(from q2_low to q2_high,enuMinFlux to enuMaxFlux)dsigma_dq2.
{
  return Integ_F_A_2_coef_F_A_2(q2_low,q2_high,enuMinFlux,enuMaxFlux);
}
//
//
double Experiment::Integ_F_A(double q2_low, double q2_hi)
{
  double accur_integ=accurInteg;
  double xxx=0;//dummy parameter
  return Integr("Integ_F_A",&xxx,q2_low,q2_hi,accur_integ);
}
//
//
double Experiment::poly_int(double a, double b,double x_low, double x_hi)
// use Integrate.C to do integration
{
  double accur_integ=accurInteg;
  double para[nSize_cPara];
  para[0]=a;
  para[1]=b;
  return Integr("poly",para,x_low,x_hi,accur_integ);
}
double Experiment::IntegFlux(double e_low, double e_hi)
// use Integrate.C to do integration
{
  double accur_integ=accurInteg;
  double xxx=0;
  return Integr("IntegFlux",&xxx,e_low,e_hi,accur_integ);
}
// Function to Find Root
double Experiment::FuncToFindRoot(char* stg,double xval,double cPara[nSize_cPara])
{
  int nbin=static_cast<int>(cPara[0]);
  if(strcmp(stg,"BinCenter_dsigma_dq2")==0)
  {
    double del_Q2=Q2_binhi[nbin]-Q2_binlo[nbin];
    return IntegFlux_dsigma_dq2_thy(xval)-sig_q2_thy[nbin]/del_Q2;
  }
  if(strcmp(stg,"BinCenter_ave_F_A_2_wt_coefFA2")==0)
// Need to call first Fill_ave_F_A_2_wt_coefFA2() to fill ave_F_A_2_wt_coefFA2[nbin]
// We only want to find evaluate ave_F_A_2_wt_coefFA2[nbin] once.
  {
    return F_A(xval)*F_A(xval)-ave_F_A_2_wt_coefFA2[nbin];
  }
  if(strcmp(stg,"BinCenter_ave_F_A_1_wt_coefFA1")==0)
// Need to call first Fill_ave_F_A_1_wt_coefFA1() to fill ave_F_A_1_wt_coefFA1[nbin]
// We only want to find evaluate ave_F_A_1_wt_coefFA1[nbin] once.
  {
    return F_A(xval)-ave_F_A_1_wt_coefFA1[nbin];
  }
  cout<<" function does not exist, Function = "<<stg<<endl;
  exit(1);
}
double Experiment::BinCenter_dsigma_dq2(int nbin)
//  use Integrate.C to do integration
//  Int(from q2_low to q2_high,enu_low to enu_high)dsigma_dq2.
{
  double xbin=nbin;
  double q2_high=-Q2_binhi[nbin];
  double q2_low=-Q2_binlo[nbin];
//  cout<<" sig_q2_thy = "<<sig_q2_thy[nbin]
//      <<", q2_low = "<<q2_low<<", q2_high = "<<q2_high<<endl;
  return Solve("BinCenter_dsigma_dq2",&xbin,q2_high,q2_low,accur_solve);
}
void  Experiment::Q2BinCenter()
// bin center Q2
// If the dsigma/dq2 turns over in a bin, BinCenter_dsigma_dq2 
// doesn't work. It tries to find a root between two number
// of the same sign and FindRoot::Solve just does a return 
// with -999.
{ 
  for (int ibin=0;ibin<n_data_pt;ibin++)
  {
    double BinCent_dsigma_dQ2=-BinCenter_dsigma_dq2(ibin);
    if(BinCent_dsigma_dQ2!=999.0)
    {
      Q2[ibin]=BinCent_dsigma_dQ2;
    }
  }
}
void Experiment::Fill_bin_cent_ave_F_A_2_wt_coefFA2()
{
  for (int i_data_pt=0;i_data_pt<n_data_pt;i_data_pt++)
  {
    Q2_bin_cent_ave_F_A_2_wt_coefFA2[i_data_pt]
    =-BinCenter_ave_F_A_2_wt_coefFA2(i_data_pt);
  } 
}
double Experiment::BinCenter_ave_F_A_2_wt_coefFA2(int nbin)
//  Bin center q2 so that 
// F_A(q_A)**2*Int(coef_F_A_2(e_nu,q2)= Int(F_A(q_A)**2*Int(coef_F_A_2(e_nu,q2))
//  Int(from q2_low to q2_high,enu_low to enu_high)
{
  double xbin=nbin;
  double q2_high=-Q2_binhi[nbin];
  double q2_low=-Q2_binlo[nbin];
//  cout<<" sig_q2_thy = "<<sig_q2_thy[nbin]
//      <<", q2_low = "<<q2_low<<", q2_high = "<<q2_high<<endl;
  return Solve("BinCenter_ave_F_A_2_wt_coefFA2",&xbin,q2_high,q2_low,accur_solve);
}
void Experiment::Fill_bin_cent_ave_F_A_1_wt_coefFA1()
{
  for (int i_data_pt=0;i_data_pt<n_data_pt;i_data_pt++)
  {
    Q2_bin_cent_ave_F_A_1_wt_coefFA1[i_data_pt]
    =-BinCenter_ave_F_A_1_wt_coefFA1(i_data_pt);
  } 
}
double Experiment::BinCenter_ave_F_A_1_wt_coefFA1(int nbin)
//  Bin center q2 so that 
// F_A(q_A)*Int(coef_F_A_1(e_nu,q2)= Int(F_A(q_A)*Int(coef_F_A_1(e_nu,q2))
//  Int(from q2_low to q2_high,enu_low to enu_high)
{
  double xbin=nbin;
  double q2_high=-Q2_binhi[nbin];
  double q2_low=-Q2_binlo[nbin];
//  cout<<" sig_q2_thy = "<<sig_q2_thy[nbin]
//      <<", q2_low = "<<q2_low<<", q2_high = "<<q2_high<<endl;
  return Solve("BinCenter_ave_F_A_1_wt_coefFA1",&xbin,q2_high,q2_low,accur_solve);
}
void Experiment::Fill_ave_F_A_1_wt_coefFA1()
{
  if(NWR>0)
  {
    cout<<" Calculate integ coef_F_A_1*F_A /integ coef_F_A_1*F_A  over bin and flux"<<endl;
  }
  for (int i_data_pt=0;i_data_pt<n_data_pt;i_data_pt++)
  {
    double q2_lo=-Q2_binlo[i_data_pt];
    double q2_hi=-Q2_binhi[i_data_pt];
    ave_F_A_1_wt_coefFA1[i_data_pt]
    =Integ_F_A_1_coef_F_A_1(q2_lo,q2_hi)/Integ_coef_F_A_1(q2_lo,q2_hi);
    if(i_data_pt<NWR)
    {
      cout<<i_data_pt<<" ave_F_A_1_wt_coefFA1 ="<<ave_F_A_1_wt_coefFA1[i_data_pt]<<endl;
    } 
  } 
}
void Experiment::Fill_ave_F_A_2_wt_coefFA2()
{
  if(NWR>0)
  {
    cout<<" Calculate integ coef_F_A_2*F_A*F_A/integ coef_F_A_2  over bin and flux"<<endl;
  }
  for (int i_data_pt=0;i_data_pt<n_data_pt;i_data_pt++)
  {
    double q2_lo=-Q2_binlo[i_data_pt];
    double q2_hi=-Q2_binhi[i_data_pt];
    ave_F_A_2_wt_coefFA2[i_data_pt]
    =Integ_F_A_2_coef_F_A_2(q2_lo,q2_hi)/Integ_coef_F_A_2(q2_lo,q2_hi);
    if(i_data_pt<NWR)
    {
      cout<<i_data_pt<<" ave_F_A_2_wt_coefFA2 ="<<ave_F_A_2_wt_coefFA2[i_data_pt]<<endl;
    } 
  } 
}
//
char*   Experiment::return_exper(){return exper;}
double  Experiment::return_enuMinFlux(){return enuMinFlux;}
double  Experiment::return_enuMaxFlux(){return enuMaxFlux;}
double  Experiment::return_enuMinCut(){return enuMinCut;}
double  Experiment::return_enuMaxCut(){return enuMaxCut;}
double  Experiment::return_q2MinData(){return q2MinData;}
double  Experiment::return_q2MaxData(){return q2MaxData;}
double  Experiment::return_sigma_thy(){return sigma_thy;}
double  Experiment::return_sigma_data(){return sigma_data;}
int     Experiment::return_n_data_pt(){return n_data_pt;}
double* Experiment::return_Q2(){return Q2;}
double* Experiment::return_Q2_binlo(){return Q2_binlo;}
double* Experiment::return_Q2_binhi(){return Q2_binhi;}
double* Experiment::return_Q2_bin_cent_ave_F_A_2_wt_coefFA2(){return Q2_bin_cent_ave_F_A_2_wt_coefFA2;}
double* Experiment::return_sig_q2_data(){return sig_q2_data;}
double* Experiment::return_sig_q2_thy(){return sig_q2_thy;}
double* Experiment::return_sig_q2_err(){return sig_q2_err;}
double* Experiment::return_F_A_calc(){return F_A_calc;}
double* Experiment:: return_F_A_error(){return F_A_error;}
   int Experiment::return_ibin_chi_start(){return ibin_chi_start;}
   int Experiment::return_ibin_chi_end(){return ibin_chi_end;}

//
void Experiment::WriteQ2Data()
// write out the Q2
{
  cout<<" Q2  Q2_binlo Q2_binhi sig_q2_data sig_q2_err sig_q2_thy "<<endl;
  for (int i=0; i<n_data_pt;i++)
  {
//    cout<<"  "<<Q2[i]<<"  "<<Q2_binlo[i]<<"  "<<Q2_binhi[i]
//    <<"  "<<sig_q2_data[i]<<"  "<<sig_q2_err[i]<<"  "<<sig_q2_thy[i]<<endl;
    cout<<"  "<<Q2[i]<<"  "<<sig_q2_thy[i]<<"  "<<endl;
  }
}
void Experiment::WriteExperiment()
{
  cout<<" ( Exp="<<exper<<" sigma_thy ="<<sigma_thy<<endl;
  cout<<" ( Intergration Accuracy ="<<accurInteg<<endl;
  cout<<" ( max_integ_times_q2_flux="<<max_integ_times_q2_flux<<endl; 
  cout<<" (ibin_chi_start = "<<ibin_chi_start<<" ibin_chi_end = "<<ibin_chi_end
      <<" m_P = "<<m_P<<" M2 = "<<M2<<endl;
  cout<<" ( enuMinFlux = "<<enuMinFlux<<", enuMaxFlux = "<<enuMaxFlux
       << ", enuMinCut = "<<enuMinCut<<", enuMaxCut = "<<enuMaxCut<<endl;
  cout<<" ( solve_F_A_data_theory = "<<solve_F_A_data_theory<<endl;
  WriteElastic();
}
