#include "TGraph.h"
#include "TF1.h"
#include "TCanvas.h"
void Margin(float,float,float,float);
void FormatFunc(TF1*, int, int);
void FormatGraph(TGraph* pnt);
void FormatGraph(TGraph*, float, float),;
void FormatLine(TLine*, int ,int );
void FormatErrors(TGraphErrors* , int ,int ,float ,int );
void FormatMarker(TMarker* pnt, int ,int ,float );
void FormatGraph(TGraph* pnt)
{
  pnt->GetXaxis()->SetLabelSize(0.055);
  pnt->GetXaxis()->SetTitleSize(0.060);
  pnt->GetXaxis()->SetTitleOffset(1.2);
// y axis
  pnt->GetYaxis()->SetLabelSize(0.055);
  pnt->GetYaxis()->SetTitleSize(0.060);
  pnt->GetYaxis()->SetTitleOffset(1.0);
}
void FormatGraph(TH2* pnt, double sizeLabel = 0.55, double sizeTitle = 0.06
     ,double titleOffsetX=1.2,double titleOffsetY=1.0);
void FormatGraph(TH2* pnt, double sizeLabel, double sizeTitle 
	,double titleOffsetX,double titleOffsetY)
{
   pnt->SetStats(kFALSE);
  pnt->GetXaxis()->SetLabelSize(sizeLabel);
  pnt->GetXaxis()->SetTitleSize(sizeTitle);
  pnt->GetXaxis()->SetTitleOffset(titleOffsetX);
// y axis
  pnt->GetYaxis()->SetLabelSize(sizeLabel);
  pnt->GetYaxis()->SetTitleSize(sizeTitle);
  pnt->GetYaxis()->SetTitleOffset(titleOffsetY);
}
void FormatFunc(TF1* pnt, int icolor,int iStyle)
{
  pnt->SetMarkerSize(10);
  pnt->SetMarkerColor(1);
  pnt->SetLineWidth(3);
  pnt->SetLineColor(icolor);
//  pnt->SetMinimum(0);
//  pnt->SetMaximum(1.25);
  pnt->SetLineStyle(iStyle);
}
void Margin(float top,float right,float bottom,float left)
{
//   gStyle->SetTitleSize(.045,"x");
//   gStyle->SetTitleSize(.045,"y");
   gStyle->SetPadTopMargin(0.10);
   gStyle->SetPadRightMargin(0.04);
   gStyle->SetPadBottomMargin(0.15);
   gStyle->SetPadLeftMargin(0.12);
//   gStyle->SetTitleOffset(1.1,"X");
//   gStyle->SetTitleOffset(1.3,"Y");
//   gStyle->SetNdivisions(510,"x");
//   gStyle->SetNdivisions(505,"y");
}
double start_text(double* ,double );
double start_text(double* ,double, std::string );
double start_text(double* axisLimit,double position)
{
  return axisLimit[0]*(1.0-position)+axisLimit[1]*position;
}
double start_text(double* axisLimit,double position,std::string lin_log)
{
  if(strcmp(lin_log.c_str(),"lin")==0) 
  {
    return axisLimit[0]*(1.0-position)+axisLimit[1]*position;
  }
  else
  {
    return exp(log(axisLimit[0])*(1.0-position)+log(axisLimit[1])*position);
  }
}
double move_text(double* axisLimit,double start_txt, double step)
{
  return start_txt-(axisLimit[1]-axisLimit[0])*step;
}

void FormatLine(TLine* pnt, int icolor,int iStyle)
{
  pnt->SetLineWidth(3);
  pnt->SetLineColor(icolor);
  pnt->SetLineStyle(iStyle);
}

void FormatErrors(TGraphErrors* pnt, int icolor,int marker,float symSize,int line_width)
{
  pnt->SetMarkerSize(symSize);
  pnt->SetMarkerStyle(marker);
  pnt->SetMarkerColor(icolor);
  pnt->SetLineWidth(line_width);
  pnt->SetLineColor(icolor);
}
void FormatMarker(TMarker* pnt, int icolor,int marker,float symSize)
{
  pnt->SetMarkerSize(symSize);
  pnt->SetMarkerStyle(marker);
  pnt->SetMarkerColor(icolor);
}
