#include <math.h>
#include <cstdlib>
#include <cstring>
#include <iostream>
#include <fstream>
#include "Lagrange.h"
using namespace std;
//
Lagrange::Lagrange() {}
Lagrange::Lagrange(int n_dat ,double* x_dat ,double* y_dat)
{
  PutParaInLagrangeObj(n_dat,x_dat,y_dat);
}
void Lagrange::PutParaInLagrangeObj(const int n_dat,double* x_dat,double* y_dat)
{
  numNodes=n_dat;
  for(int i=0;i<numNodes;i++)
  {
    xNodes[i]=x_dat[i];
    yNodes[i]=y_dat[i];
  }
}
double Lagrange::RetLagrange(double x)
{
  double poly_lagr=0;
  for(int iNode=0;iNode<numNodes;iNode++)
  {
    double pi=1.0;
    for(int jNode=0;jNode<numNodes;jNode++)
    {
      if(jNode!=iNode)
      {
        pi*=(x-xNodes[jNode])/(xNodes[iNode]-xNodes[jNode]);
      }
    }
    poly_lagr+=yNodes[iNode]*pi;
  }
  return poly_lagr;
}
void Lagrange::WrtInput()
{
  for (int j=0;j<numNodes;j++)
  {
    cout<<j<<" xNodes= "<<xNodes[j]<<" yNodes="<<yNodes[j]<<endl;
  }
}
int Lagrange::Return_numNodes(){return numNodes;}
double* Lagrange::Return_xNodes(){return xNodes;}
double* Lagrange::Return_yNodes(){return yNodes;}
 
