#include "Elastic.h"
#include <iostream>
#include <fstream>
int main()
{
//  char GEP[10];
//  char GEN[10];
//  char GMP[10];
//  char GMN[10];
//  cout<<" form factors GEP GEN GMP GMN "<<endl;
//  cin>>GEP>>GEN>>GMP>>GMN;
  Elastic elas1("JRA_CS_HallA","JRA","JRA_CS_HallA","JRA");
  Elastic elas2("dipole","zero","dipole","dipole");
  Elastic elas3("dipole","zero","dipole","dipole",1.1);
  int isign=1;
  double e_nu=1.0;
  double q2min=elas1.q2_min(e_nu);
  double q2max=elas1.q2_max(e_nu);
  double step=0.02;
  cout<<" set color blue "<<endl;
  for(int istep=0;-istep*step+q2min>q2max;istep++)
  {
    double q_2=-istep*step+q2min;
    double dsig_dq2_1=elas1.dsigma_dq2(q_2, isign, e_nu );
    double dsig_dq2_2=elas2.dsigma_dq2(q_2, isign, e_nu );
    cout<<-q_2<<" "<< dsig_dq2_2/dsig_dq2_1<<endl;
  }
  cout<<" join"<<endl;
  cout<<"set color red "<<endl;
  for(int istep=0;-istep*step+q2min>q2max;istep++)
  {
    double q_2=-istep*step+q2min;
    double dsig_dq2_2=elas2.dsigma_dq2(q_2, isign, e_nu );
    double dsig_dq2_3=elas3.dsigma_dq2(q_2, isign, e_nu );
    cout<<-q_2<<" "<< dsig_dq2_3/dsig_dq2_2<<endl;
  }
  cout<<" join"<<endl;
  cout<<"set color green "<<endl;
  for(int istep=0;-istep*step+q2min>q2max;istep++)
  {
    double q_2=-istep*step+q2min;
    double dsig_dq2_1=elas1.dsigma_dq2(q_2, isign, e_nu );
    double dsig_dq2_3=elas3.dsigma_dq2(q_2, isign, e_nu );
    cout<<-q_2<<" "<< dsig_dq2_3/dsig_dq2_1<<endl;
  }
  cout<<" join"<<endl;
  return 1;
}
