#include "Elastic.h"
#include "Experiment.h"
#include <iostream>
#include <fstream>
#include <stdio.h>
#include <stdlib.h>
#include<string.h>
#include<string>
#include<math.h>
const int NPARA = 3;
void Fit_ma(Experiment&, double, char*, char*);
void syminv(double a[][NPARA] ,int  ,int& );

int main()
{
  double MA;
  double anor=1.00;
  char* chimax="maxl"; // "chi";
// for "maxl" the setting for data_thy doesn't matter
  char* data_thy="theory";
  cout<<" chimax="<<chimax<<", errors="<<data_thy<<endl;
//  int iexp=3;
//  if(iexp==0)
//  {
    MA=1.11;
    Experiment Exp01("Miller_82","nu","SinghD","Olsson","zero","Olsson","Olsson",MA);
    Exp01.InitExperiment();
    Fit_ma(Exp01,anor,chimax,data_thy);
    Experiment Exp02("Miller_82","nu","SinghD","Olsson","zero","Olsson","Olsson",MA,-1.23);
    Exp02.InitExperiment();
    Fit_ma(Exp02,anor,chimax,data_thy);
    Experiment Exp03("Miller_82","nu","SinghD","Olsson","zero","Olsson","Olsson",MA,-1.23,0.105658,1.0,0.84);
    Exp03.InitExperiment();
    Fit_ma(Exp03,anor,chimax,data_thy);
    Experiment Exp04("Miller_82","nu","SinghD","dipole","zero","dipole","dipole",MA+0.02);
    Exp04.InitExperiment();
    Fit_ma(Exp04,anor,chimax,data_thy);
    Experiment Exp05("Miller_82","nu","SinghD","dipole","zero","dipole","dipole",MA+0.02,-1.23);
    Exp05.InitExperiment();
    Fit_ma(Exp05,anor,chimax,data_thy);
    Experiment Exp06("Miller_82","nu","SinghD","JRA_CS_HallA","Krutov","JRA_CS_HallA","JRA",MA-0.02);
    Exp06.InitExperiment();
    Fit_ma(Exp06,anor,chimax,data_thy);
    Experiment Exp07("Miller_82","nu","SinghD","JRA_CS_HallA_3_03","Krutov","JRA_CS_HallA_3_03","JRA_q",MA-0.02);
    Exp07.InitExperiment();
    Fit_ma(Exp07,anor,chimax,data_thy);
    Experiment Exp08("Miller_82","nu","SinghD","JRA_CS_HallA_q","Krutov","JRA_CS_HallA_q","JRA_q",MA-0.02);
    Exp08.InitExperiment();
    Fit_ma(Exp08,anor,chimax,data_thy);
//  }
//  else if (iexp==1)
//  {
    MA=1.08;
    Experiment Exp11("Barish_77","nu","SinghD","Olsson","zero","Olsson","Olsson",MA);
    Exp11.InitExperiment();
    Fit_ma(Exp11,anor,chimax,data_thy);
    Experiment Exp12("Barish_77","nu","SinghD","Olsson","zero","Olsson","Olsson",MA,-1.23);
    Exp11.InitExperiment();
    Fit_ma(Exp12,anor,chimax,data_thy);
    Experiment Exp13("Barish_77","nu","SinghD","Olsson","zero","Olsson","Olsson",MA,-1.23,0.105658,1.0,0.84);
    Exp11.InitExperiment();
    Fit_ma(Exp13,anor,chimax,data_thy);
    Experiment Exp14("Barish_77","nu","SinghD","dipole","zero","dipole","dipole",MA+0.02);
    Exp11.InitExperiment();
    Fit_ma(Exp14,anor,chimax,data_thy);
    Experiment Exp15("Barish_77","nu","SinghD","dipole","zero","dipole","dipole",MA+0.02,-1.23);
    Exp11.InitExperiment();
    Fit_ma(Exp15,anor,chimax,data_thy);
    Experiment Exp16("Barish_77","nu","SinghD","JRA_CS_HallA","Krutov","JRA_CS_HallA","JRA",MA-0.03);
    Exp11.InitExperiment();
    Fit_ma(Exp16,anor,chimax,data_thy);
    Experiment Exp17("Barish_77","nu","SinghD","JRA_CS_HallA_3_03","Krutov","JRA_CS_HallA_3_03","JRA_q",MA-0.03);
    Exp11.InitExperiment();
    Fit_ma(Exp17,anor,chimax,data_thy);
//  }
//  else if (iexp==2)
//  {
    MA=1.07;
    Experiment Exp21("Baker_81","nu","SinghD","Olsson","zero","Olsson","Olsson",MA);
    Exp21.InitExperiment();
    Fit_ma(Exp21,anor,chimax,data_thy);
    Experiment Exp22("Baker_81","nu","SinghD","Olsson","zero","Olsson","Olsson",MA,-1.23);
    Exp22.InitExperiment();
    Fit_ma(Exp22,anor,chimax,data_thy);
    Experiment Exp23("Baker_81","nu","SinghD","Olsson","zero","Olsson","Olsson",MA,-1.23,0.105658,1.0,0.84);
    Exp23.InitExperiment();
    Fit_ma(Exp23,anor,chimax,data_thy);
    Experiment Exp24("Baker_81","nu","SinghD","dipole","zero","dipole","dipole",MA+0.02);
    Exp24.InitExperiment();
    Fit_ma(Exp24,anor,chimax,data_thy);
    Experiment Exp25("Baker_81","nu","SinghD","dipole","zero","dipole","dipole",MA+0.02,-1.23);
    Exp25.InitExperiment();
    Fit_ma(Exp25,anor,chimax,data_thy);
    Experiment Exp26("Baker_81","nu","SinghD","dipole","zero","dipole","dipole",MA+0.02,-1.23,0.105658,1.0,0.84);
    Exp26.InitExperiment();
    Fit_ma(Exp26,anor,chimax,data_thy);
    Experiment Exp27("Baker_81","nu","SinghD","JRA_CS_HallA","Krutov","JRA_CS_HallA","JRA",MA-0.03);
    Exp27.InitExperiment();
    Fit_ma(Exp27,anor,chimax,data_thy);
    Experiment Exp28("Baker_81","nu","SinghD","JRA_CS_HallA_3_03","Krutov","JRA_CS_HallA_3_03","JRA_q",MA-0.03);
    Exp28.InitExperiment();
    Fit_ma(Exp28,anor,chimax,data_thy);
//  }
//  else if (iexp==3)
//  {
    MA=1.14;
    Experiment Exp31("Kitagaki_83","nu","SinghD","Olsson","zero","Olsson","Olsson",MA);
    Exp31.InitExperiment();
    Fit_ma(Exp31,anor,chimax,data_thy);
    Experiment Exp32("Kitagaki_83","nu","SinghD","Olsson","zero","Olsson","Olsson",MA,-1.23);
    Exp32.InitExperiment();
    Fit_ma(Exp32,anor,chimax,data_thy);
    Experiment Exp33("Kitagaki_83","nu","SinghD","Olsson","zero","Olsson","Olsson",MA,-1.23,0.105658,1.0,0.84);
    Exp33.InitExperiment();
    Fit_ma(Exp33,anor,chimax,data_thy);
    Experiment Exp34("Kitagaki_83","nu","SinghD","dipole","zero","dipole","dipole",MA+0.03);
    Exp34.InitExperiment();
    Fit_ma(Exp34,anor,chimax,data_thy);
    Experiment Exp35("Kitagaki_83","nu","SinghD","dipole","zero","dipole","dipole",MA+0.03,-1.23);
    Exp35.InitExperiment();
    Fit_ma(Exp35,anor,chimax,data_thy);
    Experiment Exp36("Kitagaki_83","nu","SinghD","dipole","zero","dipole","dipole",MA+0.03,-1.23,0.105658,1.0,0.84);
    Exp36.InitExperiment();
    Fit_ma(Exp36,anor,chimax,data_thy);
    Experiment Exp37("Kitagaki_83","nu","SinghD","JRA_CS_HallA","Krutov","JRA_CS_HallA","JRA",MA-0.02);
    Exp37.InitExperiment();
    Fit_ma(Exp37,anor,chimax,data_thy);
    Experiment Exp38("Kitagaki_83","nu","SinghD","JRA_CS_HallA_3_03","Krutov","JRA_CS_HallA_3_03","JRA_q",MA-0.02);
    Exp38.InitExperiment();
    Fit_ma(Exp38,anor,chimax,data_thy);
//  }
}
  void Fit_ma(Experiment& Exp,double anor,char* chimax,char *data_thy)
{
  double  xvarLasGain[NPARA];
  double  xvarXvar[NPARA][NPARA];
  double para[NPARA];
  int nelas=9;
  int num_nor=1;
  double step_ma=0.01;
  double step_nor=0.002;
  double mA=Exp.ret_m_A();
  Exp.WriteExperiment();
  cout<<"Exp="<<Exp.return_exper()
  <<" nucCorrecton="<<Exp.ret_nucCorrType()<<endl;
  for(int iPara=0;iPara<NPARA;iPara++)
  {
    xvarLasGain[iPara]=0;
    for(int jPara=0;jPara<NPARA;jPara++)
    {
      xvarXvar[iPara][jPara]=0;
    }
  }
  for(int ielas=0;ielas<nelas;ielas++)
  {
    double ma=mA+step_ma*(ielas-(nelas-1)/2);
    Exp.set_m_A(ma);
    double MA=Exp.ret_m_A();
    double chi=Exp.ChiMaxl(anor,chimax,data_thy);
    cout<<"m_A= "<<MA<<" max_like="<<chi<<endl;
    for(int iPara=0;iPara<NPARA;iPara++)
    {
      xvarLasGain[iPara]+=pow(ma,iPara)*chi;
      for(int jPara=0;jPara<NPARA;jPara++)
      {
         xvarXvar[iPara][jPara]+=pow(ma,iPara+jPara);
      }
    }
  }
  int ier;
  syminv(xvarXvar,NPARA,ier);
//  cout<<" para = ";
  for(int iPara=0;iPara<NPARA;iPara++)
  {
    double parameter=0;
    for(int jPara=0;jPara<NPARA;jPara++)
    {
      parameter+=xvarLasGain[jPara]*xvarXvar[iPara][jPara];
    }
    para[iPara]=parameter;
//    cout<<para[iPara]<<" ";
  }
//  cout<<endl;
  double M_a=-para[1]/(para[2]*2.0);
  double chimin=para[0]-para[1]*para[1]/(4.0*para[2]);
  double error=1.0/sqrt(para[2]);
  cout<<"  M_a="<<M_a<<" chimin="<<chimin<<" error="<<error<<endl;
}
