#include "Elastic.h"
#include "Experiment.h"
#include "Min_quad_poly.h"
#include <iostream>
#include <fstream>
#include <stdio.h>
#include <stdlib.h>
#include<string.h>
#include<string>
#include<math.h>
const int NPARA = 3;
void Fit_ma(Experiment&, double, char*, char*);
void syminv(double a[][NPARA] ,int  ,int& );

int main()
{
  double MA;
  double anor;
  double accu=0.005;
  char* chimax="chi"; // "chi";
// for "maxl" the setting for data_thy doesn't matter
  char* data_thy="data";
  cout<<" chimax="<<chimax<<", errors="<<data_thy<<" accu = "<<accu<<endl;
  anor=0.9696;
  cout<<" chimax="<<chimax<<", errors="<<data_thy<<" accu = "<<accu<<endl;
  Experiment Exp01("Ahrens_87_nu","nu","SinghD","Olsson","zero","Olsson","Olsson",1.48978,-1.23,0.105658,1.,0.84,accu);
//
  anor=0.955;
  Experiment Exp11("Ahrens_87_nub","nub","SinghD","Olsson","zero","Olsson","Olsson",0.8675,-1.23,0.105658,1.,0.84,accu);
  Exp11.InitExperiment();
  Fit_ma(Exp11,anor,chimax,data_thy);
//
  anor=1.00;
  Experiment Exp21("Bonetti_77_nu","nu","SinghD","dipole","zero","dipole","dipole",1.4108,-1.23,0.105658,1.,0.84,accu);
  Exp21.InitExperiment();
  Fit_ma(Exp21,anor,chimax,data_thy);
//
  anor=0.999;
  Experiment Exp31("Bonetti_77_nub","nub","SinghD","dipole","zero","dipole","dipole",1.0903,-1.23,0.105658,1.,0.84,accu);
  Exp31.InitExperiment();
  Fit_ma(Exp31,anor,chimax,data_thy);
//
  anor=0.556;
  Experiment Exp41("Armenise_79","nub","SinghD","dipole","zero","dipole","dipole",0.9405,-1.26,0.105658,1.,0.84,accu);
  Exp41.InitExperiment();
  Fit_ma(Exp41,anor,chimax,data_thy);
//
  anor=0.8913;
  Experiment Exp51("Astratyan_84","nub","SinghD","Olsson","zero","Olsson","Olsson",0.877,-1.26,0.105658,1.,0.84,accu);
  Exp51.InitExperiment();
  Fit_ma(Exp51,anor,chimax,data_thy);
//
  anor=0.639;
  Experiment Exp61("Brunner_90_nub","nub","SinghD","Olsson","zero","Olsson","Olsson",0.8274,-1.254,0.105658,1.,0.84,accu);
  Exp61.InitExperiment();
  Fit_ma(Exp61,anor,chimax,data_thy);
//
  anor=0.563;
  Experiment Exp71("Pohl_79","nu","SinghD","dipole","zero","dipole","dipole",0.619,-1.24,0.105658,1.,0.84,accu);
  Exp71.InitExperiment();
  Fit_ma(Exp71,anor,chimax,data_thy);
}
  void Fit_ma(Experiment& Exp,double anor,char* chimax,char *data_thy)
{
  int npr=0;
  const int num_nor=7;
  const int nelas=7;
  double chi2[nelas][num_nor];
  double step_ma=0.02;
  double step_nor=0.02;
  double mA=Exp.ret_m_A();
  Exp.WriteExperiment();
  cout<<"Exp="<<Exp.return_exper()<<endl;
  Min_quad_poly Min_poly[num_nor];
  for(int i_nor=0;i_nor<num_nor;i_nor++)
  {
    Min_poly[i_nor].initPara();
  }
  for(int ielas=0;ielas<nelas;ielas++)
  {
    for(int i_nor=0;i_nor<num_nor;i_nor++)
    {
      double ma=mA+step_ma*(ielas-(nelas-1)/2);
      Exp.set_m_A(ma);
      double MA=Exp.ret_m_A();
      double xnor=anor+step_nor*(i_nor-(num_nor-1)/2);
      chi2[ielas][i_nor]=Exp.ChiMaxl(xnor,chimax,data_thy);
      if(npr>0)
      {
        cout<<"m_A = "<<MA<<" xnor= "<<xnor<<" max_like = "<<chi2[ielas][i_nor]<<endl;
      }
      Min_poly[i_nor].Fill_array(ma,chi2[ielas][i_nor]);
    }
  }
  cout<<"          ";
  for(int i_nor=0;i_nor<num_nor;i_nor++)
  {
    double xnor=anor+step_nor*(i_nor-(num_nor-1)/2);
    cout<<xnor<<"  ";
  }
  cout<<endl;
  for(int ielas=0;ielas<nelas;ielas++)
  {
    double ma=mA+step_ma*(ielas-(nelas-1)/2);
    cout<<ma<<"  ";
    for(int i_nor=0;i_nor<num_nor;i_nor++)
    {
      cout<<chi2[ielas][i_nor]<<" ";
    }
    cout<<endl;
  }
  cout<<endl;
  for(int i_nor=0;i_nor<num_nor;i_nor++)
  {
    double xnor=anor+step_nor*(i_nor-(num_nor-1)/2);
    Min_poly[i_nor].Find_min();
    double M_a=Min_poly[i_nor].return_xvalmin();
    double chimin= Min_poly[i_nor].return_yvalmin();
    double error=Min_poly[i_nor].return_error();
    cout<<" xnor="<<xnor<<" M_a="<<M_a<<" chimin="<<chimin<<" error="<<error<<" M_a - input="<< M_a-mA<<endl;
  }
  cout<<endl;
}
