#include "Elastic.h"
#include "Experiment.h"
#include <iostream>
#include <fstream>
#include <stdio.h>
#include <stdlib.h>
#include<string.h>
#include<string>
#include<math.h>
const int NPARA = 3;
void Fit_ma(Experiment&, double, char*, char*);
void syminv(double a[][NPARA] ,int  ,int& );

int main()
{
  double MA;
  double anor=1.00;
  char* chimax="maxl"; // "chi";
// for "maxl" the setting for data_thy doesn't matter
  char* data_thy="theory";
  cout<<" chimax="<<chimax<<", errors="<<data_thy<<endl;
    Experiment Exp20("Baker_81","nu","SinghD","Olsson","zero","Olsson","Olsson",1.07888,-1.23,0.105658,1.,.84,.0005);
    Exp20.InitExperiment();
    Fit_ma(Exp20,anor,chimax,data_thy);
    Experiment Exp21("Baker_81","nu","SinghD","Olsson","zero","Olsson","Olsson",1.08115,-1.254,0.105658,1.,.84,.0005);
    Exp21.InitExperiment();
    Fit_ma(Exp21,anor,chimax,data_thy);
    Experiment Exp22("Baker_81","nu","SinghD","Olsson","zero","Olsson","Olsson",1.08235,-1.267,0.105658,1.,.84,.0005);
    Exp22.InitExperiment();
    Fit_ma(Exp22,anor,chimax,data_thy);
    Experiment Exp27("Baker_81","nu","SinghD","AB","AB","AB","AB",1.0457,-1.23,0.105658,1.,.842615,.0005);
    Exp27.InitExperiment();
    Fit_ma(Exp27,anor,chimax,data_thy);
    Experiment Exp28("Baker_81","nu","SinghD","AB","AB","AB","AB",1.05044,-1.267,0.105658,1.,.842615,.0005);
    Exp28.InitExperiment();
    Fit_ma(Exp28,anor,chimax,data_thy);
    Experiment Exp29("Baker_81","nu","SinghD","AB","AB","AB","AB",1.05044,-1.267,0.105658,1.,.842615,.0005);
    Exp29.InitExperiment();
    Fit_ma(Exp29,anor,chimax,data_thy);
}
  void Fit_ma(Experiment& Exp,double anor,char* chimax,char *data_thy)
{
  double  xvarLasGain[NPARA];
  double  xvarXvar[NPARA][NPARA];
  double para[NPARA];
  int nelas=9;
  int num_nor=1;
  double step_ma=0.002;
  double step_nor=0.002;
  double mA=Exp.ret_m_A();
  Exp.WriteExperiment();
  cout<<"Exp="<<Exp.return_exper()
  <<" nucCorrecton="<<Exp.ret_nucCorrType()<<endl;
  for(int iPara=0;iPara<NPARA;iPara++)
  {
    xvarLasGain[iPara]=0;
    for(int jPara=0;jPara<NPARA;jPara++)
    {
      xvarXvar[iPara][jPara]=0;
    }
  }
  for(int ielas=0;ielas<nelas;ielas++)
  {
    double ma=mA+step_ma*(ielas-(nelas-1)/2);
    Exp.set_m_A(ma);
    double MA=Exp.ret_m_A();
    double chi=Exp.ChiMaxl(anor,chimax,data_thy);
//    cout<<"m_A= "<<MA<<" max_like="<<chi<<endl;
    for(int iPara=0;iPara<NPARA;iPara++)
    {
      xvarLasGain[iPara]+=pow(ma,iPara)*chi;
      for(int jPara=0;jPara<NPARA;jPara++)
      {
         xvarXvar[iPara][jPara]+=pow(ma,iPara+jPara);
      }
    }
  }
  int ier;
  syminv(xvarXvar,NPARA,ier);
//  cout<<" para = ";
  for(int iPara=0;iPara<NPARA;iPara++)
  {
    double parameter=0;
    for(int jPara=0;jPara<NPARA;jPara++)
    {
      parameter+=xvarLasGain[jPara]*xvarXvar[iPara][jPara];
    }
    para[iPara]=parameter;
//    cout<<para[iPara]<<" ";
  }
//  cout<<endl;
  double M_a=-para[1]/(para[2]*2.0);
  double chimin=para[0]-para[1]*para[1]/(4.0*para[2]);
  double error=1.0/sqrt(para[2]);
  cout<<"  M_a="<<M_a<<" chimin="<<chimin<<" error="<<error<<" M_a - input = "<< M_a-mA<<endl;
}
