#include "Elastic.h"
#include "Experiment.h"
#include <iostream>
#include <fstream>
#include <stdio.h>
#include <stdlib.h>
#include<string.h>
#include<string>
#include<math.h>
const int NPARA = 3;
void Fit_ma(Experiment&, double, char*, char*);
void syminv(double a[][NPARA] ,int  ,int& );

int main()
{
  double MA;
  double anor=1.00;
  double accu=.0005;
  char* chimax="maxl"; // "chi";
// for "maxl" the setting for data_thy doesn't matter
  char* data_thy="theory";
  cout<<" chimax="<<chimax<<", errors="<<data_thy<<endl;
//  int iexp=3;
//  if(iexp==0)
//  {
    MA=1.117;
    Experiment Exp01("Miller_82","nu","SinghD","Olsson","zero","Olsson","Olsson",1.11627,-1.23,0.105658,1.,.84,accu);
    Exp01.InitExperiment();
    Fit_ma(Exp01,anor,chimax,data_thy);
    Experiment Exp04("Miller_82","nu","SinghD","dipole","zero","dipole","dipole",1.13595,-1.267,0.105658,1.,.842615,accu);
    Exp04.InitExperiment();
    Fit_ma(Exp04,anor,chimax,data_thy);
    Experiment Exp06("Miller_82","nu","SinghD","JRA_CS_HallA","Krutov","JRA_CS_HallA","JRA",1.09117,-1.267,0.105658,1.,.842615,accu);
    Exp06.InitExperiment();
    Fit_ma(Exp06,anor,chimax,data_thy);
    Experiment Exp09("Miller_82","nu","SinghD","Kelly","AB25","Kelly","AB25",1.07954,-1.267,0.105658,1.,.842615,accu);
    Exp09.InitExperiment();
    Fit_ma(Exp09,anor,chimax,data_thy);
//  }
//  else if (iexp==1)
//  {
    MA=1.075;
    Experiment Exp11("Barish_77","nu","SinghD","Olsson","zero","Olsson","Olsson",1.07462,-1.23,0.105658,1.,.84,accu);
    Exp11.InitExperiment();
    Fit_ma(Exp11,anor,chimax,data_thy);
    Experiment Exp14("Barish_77","nu","SinghD","dipole","zero","dipole","dipole",1.09491,-1.267,0.105658,1.,.842615,accu);
    Exp14.InitExperiment();
    Fit_ma(Exp14,anor,chimax,data_thy);
    Experiment Exp16("Barish_77","nu","SinghD","JRA_CS_HallA","Krutov","JRA_CS_HallA","JRA",1.04854,-1.267,0.105658,1.,.842615,accu);
    Exp16.InitExperiment();
    Fit_ma(Exp16,anor,chimax,data_thy);
    Experiment Exp19("Barish_77","nu","SinghD","Kelly","AB25","Kelly","AB25",1.03917,-1.267,0.105658,1.,.842615,accu);
    Exp19.InitExperiment();
    Fit_ma(Exp19,anor,chimax,data_thy);
//  }
//  else if (iexp==2)
//  {
    MA=1.079;
    Experiment Exp21("Baker_81","nu","SinghD","Olsson","zero","Olsson","Olsson",1.07878,-1.23,0.105658,1.,.84,accu);
    Exp21.InitExperiment();
    Fit_ma(Exp21,anor,chimax,data_thy);
    Experiment Exp24("Baker_81","nu","SinghD","dipole","zero","dipole","dipole",1.10387,-1.267,0.105658,1.,.842615,accu);
    Exp24.InitExperiment();
    Fit_ma(Exp24,anor,chimax,data_thy);
    Experiment Exp27("Baker_81","nu","SinghD","JRA_CS_HallA","Krutov","JRA_CS_HallA","JRA",1.05465,-1.267,0.105658,1.,.842615,accu);
    Exp27.InitExperiment();
    Fit_ma(Exp27,anor,chimax,data_thy);
    Experiment Exp29("Baker_81","nu","SinghD","Kelly","AB25","Kelly","AB25",1.04516,-1.267,0.105658,1.,.842615,accu);
    Exp29.InitExperiment();
    Fit_ma(Exp29,anor,chimax,data_thy);
//  }
//  else if (iexp==3)
//  
    MA=1.194;
    Experiment Exp31("Kitagaki_83","nu","SinghD","Olsson","zero","Olsson","Olsson",1.1947,-1.23,0.105658,1.,.84,accu);
    Exp31.InitExperiment();
    Fit_ma(Exp31,anor,chimax,data_thy);
    Experiment Exp34("Kitagaki_83","nu","SinghD","dipole","zero","dipole","dipole",1.22541,-1.267,0.105658,1.,.842615,accu);
    Exp34.InitExperiment();
    Fit_ma(Exp34,anor,chimax,data_thy);
    Experiment Exp37("Kitagaki_83","nu","SinghD","JRA_CS_HallA","Krutov","JRA_CS_HallA","JRA",1.17572,-1.267,0.105658,1.,.842615,accu);
    Exp37.InitExperiment();
    Fit_ma(Exp37,anor,chimax,data_thy);
    Experiment Exp39("Kitagaki_83","nu","SinghD","Kelly","AB25","Kelly","AB25",1.16985,-1.267,0.105658,1.,.842615,accu);
    Exp39.InitExperiment();
    Fit_ma(Exp39,anor,chimax,data_thy);
//  }
//  else if (iexp==1)
//  {
//   MA=1.079;
//    Experiment Exp81("Kitagaki_90","nu","SinghD","Olsson","zero","Olsson","Olsson",1.096,-1.254,0.105658,1.,.84,accu);
//    Exp81.InitExperiment();
//    Fit_ma(Exp81,anor,chimax,data_thy);
//    Experiment Exp84("Kitagaki_90","nu","SinghD","dipole","zero","dipole","dipole",1.1221,-1.267,0.105658,1.,.842615,accu);
//    Exp84.InitExperiment();
//    Fit_ma(Exp84,anor,chimax,data_thy);
//    Experiment Exp87("Kitagaki_90","nu","SinghD","JRA_CS_HallA","Krutov","JRA_CS_HallA","JRA",1.0719,-1.267,0.105658,1.,.842615,accu);
//    Exp87.InitExperiment();
//    Fit_ma(Exp87,anor,chimax,data_thy);
//    Experiment Exp89("Kitagaki_90","nu","SinghD","Kelly","AB25","Kelly","AB25",1.06756,-1.267,0.105658,1.,.842615,accu);
//    Exp89.InitExperiment();
//    Fit_ma(Exp89,anor,chimax,data_thy);
}
  void Fit_ma(Experiment& Exp,double anor,char* chimax,char *data_thy)
{
  double  xvarLasGain[NPARA];
  double  xvarXvar[NPARA][NPARA];
  double para[NPARA];
  int nelas=9;
  int num_nor=1;
  double step_ma=0.002;
  double step_nor=0.002;
  double mA=Exp.ret_m_A();
  Exp.WriteExperiment();
  cout<<"Exp="<<Exp.return_exper()
  <<" nucCorrecton="<<Exp.ret_nucCorrType()<<endl;
  for(int iPara=0;iPara<NPARA;iPara++)
  {
    xvarLasGain[iPara]=0;
    for(int jPara=0;jPara<NPARA;jPara++)
    {
      xvarXvar[iPara][jPara]=0;
    }
  }
  for(int ielas=0;ielas<nelas;ielas++)
  {
    double ma=mA+step_ma*(ielas-(nelas-1)/2);
    Exp.set_m_A(ma);
    double MA=Exp.ret_m_A();
    double chi=Exp.ChiMaxl(anor,chimax,data_thy);
//    cout<<"m_A= "<<MA<<" max_like="<<chi<<endl;
    for(int iPara=0;iPara<NPARA;iPara++)
    {
      xvarLasGain[iPara]+=pow(ma,iPara)*chi;
      for(int jPara=0;jPara<NPARA;jPara++)
      {
         xvarXvar[iPara][jPara]+=pow(ma,iPara+jPara);
      }
    }
  }
  int ier;
  syminv(xvarXvar,NPARA,ier);
//  cout<<" para = ";
  for(int iPara=0;iPara<NPARA;iPara++)
  {
    double parameter=0;
    for(int jPara=0;jPara<NPARA;jPara++)
    {
      parameter+=xvarLasGain[jPara]*xvarXvar[iPara][jPara];
    }
    para[iPara]=parameter;
//    cout<<para[iPara]<<" ";
  }
//  cout<<endl;
  double M_a=-para[1]/(para[2]*2.0);
  double chimin=para[0]-para[1]*para[1]/(4.0*para[2]);
  double error=1.0/sqrt(para[2]);
  cout<<"  M_a="<<M_a<<" chimin="<<chimin<<" error="<<error<<" M_a - input = "<< M_a-mA<<endl;
}
