
//______________________________________________________________________________
//*-*-*-*-*-*-*-*-*-*-*-*The Minuit standard test program-*-*-*-*-*-*-*-*-*
//*-*                    ========================                         *
//*-*                                                                     *
//*-*    This program is the translation to C++ of the minelas program    *
//*-*    distributed with the Minuit/Fortran source file.                 *
//*-*         original author Fred James                                  *
//*-*                                                                     *
//*-*       Fit randomly-generated leptonic K0 decays to the              *
//*-*       time distribution expected for interfering K1 and K2,         *
//*-*       with free parameters Re(X), Im(X), DeltaM, and GammaS.        *
//*-*                                                                     *
//*-*   This program can be run in batch mode with the makefile           *
//*-*   or executed interactively with the command:                       *
//*-*         Root > .x minelas.cxx                                       *
//*-*                                                                     *
//*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*


void fcnk0(int &npar, double *gin, double &chisq, double *para, int iflag);
int minelas();

#ifndef __CINT__
#include "TVirtualFitter.h"
#include "TMath.h"
#include "TStopwatch.h"
#include "Experiment.h"
#include "Elastic.h"
#include <stdlib.h>
#include <stdio.h>
#include <iostream>
#include <fstream>


//______________________________________________________________________________
//int main()
//{
//   return minelas();
//}
#endif

int minelas()
{
   TStopwatch timer;

   // Initialize TMinuit via generic fitter interface with a mabparum of 2 params
   TVirtualFitter *minuit = TVirtualFitter::Fitter(0, 2);
   printf("Starting timern");
   timer.Start();
   minuit->SetFCN(fcnk0);

   minuit->SetParameter(0, "m_A", 0.95  ,     0.1, 0,0);
   minuit->SetParameter(1, "norm",   1.0,     0.1, 0,0);

//*-*-       Request FCN to read in (or generate random) data (IFLAG=1)
   Double_t arglist[100];
   arglist[0] = 1;
   minuit->ExecuteCommand("CALL FCN", arglist, 1);
   minuit->FixParameter(2);
   arglist[0] = 0;
   minuit->ExecuteCommand("SET PRINT", arglist, 1);
   minuit->ExecuteCommand("MIGRAD", arglist, 0);
   minuit->ExecuteCommand("MINOS", arglist, 0);
   minuit->ReleaseParameter(2);
   minuit->ExecuteCommand("MIGRAD", arglist, 0);
   minuit->ExecuteCommand("MINOS", arglist, 0);
   arglist[0] = 3;
   minuit->ExecuteCommand("CALL FCN", arglist, 1);

   printf("Time at the end of job = %f secondsn",timer.CpuTime());
   return 0;
}
//______________________________________________________________________________
void fcnk0(Int_t &, Double_t *, Double_t &chisq, Double_t *para, Int_t iflag)
{
// initialize data
  if (iflag == 1) 
  {
    cout<<"initializing stuff"<<endl;     
//    static Experiment ExpB("Barish_77","nu","one","dipole","zero","dipole","dipole",0.95,-1.23);
  }
//         chisquared or max likelyhood
  ExpB.set_m_A(para[0]);
  chisq=ExpB.ChiMaxl(para[1],"maxl");// 2d parameter is maxl or chi
  cout<<"chisq, a_M, norm= "<<chisq<<" "<<*para<<" "<<*(para+1)<<" "<<endl;
}
