#include <cstring>
#include <cstdlib>
#include "NucCorr.h"
#include <math.h>
#include <stdio.h>
#include <cstdlib>
#include <iostream>
NucCorr::NucCorr(char* nu_nubar
                ,char* nucCorrectionType)
{
  strcpy(nu_nub,nu_nubar);
  strcpy(nucCorrType,nucCorrectionType);
}
void  NucCorr::InitNucCorr()
{
  CreateNukeSplineFile();
}
double NucCorr::FermiGasGatto(double q2)
// NucCorr Physics B28 (1971)317
{
  int num_proton=20;
  int num_neutron=30;
  double kF=0.3;
  double ZZ=num_proton;
  double NN=num_neutron;
  double AA = num_proton + num_neutron;
  double xx=sqrt(-q2)/(2.0*kF);
  double uu=pow(2.0*NN/AA,1.0/3.0);
  double vv=pow(2.0*ZZ/AA,1.0/3.0);
  if(2.0*xx<uu-vv)
  {
    return 1.0-ZZ/NN;
  }
  else if(2.0*xx>uu-vv&&2.0*xx<uu+vv)
  {
    return 1.0 - 
    0.5*AA*(1.0-0.75*xx*(uu*uu+vv*vv)+pow(xx,3)/2.0-3.0*pow(uu*uu-vv*vv,2)/(32.0*xx))/NN;
  }
  else
  {
    return 1.0;
  }
}
double NucCorr::NukeSplineFile(double e_nu)
// from Nuke data fileData file generated by Sam
{
  if(e_nu<spline_nuke_corr.Return_xMinSpline())
  {
    return 0; 
  }
  else if(e_nu>=spline_nuke_corr.Return_xMaxSpline())
  {
    return 1.0/spline_nuke_corr.Splint(spline_nuke_corr.Return_xMaxSpline());
  }
  else
  {
    return 1.0/spline_nuke_corr.Splint(e_nu);
  }
}
// return the values of the constructor
char* NucCorr::ret_nucCorrType() {return nucCorrType;}
double NucCorr::SinghD(double q2)
// From Nucl Phys B36 (1972) 419-435 for Deuterium
{
  double par[3]= {0.588918, -17.2306, 0.749157};
  return 1.0-par[0]*exp(par[1]*pow(-q2,par[2]));
}
double NucCorr::Nuke(double q2, double e_nu)
// NucCorr Correction
{
  if(strcmp(nucCorrType,"one")==0)
  {
    return 1.0;
  }
  else if(strcmp(nucCorrType,"SinghD")==0)
  {
    return SinghD(q2);
  }
  else if(strcmp(nucCorrType,"Gatto")==0)
  {
    return FermiGasGatto(q2);  
  }
  else if(strcmp(nucCorrType,"NucSpl")==0)
  {
    return NukeSplineFile(e_nu);
  }
  else if(strcmp(nucCorrType,"NeugQE")==0)
  {
    return NeugQE(q2);
  }
  else 
  {
     cout<<" In Nuke "<<nucCorrType<<" is not a valid option"<<endl;
     exit(1);
  }
}
void NucCorr::CreateNukeSplineFile()
{
  if(strcmp(nu_nub,"nu")==0)
  {	 
    spline_nuke_corr.Set_spline_file("nuke/NuNukeNucleon_Carbon.dat");
  }
  else 
  {	 
    spline_nuke_corr.Set_spline_file("nuke/NubNukeNucleon_Carbon.dat");
  }
  spline_nuke_corr.MakeSplineObjFromFile();
}
void NucCorr::WriteNucCorr()
{
 if(strcmp(nucCorrType,"NucSpl")==0)
  {
    cout<<" ( nucCorrType="<<ret_nucCorrType()
        <<", Spline File  = "<< spline_nuke_corr.Ret_spline_file()<<endl;
  }
  else
  {
    cout<<" ( nucCorrType="<<ret_nucCorrType()<<endl;
  }
}
double NucCorr::q_3(double q2)
{
  double m_P=0.938919;
  return sqrt(q2*q2/(4.0*m_P*m_P)-q2);
}
double NucCorr::NeugQE(double q2)
{
// note these are for C12
  double kf=0.221; 
  double pf=0.221; 
  double q3=q_3(q2);
  double pmax=0.5;
  double r;
  r_factor( q3, kf, pf, pmax,r);  
  return r;
}
void NucCorr::r_factor(double q,double kf,double pf,double pmax,double& r) 
{
//---------------------------------------------------------------------
//
//   Description:  Calculate the quasi-elastic scattering reduction 
//                 factor R for scattering off of nuclear targets. 
//
//   Notes:   This routine is based on an analytic calculation of 
//            the rejection factor in the Fermi Gas model using the 
//            form for the fermi momentum distribution given in the 
//            Bodek and Ritchie paper.  P.R.  D23 (1981) 1070
// 
//            R is the ratio of the differential cross section from 
//            the nuclear material specified by (kf,pf) to the 
//            differential cross section for a free nucleon.   
// 
//   Inputs  :    q  -R-  magnitude of the 3-momentum transfer to 
//                        the nucleon
//               kf  -R-  Fermi Gas model Fermi momentum for initial
//                        nucleons
//               pf  -R-  Fermi Gas model Fermi momentum for final
//                        nucleons
//             pmax  -R-  Cutoff value for the Bodek-Ritchie tail.
//
//   Outputs :    r  -R-  The reduction factor 
//
//   Author: H. Gallagher (Mar 2003) 
// 
//   $Id: r_factor.F,v 1.1 2003/06/12 16:15:45 gallaghr Exp $
//
//---------------------------------------------------------------------

  double sum;
  double p1,p2;
  double kfa,rkf;
  double twopie = 6.28318530718;
  kfa = kf*4./twopie;
  rkf = 1./(1.-kf/4.);
  double alpha = 1.-6.*kfa*kfa;
  double beta = 2.*rkf*kfa*kfa*kf*kf*kf*kf;
  fm_area(alpha,beta,kf,pmax,sum);
  if(q<=pf) 
  {
    p1 = pf-q;
    p2 = pf+q;
    r = twopie*(fm_integral1(alpha,beta,p1,p2,kf,pf,q)+
    2.* fm_integral2(alpha,beta,p2,pmax,kf,pf,q) )/sum;
  }
  else if(q>pf&&q<=(pmax-pf)) 
  {
    p1 = q-pf;
    p2 = q+pf;
    r = twopie*(fm_integral1(alpha,beta,p1,p2,kf,pf,q)+
    2.*( fm_integral2(alpha,beta,0.,p1,kf,pf,q)+
         fm_integral2(alpha,beta,p2,pmax,kf,pf,q) ) )/sum;
  }
  else if(q>(pmax-pf)&&q<=(pmax+pf)) 
  {
    p1 = q-pf;
    r = twopie*( 2.*
         fm_integral2(alpha,beta,0.,p1,kf,pf,q)+
         fm_integral1(alpha,beta,p1,pmax,kf,pf,q) ) /sum;
  }
  else if(q>(pmax+pf))
  {
    r = 1.;
  }
  else 
  {
    cout<<" illegal input q = "<<q<<endl;
    exit(1);
  }
}
double NucCorr::fm_integral1
(double alpha,double beta,double a,double b,double kf,double pf,double q) 
{
  if(kf<a) 
  {
    return fm_integral2(alpha,beta,a,b,kf,pf,q)
           - beta*(pf*pf-q*q)/(4.*q)*(1./(a*a) - 1./(b*b))
           + beta/(2.*q)*log(b/a);
  }
  else if(kf>b) 
  {
    return fm_integral2(alpha,beta,a,b,kf,pf,q) 
           -(pf*pf-q*q)*alpha/(4.*q)*(b*b-a*a) 
           +alpha/(8.*q)*(b*b*b*b-a*a*a*a);
  }
  else 
  {
    return  fm_integral2(alpha,beta,a,b,kf,pf,q)
          - alpha*(pf*pf-q*q)/(4.*q)*(kf*kf-a*a)
          + alpha/(8.*q)*(kf*kf*kf*kf - a*a*a*a)
          - beta*(pf*pf-q*q)/(4.*q)*(1./(kf*kf) - 1./(b*b))
          + beta/(2.*q)*log(b/kf);
  }
}
double NucCorr::fm_integral2
(double alpha,double beta,double a,double b,double kf,double pf,double q) 
{
  if(kf<a) 
  {
    return beta*(1./a-1./b);
  }
  else if(kf>b) 
  {
    return  alpha/3.*(b*b*b-a*a*a);
  }
  else 
  {
    return alpha/3.*(kf*kf*kf-a*a*a)
          +   beta*(1./kf-1./b);
  }
}
void NucCorr::fm_area
(double alpha,double beta,double kf,double pmax,double& sum) 
{
  double pi = 3.141592653589793;
  sum = 4.*pi*(alpha*kf*kf*kf/3. +
     beta*(1./kf-1./pmax) );
}
