#include <stdio.h>
#include <stdlib.h>
#include<ctype.h>
#include <math.h>
//#include<string.h>
#include<string>
const int NWRT=0;
int ReadDataq2(std::string,float *,float *,float *);
void WriteData(int, float *,float *,float *);
int ReadFluxq2(std::string,float *,float *,float *);
int ReadDataq2(std::string file,float *xval,float *yval,float *y_err)
{
//  cout<<file.c_str()<<endl;
  int npoint=0;
  char string_in[100];
  FILE *fp = fopen(file.c_str(),"r");
  fgets( string_in,100,fp);
  if(NWRT>0)
  {
    cout<<string_in<<endl;
  }
  fgets( string_in,100,fp);
  float xruler;
  float yruler;
  float ene_scale;
  float q2_scale;
  int fileOK=fscanf(fp,"%f %f %f %f",&xruler ,&yruler ,&ene_scale ,&q2_scale);
  if(NWRT>0)
  {
    cout<<xruler<<" "<<yruler<<" "<<ene_scale<<" "<<q2_scale<<endl;
  }
  float xscl=ene_scale/xruler;
  float yscl=q2_scale/yruler;
  float xpt;
  float ypt;
  float yer_low;
  float yer_hi;
  float yer;
  while (1)
  {
    fileOK=fscanf(fp,"%f %f %f %f %f",&xpt,&ypt,&yer_low,&yer_hi,&yer);
    if (fileOK < 0) break;
    if(NWRT>0)
    {
      cout<<xpt<<endl;
    }
    xval[npoint]=xpt*xscl;
    yval[npoint]=ypt*yscl;
    y_err[npoint]=(yer_hi-yer_low)*yscl*0.5;
    npoint++;
  }
  fclose(fp);
  return npoint;
}
int ReadFluxq2(std::string file,float *xval,float *x_err,float *yval,float *y_err)
{
  if(NWRT>0)
  {
    cout<<file.c_str()<<endl;
  }
  int npoint=0;
  char string_in[100];
  FILE *fp = fopen(file.c_str(),"r");
  fgets( string_in,100,fp);
  fgets( string_in,100,fp);
  float xruler;
  float yruler;
  float ene_scale;
  float flux_scale;
  float flux_offset;
  int fileOK=fscanf
  (fp,"%f %f %f %f %f",&xruler ,&yruler ,&ene_scale ,&flux_scale,&flux_offset);
  if(NWRT>0)
  {
    cout<<xruler<<" "<<yruler<<" "<<ene_scale
    <<" "<<flux_scale<<" "<<flux_offset<<endl;
  }
  float xscl=ene_scale/xruler;
  float yscl=log(flux_scale/flux_offset)/yruler;
  float xpt;
  float xer_low;
  float xer_hi;
  float ypt;
  float yer_low;
  float yer_hi;
  while (1)
  {
    fileOK=fscanf(fp,"%f %f %f %f %f %f",&xpt,&ypt,&xer_low,&xer_hi,&yer_low,&yer_hi);
    if (fileOK < 0) break;
    if(NWRT>0)
    {
      cout<<xpt<<endl;
    }
    xval[npoint]=xpt*xscl;
    x_err[npoint]=(xer_hi-xer_low)*xscl*0.5;
    yval[npoint]=flux_offset*exp(ypt*yscl);
    y_err[npoint]=flux_offset*(exp(yer_hi*yscl)-exp(yer_low*yscl))*0.5;
    npoint++;
  }
  fclose(fp);
  return npoint;
}
void WriteData(int npoint, float *xval,float *yval,float *x_err,float *y_err)
{
  for (int ii=0; ii<npoint;ii++)
  {
    cout<<xval[ii]<<" "<<yval[ii]<<" "<<x_err[ii]<<" "<<y_err[ii]<<endl;
  }
}
