//Spline.h
#ifndef SPLINE_H
#define SPLINE_H
#include <math.h>
#include <cstdlib>
#include <cstring>
#include <iostream>
#include <fstream>
const int NDATA_MAX=450;
class Spline
{
  public:
  Spline();
  Spline(int,double*,double*);
  Spline(int,double*,double*,double,double);
  void PutDataInSplineObj(const int,double*,double*,double,double);
  void PutDataInSplineObj(const int,double*,double*);
  void CalcFunctDoublePrime(); // calculates yd_p2, f''
  double Splint(double); // return spline value
  double Return_xMinSpline();
  double Return_xMaxSpline();
  int Return_numDataPts();
  int Index_low(double); // the lower index of the point 
  void WrtInput();
//
  protected:
  private:
   double xMinSpline; // min x value
   double xMaxSpline; // max x value
   int numDataPts;
   double xd[NDATA_MAX]; // the x values of the  points
   double yd[NDATA_MAX]; // the y values of the points
   double yd_p2[NDATA_MAX]; // the calculated f'' at the x values
   double yd_p1_1;//f' at x[0], set to yd[1]-yd[0])/(xd[1]-xd[0])
   double yd_p1_n;//f' at x[numSpline-1]
   //, set to (yd[numSpline-1]-yd[numSpline-2])/(xd[numSpline-1]-xd[numSpline-2])
};
#endif
