#include <math.h>
#include <cstdlib>
#include <cstring>
#include <iostream>
#include <stdio.h>
#include <fstream>
#include "SplineArea.h"
//
SplineArea::SplineArea()
{
  xMinSpline=0;
  xMaxSpline=0;
  numDataPts=0;
  for(int i=0;i<ndata_max;i++)
  {
    xd[i]=0;
    for(int j=0;j<ncoef;j++)
    {
      coef[j][i]=0;
    }
  }
}
void SplineArea::PutDataInSplineAreaObj(char* file)
{
  FILE *fp = fopen(file,"r");
  int ind, fileOK;
  float xpt, acoef[ncoef];
  numDataPts=0;
  while (1)
  {
    fileOK=fscanf(fp,"%d %f %f %f %f",&ind,&xpt,&acoef[0],&acoef[1],&acoef[2]);
    if (fileOK < 0) break;
    numDataPts++;
    xd[ind]=xpt;
    for(int i=0;i<ncoef;i++)
    {
      coef[i][ind]=acoef[i];
    }
  }
  numDataPts--;
  if(numDataPts==0)
  {
    cout<<" no coef for spline fit"<<endl;
    exit(1);
  }
  xMinSpline=xd[0];
  xMaxSpline=xd[numDataPts];
}
double SplineArea::Splint(double x)
{
  if(x<xd[0]||x>xd[numDataPts])
  {
    return 0;
  }
  int klo=0;
  int khi=numDataPts;
  while(khi-klo>1)
  {
    int k=(khi+klo)/2;
    if(xd[k]>x)
    {
      khi=k;
    }
    else
    {
      klo=k;
    }
  }
//  cout<<" klo="<<klo<<endl;
  double  h=0;
  for(int i=0;i<ncoef;i++)
  {
    h+=coef[i][klo]*pow(x,i);
  }
  return h;
}
double SplineArea::Return_xMinSpline(){return xMinSpline;}
double SplineArea::Return_xMaxSpline(){return xMaxSpline;}
int SplineArea::Return_numDataPts(){return numDataPts;}
 
