#include <math.h>
#include <cstdlib>
#include <cstring>
#include <iostream.h>
#include <stdio.h>
#include <fstream.h>
#include "SplineFile.h"
//
SplineFile::SplineFile() { }
SplineFile::SplineFile(char* spl_file) { strcpy(spline_file,spl_file); }
void SplineFile::Set_spline_file(char* spl_file) {strcpy(spline_file,spl_file);}
char* SplineFile::Ret_spline_file() {return spline_file;}
//
void SplineFile::MakeSplineObjFromFile()
{
  float x_fl[NARRAY];
  float y_fl[NARRAY];
  double x_doub[NARRAY];
  double y_doub[NARRAY];
  for(int id=0;id<NARRAY;id++)
  {
    x_fl[id]=0;
    y_fl[id]=0;
  }
  int nFuncPt=GetDataFromFile(x_fl,y_fl); 
  for(int id=0;id<nFuncPt;id++)
  {
    x_doub[id]=x_fl[id];
    y_doub[id]=y_fl[id];
  }
  PutDataInSplineObj(nFuncPt,x_doub,y_doub); 
}
int SplineFile::GetDataFromFile(float *xval,float *yval)
// Reads in function which is just points on dots, no log conversion
{
  int npoint=0;
  char string_in[100];
  FILE *fp;
  if(( fp = fopen(spline_file,"r"))==NULL)
  {
    cout<<" In SplineFile cannot open file "<<spline_file<<", exiting."<<endl;
    exit(1);
  }
  fgets( string_in,100,fp);
  if(NWRITE>0)
  {
    cout<<string_in<<endl;
  }
  fgets( string_in,100,fp);
  float xruler;
  float yruler;
  float x_scale;
  float y_scale;
  int fileOK=fscanf(fp,"%f %f %f %f",&xruler ,&yruler ,&x_scale ,&y_scale);
  if(NWRITE>0)
  {
    cout<<xruler<<" "<<yruler<<" "<<x_scale<<" "<<y_scale<<endl;
  }
  float xscl=x_scale/xruler;
  float yscl=y_scale/yruler;
  int ind;
  float xpt;
  float ypt;
  float bin_width=0;
// need to check that file is OK, x[i+1]>x[i]
  float x_previous=-9999999e15;
  while (1)
  {
    fileOK=fscanf(fp,"%f %f",&xpt,&ypt);
    if (fileOK < 0) break;
// check if file is OK
    if(xpt<=x_previous)
    {
       cout<<"Spline file "<<spline_file<<"  is bad, x[i-1] = "
       <<x_previous <<", x[i] = "<<xpt<<endl;
       exit(1);
    }
    x_previous=xpt;
    if(npoint<NWRITE)
    {
      cout<<xpt<<" "<<ypt<<endl;
    }
    xval[npoint]=xpt*xscl;
    yval[npoint]=ypt*yscl;
    npoint++;
  }
  fclose(fp);
  if(npoint==0)
  {
    cout<<" In GetDataFromFile File "<<spline_file<<"is bad."<<endl;
    exit(1);
  }
  return npoint;
}
