c------------------------------------------------------------------
ccc   Q^2 > 0 in GeV^2, and up to Q^2 ~ 6 GeV^2 can calculate 
ccc   but model limit may be up to Q^2 ~ 2 GeV^2
ccc   GEp,GEn,GMp,GMn,GA ratios of bound/free 
ccc   (ignore Q^2=0 for G^n_E)
ccc   (by K. Tsushima Sep. 3, 2003) 
c------------------------------------------------------------------
      program qmcffratio
c------------------------------------------------------------------
      IMPLICIT REAL*8 (A-H,O-Z)
C
      common/ffact/nq2
      common/rrspline/brgep(5000),crgep(5000),drgep(5000),
     &                brgen(5000),crgen(5000),drgen(5000),
     &                brgmp(5000),crgmp(5000),drgmp(5000),
     &                brgmn(5000),crgmn(5000),drgmn(5000),
     &                brga(5000),crga(5000),drga(5000)
      common/qmc/q2in(5000),geprin(5000),genrin(5000),
     &           gmprin(5000),gmnrin(5000),garin(5000)
      common/results/xgeprat,xgenrat,xgmprat,xgmnrat,xgarat
c
      nq2=3001 !size of input data
c
ccc------ in units of rho0 = 0.15 fm^-3
ccc   rhoc12=0.66755d0     !k^n_F = k^p_F = 225 MeV, rho0 = 0.15d0 fm^-3
ccc   rrho=rhoc12          !12^C average baryon density
ccc   rrhofe56=0.70930d0   !calculated by the QMC model
ccc   rrho=rrhofe56        !56Fe average baryon density
ccc------ in units of rho0 = 0.15 fm^-3
c
c-----Read in qmc ratio data for f.fs: ia=1 -> 12C, ia=2 -> 56Fe
      ia=2
      if(ia.eq.1)
     &open (unit=9,name='GEMAmed_qmcrat_c12.indat',status='unknown')
      if(ia.eq.2)
     &open (unit=9,name='GEMAmed_qmcrat_fe56.indat',status='unknown')
c
        do i=1,nq2
        read(9,*)q2in(i),geprin(i),genrin(i),
     &           gmprin(i),gmnrin(i),garin(i)
        enddo
C-----CALCULATE THE COEFFICIENTS B,C,D IN A CUBIC SPLINE INTERPOLATION
        call spline(nq2,q2in,geprin,brgep,crgep,drgep)
        call spline(nq2,q2in,genrin,brgen,crgen,drgen)
        call spline(nq2,q2in,gmprin,brgmp,crgmp,drgmp)
        call spline(nq2,q2in,gmnrin,brgmn,crgmn,drgmn)
        call spline(nq2,q2in,garin,brga,crga,drga)
c
c----------------------------------------------------------------
c-----!!! q2 (=Q^2) > 0 in GeV^2, out puts are: 
c     Q^2,GEp,GEn,GMp,GMn,GA ratios of bound/free 
c     (ignore Q^2=0 for G^n_E)
      do q2=0.1d0,0.2d0,0.1d0
      call ratio(q2)
cccOK write(6,100)q2,xgeprat,xgenrat,xgmprat,xgmnrat,xgarat
c100  format(d15.7,5d15.7)
      enddo
c----------------------------------------------------------------
c
        stop
        end
c################################################################
      subroutine ratio(q2)
c################################################################
      implicit real*8(a-h,o-z)
      common/ffact/nq2
      common/rrspline/brgep(5000),crgep(5000),drgep(5000),
     &                brgen(5000),crgen(5000),drgen(5000),
     &                brgmp(5000),crgmp(5000),drgmp(5000),
     &                brgmn(5000),crgmn(5000),drgmn(5000),
     &                brga(5000),crga(5000),drga(5000)
      common/qmc/q2in(5000),geprin(5000),genrin(5000),
     &           gmprin(5000),gmnrin(5000),garin(5000)
      common/results/xgeprat,xgenrat,xgmprat,xgmnrat,xgarat
c
c------- bound/free form factor ratios
         xgeprat=seval(nq2,q2,q2in,geprin,brgep,crgep,drgep)
         xgenrat=seval(nq2,q2,q2in,genrin,brgen,crgen,drgen)
         xgmprat=seval(nq2,q2,q2in,gmprin,brgmp,crgmp,drgmp)
         xgmnrat=seval(nq2,q2,q2in,gmnrin,brgmn,crgmn,drgmn)
         xgarat=seval(nq2,q2,q2in,garin,brga,crga,drga)
c################################################################
      return
      end
c------------------------------------------------------------------------
c***************************************************************************
c ---------------------------------------------------------------------
      SUBROUTINE SPLINE(N,X,Y,B,C,D)
c ---------------------------------------------------------------------
c***************************************************************************
C CALCULATE THE COEFFICIENTS B,C,D IN A CUBIC SPLINE INTERPOLATION.
C INTERPOLATION SUBROUTINES ARE TAKEN FROM
C G.E. FORSYTHE, M.A. MALCOLM AND C.B. MOLER,
C COMPUTER METHODS FOR MATHEMATICAL COMPUTATIONS (PRENTICE-HALL, 1977).
C ---------------------------------------------------------------------
c
      IMPLICIT REAL*8(A-H,O-Z)
      DIMENSION X(5000),Y(5000),B(5000),C(5000),D(5000)
      NM1=N-1
      IF(N.LT.2) RETURN
      IF(N.LT.3) GO TO 250
      D(1)=X(2)-X(1)
      C(2)=(Y(2)-Y(1))/D(1)
      DO 210 I=2,NM1
        D(I)=X(I+1)-X(I)
        B(I)=2.0D0*(D(I-1)+D(I))
        C(I+1)=(Y(I+1)-Y(I))/D(I)
        C(I)=C(I+1)-C(I)
 210             CONTINUE
      B(1)=-D(1)
      B(N)=-D(N-1)
      C(1)=0.0D0
      C(N)=0.0D0
      IF(N.EQ.3) GO TO 215
      C(1)=C(3)/(X(4)-X(2))-C(2)/(X(3)-X(1))
      C(N)=C(N-1)/(X(N)-X(N-2))-C(N-2)/(X(N-1)-X(N-3))
      C(1)=C(1)*D(1)**2.0D0/(X(4)-X(1))
      C(N)=-C(N)*D(N-1)**2.0D0/(X(N)-X(N-3))
 215       CONTINUE
      DO 220 I=2,N
        T=D(I-1)/B(I-1)
        B(I)=B(I)-T*D(I-1)
        C(I)=C(I)-T*C(I-1)
 220             CONTINUE
      C(N)=C(N)/B(N)
      DO 230 IB=1,NM1
        I=N-IB
        C(I)=(C(I)-D(I)*C(I+1))/B(I)
 230             CONTINUE
      B(N)=(Y(N)-Y(NM1))/D(NM1)+D(NM1)*(C(NM1)+2.0D0*C(N))
      DO 240 I=1,NM1
        B(I)=(Y(I+1)-Y(I))/D(I)-D(I)*(C(I+1)+2.0D0*C(I))
        D(I)=(C(I+1)-C(I))/D(I)
        C(I)=3.0D0*C(I)
 240             CONTINUE
      C(N)=3.0D0*C(N)
      D(N)=D(N-1)
      RETURN
 250       CONTINUE
      B(1)=(Y(2)-Y(1))/(X(2)-X(1))
      C(1)=0.0D0
      D(1)=0.0D0
      B(2)=B(1)
      C(2)=0.0D0
      D(2)=0.0D0
      RETURN
      END
c
c***************************************************************************
C ---------------------------------------------------------------------
      REAL*8 FUNCTION SEVAL(N,XX,X,Y,B,C,D)
C ---------------------------------------------------------------------
c***************************************************************************
C CALCULATE THE DISTRIBUTION AT XX BY CUBIC SPLINE INTERPOLATION.
C ---------------------------------------------------------------------
      IMPLICIT REAL*8(A-H,O-Z)
      DIMENSION X(5000),Y(5000),B(5000),C(5000),D(5000)
      DATA I/1/
      IF(I.GE.N) I=1
      IF(XX.LT.X(I)) GO TO 310
      IF(XX.LE.X(I+1)) GO TO 330
 310       CONTINUE
      I=1
      J=N+1
 320       CONTINUE
      K=(I+J)/2
      IF(XX.LT.X(K)) J=K
      IF(XX.GE.X(K)) I=K
      IF(J.GT.I+1) GO TO 320
 330       CONTINUE
      DX=XX-X(I)
      SEVAL=Y(I)+DX*(B(I)+DX*(C(I)+DX*D(I)))
      RETURN
      END
c
c------------------------------------------------------------------------
