void cs_data_meson(std::string, double ,double ,double ,double);
void cs_data_meson(std::string file, double x_axis_min ,double x_axis_max ,double y_axis_min ,double y_axis_max)
{
  //  now plot some points
  Int_t marker;
  Int_t iColor;
  float txtsize=0.035;
  float symSize=1.1;
  double xlab_start=0.5;
  double ylab_start=0.95;
  double xstep = 0.305;
  double ystep = 0.04;
  double xposit=xlab_start;
  double yposit=ylab_start;
  double xlim[2]; 
  double ylim[2];
  xlim[0]=x_axis_min;
  xlim[1]=x_axis_max;
  ylim[0]=y_axis_min;
  ylim[1]=y_axis_max;
  int line_width=2;
//
  int npoint;
  float xval[30]={0.0};
  float yval[30]={0.0};
  float x_err[30]={0.0};
  float y_err[30]={0.0};
//
    std::string  data_file1 = "data/Miniboone_nu.dat" ;
    npoint = NptReadData(data_file1,xval,yval,y_err);
    for(int ip=0;ip<npoint;ip++)
    {
      cout<<" i,xval,yval,y_err="<<ip<<" "<<xval[ip]<<" "<<yval[ip]<<" "<<y_err[ip]<<endl;
    }  
    TGraphErrors *data1 = new TGraphErrors(npoint,xval,yval,x_err,y_err);
    marker=29;
    iColor=117;
    FormatErrors(data1,iColor,marker,symSize+0.5,line_width);
    data1->Draw("P");
    TLatex *label1 = new TLatex();
    label1->SetTextSize(txtsize);
    label1->SetTextColor(iColor);
//    double xtxt=start_text(xlim,xposit);
    double xtxt=3.0;
    double ytxt=start_text(ylim,yposit);
    std::string txt1 = "#nu MiniBooNE, C";
    label1->DrawLatex(xtxt,ytxt,txt1.c_str());
//    double xsym=start_text(xlim,xposit-0.02);
    double xsym=2.0;
    double ysym=start_text(ylim,yposit+0.01);
    TMarker *symb = new TMarker(xsym,ysym,marker);
    FormatMarker(symb,iColor,marker,symSize+0.5);
    symb->Draw();
    c2->Print(file.c_str());
//
    std::string  data_file2 = "data/Nomad_nu.dat" ;
    npoint = NptReadData(data_file2,xval,yval,y_err);
    if(xval[0]<x_axis_max)
    {
      TGraphErrors *data2 = new TGraphErrors(npoint,xval,yval,x_err,y_err);
      marker=20;
      iColor=51;
      FormatErrors(data2,iColor,marker,symSize,line_width);
      data2->Draw("P");
      TLatex *label1 = new TLatex();
      label1->SetTextSize(txtsize);
      label1->SetTextColor(iColor);
      double ytxt=move_text(ylim,ytxt,ystep);
      std::string txt1 = "#nu Nomad, C";
      double ysym=move_text(ylim,ysym,ystep);
      TMarker *symb = new TMarker(xsym,ysym,marker);
      FormatMarker(symb,iColor,marker,symSize);
      label1->DrawLatex(xtxt,ytxt,txt1.c_str());
      symb->Draw();
    }
    c2->Print(file.c_str());
//
    std::string  data_file3 = "data/Martini_nu.dat" ;
    npoint = NptReadData(data_file3,xval,yval,y_err);
    TGraphErrors *data3 = new TGraphErrors(npoint,xval,yval,x_err,y_err);
    marker=21;
    iColor=28;
    FormatErrors(data3,iColor,marker,symSize,line_width);
    data3->Draw("P");
    TLatex *label1 = new TLatex();
    label1->SetTextSize(txtsize);
    label1->SetTextColor(iColor);
    double ytxt=move_text(ylim,ytxt,ystep);
    std::string txt1 = "#nu Martini et al.";
    label1->DrawLatex(xtxt,ytxt,txt1.c_str());
    double ysym=move_text(ylim,ysym,ystep);
    TMarker *symb = new TMarker(xsym,ysym,marker);
    FormatMarker(symb,iColor,marker,symSize);
    symb->Draw();
    c2->Print(file.c_str());
}
void cs_data_meson(Elastic, std::string, double ,double ,double ,double);
void cs_data_meson(Elastic elas, std::string file, double x_axis_min ,double x_axis_max ,double y_axis_min ,double y_axis_max)
{
  //  now plot some points
  Int_t marker;
  Int_t iColor;
  float txtsize=0.035;
  float symSize=1.1;
  double xlab_start=0.1;
  double ylab_start=0.95;
  double xstep = 0.305;
  double ystep = 0.04;
  double xposit=xlab_start;
  double yposit=ylab_start;
  double xlim[2]; 
  double ylim[2];
  xlim[0]=x_axis_min;
  xlim[1]=x_axis_max;
  ylim[0]=y_axis_min;
  ylim[1]=y_axis_max;
  int line_width=2;
//
  int npoint;
  float xval[30]={0.0};
  float yval[30]={0.0};
  float x_err[30]={0.0};
  float y_err[30]={0.0};
  float yval_norm[30]={0.0};
  float y_err_norm[30]={0.0};
  float cs_enu[30]={0.0};
//
    std::string  data_file1 = "data/Miniboone_nu.dat" ;
    npoint = NptReadData(data_file1,xval,yval,y_err);
    for(int ip=0;ip<npoint;ip++)
    {
      cs_enu[ip]=elas.sigma(xval[ip]);
      yval_norm[ip]=yval[ip]/cs_enu[ip];
      y_err_norm[ip]=y_err[ip]/cs_enu[ip];
      cout<<" i,xval,yval,y_err,ynorm,yerrnorm,cs_enu="<<ip<<" "<<xval[ip]<<" "<<yval[ip]<<" "<<y_err[ip]
          <<" "<<yval_norm[ip]<<" "<<y_err_norm[ip]<<" "<<cs_enu[ip]<<endl;
    }  
    TGraphErrors *data1 = new TGraphErrors(npoint,xval,yval_norm,x_err,y_err_norm);
    marker=29;
    iColor=117;
    FormatErrors(data1,iColor,marker,symSize+0.5,line_width);
    data1->Draw("P");
    TLatex *label1 = new TLatex();
    label1->SetTextSize(txtsize);
    label1->SetTextColor(iColor);
    double xtxt=start_text(xlim,xposit);
    double ytxt=start_text(ylim,yposit);
    std::string txt1 = "#nu MiniBooNE, C, normalized to CS with M_{A}=1.014";
    label1->DrawLatex(xtxt,ytxt,txt1.c_str());
    double xsym=start_text(xlim,xposit-0.02);
    double ysym=start_text(ylim,yposit+0.01);
    TMarker *symb = new TMarker(xsym,ysym,marker);
    FormatMarker(symb,iColor,marker,symSize+0.5);
    symb->Draw();
    c2->Print(file.c_str());
//
    std::string  data_file2 = "data/Nomad_nu.dat" ;
    cout<<" data_file "<<data_file2<<endl;
    npoint = NptReadData(data_file2,xval,yval,y_err);
    npoint=2;
    for(int ip=0;ip<npoint;ip++)
    {
      cs_enu[ip]=elas.sigma(xval[ip]);
      yval_norm[ip]=yval[ip]/cs_enu[ip];
      y_err_norm[ip]=y_err[ip]/cs_enu[ip];
      cout<<" i,xval,yval,y_err,ynorm,yerrnorm,cs_enu="<<ip<<" "<<xval[ip]<<" "<<yval[ip]<<" "<<y_err[ip]
          <<" "<<yval_norm[ip]<<" "<<y_err_norm[ip]<<" "<<cs_enu[ip]<<endl;
    }  
    if(xval[0]<x_axis_max)
    {
      TGraphErrors *data2 = new TGraphErrors(npoint,xval,yval_norm,x_err,y_err_norm);
      marker=20;
      iColor=51;
      FormatErrors(data2,iColor,marker,symSize,line_width);
      data2->Draw("P");
      TLatex *label1 = new TLatex();
      label1->SetTextSize(txtsize);
      label1->SetTextColor(iColor);
      double ytxt=move_text(ylim,ytxt,ystep);
      std::string txt1 = "#nu Nomad, C, normalized to CS with M_{A}=1.014";
      double ysym=move_text(ylim,ysym,ystep);
      TMarker *symb = new TMarker(xsym,ysym,marker);
      FormatMarker(symb,iColor,marker,symSize);
      label1->DrawLatex(xtxt,ytxt,txt1.c_str());
      symb->Draw();
    }
    c2->Print(file.c_str());
//
    std::string  data_file3 = "data/Martini_nu.dat" ;
    cout<<" data_file "<<data_file3<<endl;
    npoint = NptReadData(data_file3,xval,yval,y_err);
    for(int ip=0;ip<npoint;ip++)
    {
      cs_enu[ip]=elas.sigma(xval[ip]);
      yval_norm[ip]=yval[ip]/cs_enu[ip];
      y_err_norm[ip]=y_err[ip]/cs_enu[ip];
      cout<<" i,xval,yval,y_err,ynorm,yerrnorm,cs_enu="<<ip<<" "<<xval[ip]<<" "<<yval[ip]<<" "<<y_err[ip]
          <<" "<<yval_norm[ip]<<" "<<y_err_norm[ip]<<" "<<cs_enu[ip]<<endl;
    }  
    TGraphErrors *data3 = new TGraphErrors(npoint,xval,yval_norm,x_err,y_err_norm);
    marker=21;
    iColor=28;
    FormatErrors(data3,iColor,marker,symSize,line_width);
    data3->Draw("P");
    TLatex *label1 = new TLatex();
    label1->SetTextSize(txtsize);
    label1->SetTextColor(iColor);
    double ytxt=move_text(ylim,ytxt,ystep);
    std::string txt1 = "#nu Martini et al., normalized to CS with M_{A}=1.014";
    label1->DrawLatex(xtxt,ytxt,txt1.c_str());
    double ysym=move_text(ylim,ysym,ystep);
    TMarker *symb = new TMarker(xsym,ysym,marker);
    FormatMarker(symb,iColor,marker,symSize);
    symb->Draw();
    c2->Print(file.c_str());
//
}
