//DataQE.h
//
#ifndef DATAQE_H
#define DATAQE_H
const int CHAR_SIZ_MAX=100; // max lenght of char
const int MAX_NUM_EXPER=50; //
const int MAX_DATA_SIZE=50;
const double sizeSymChange[MAX_NUM_EXPER]=
{0.2,0,0.2,0.2,0,       0,0.2,0.2,0.6,0.4,   0,0,0,0,0 
,0.2,0,  0,  0,0,       0,  0,  0,  0,  0,   0,0,0,0,0 };
const int iColorPlt[MAX_NUM_EXPER]=
{4,102,6,103,1,51 ,7,31,3,13 ,101,105,28,38,5
,4,102,6,103,1,51 ,7 ,31,3,13 ,101,105,28,38,5};
using namespace std;
class DataQE 
{
  public:
   DataQE( char* ="gep", char* = "file_qe", char* = "file_ep"); 
   void ReadFile();//Reads data file
   void WriteFile(); //Writes out data file
   void ReadExperPlotFile(); // Reads file for which exp to plot
   void WriteExperPlotFile();// Writes out Exp to plot
   int iExperNum(char*);// return Exp number from plot file
   int return_numExp(); //returns number of experiments in datafile
   int return_numExpPlot(); //returns number of experiments to plot
   char* return_formFactor(); // Form factor being plotted
   char* return_experPlot(int); // Return Exp to be plotted
   char* return_exper(int); // Returns experiment
   double* return_xdat(int);
   double* return_xdat2(int);
   double* return_ydat(int);
   double* return_yerr(int);
   int return_numData(int); // returns the number of data points for an Exp
  private:
   char fileQE[CHAR_SIZ_MAX];
   char fileExpPlotQE[CHAR_SIZ_MAX];
   int numExp; // number of experiments in file
   int numExpPlot; // number of experiments to plot
   char formFactor[CHAR_SIZ_MAX];
   char experPlot[MAX_NUM_EXPER][CHAR_SIZ_MAX]; // Name of Exp to be plotted
   char exper[MAX_NUM_EXPER][CHAR_SIZ_MAX]; // Exp Name
   int numData[MAX_NUM_EXPER]; // number of data points for an Exp
   double xdat[MAX_NUM_EXPER][MAX_DATA_SIZE]; 
   double ydat[MAX_NUM_EXPER][MAX_DATA_SIZE]; 
   double yerr[MAX_NUM_EXPER][MAX_DATA_SIZE]; 
};
#endif
