#include <cstdlib>
#include <iostream>
#include <fstream>
#include "DataQE.h"
#include <cstring>
DataQE::DataQE(char* ff,char* data_file, char* file_exp_plot)
{
  strcpy(formFactor,ff); //form factor for plot
  strcpy(fileQE,data_file); // file for data
  strcpy(fileExpPlotQE,file_exp_plot); //plot this data
  numExp=0;
  numExpPlot=0;
}
void DataQE::ReadFile()
{
  char input_word[256];
  ifstream in_data;
  in_data.open(fileQE);
  in_data.getline(input_word,256,'!');
  while(!in_data.eof())
  {
    if(strcmp(input_word,"DATA")==0)
    {
      in_data.getline(input_word,256,'!');
      char formF[100];
// need to be sure all are the same kind of form factors
      strcpy(formF,input_word); //form factor for plot
      in_data.getline(input_word,256);  
      in_data.ignore();
      if(numExp<MAX_NUM_EXPER&&strcmp(formF,formFactor)==0)
      {
        strcpy(exper[numExp],input_word);
      }
      int num_data;
      in_data>>num_data;
      if(numExp<MAX_NUM_EXPER&&strcmp(formF,formFactor)==0)
      {
        numData[numExp]=num_data;
      }
      for(int iData=0;iData<num_data;iData++)
      {
        double xd,yd,yer;
        in_data>>xd>>yd>>yer;
        if(numExp<MAX_NUM_EXPER&&strcmp(formF,formFactor)==0)
        {
          xdat[numExp][iData]=xd;
          ydat[numExp][iData]=yd;
          yerr[numExp][iData]=yer;
        }
      }
      if(numExp<MAX_NUM_EXPER&&strcmp(formF,formFactor)==0)
      {
        numExp++;
        if(numExp>MAX_NUM_EXPER)
        { 
           cout<<" Too Many Experiments = "<<numExp<<endl;
           numExp=MAX_NUM_EXPER;
           exit(1);
        }
      }
    }
    in_data.ignore();
    in_data.getline(input_word,256,'!');
    if(!in_data.eof()&&strcmp(input_word,"DATA")!=0)
    {
      cout<<" input_word seems wrong, input_word = "<<input_word<<endl;
    } 
  }
}  
void DataQE::WriteFile()
{
  cout<<" Number of Experiments="<<numExp<<endl;
  for(int iExp=0;iExp<numExp;iExp++)
  {
    char* exp = exper[iExp];
    cout<<" Exp # ="<<iExp<<" exp = "<<exp<<endl;
    for(int iData=0;iData<numData[iExp];iData++)
    {
      cout<<" x y yer = "<<xdat[iExp][iData]
          <<" "<<ydat[iExp][iData] 
          <<" "<<yerr[iExp][iData]<<endl;
    }
  }
}
void DataQE::ReadExperPlotFile()
{
  char input_word[256];
  ifstream in_data;
  in_data.open(fileExpPlotQE);
  in_data.getline(input_word,256);
  strcpy(experPlot[numExpPlot],input_word);
  while(!in_data.eof())
  {
    if(numExpPlot<MAX_NUM_EXPER)
    {
      strcpy(experPlot[numExpPlot],input_word);
    }
    in_data.getline(input_word,256);
    numExpPlot++;
  }
  if(numExpPlot>MAX_NUM_EXPER)
  {
    cout<<" Too Many Experiments to Plot = "<<numExp<<endl;
    numExpPlot=MAX_NUM_EXPER;
    exit(1);
  }
}  
void DataQE::WriteExperPlotFile()
{
  for(int iExp=0;iExp<numExpPlot;iExp++)
  {
    cout<<experPlot[iExp]<<endl;
  }
}  
int DataQE::iExperNum(char* exp)
// Returns the number of the experiment
{
  for(int iExp=0;iExp<numExp;iExp++)
  {
    if(strcmp(exper[iExp],exp)==0)
    {
      return iExp;
    }
  }
  return -1;
}  
int DataQE::return_numExp() {return numExp;}
int DataQE::return_numExpPlot() {return numExpPlot;}
char* DataQE::return_formFactor() {return formFactor;}
double* DataQE::return_xdat(int iExp) {return xdat[iExp];}
double* DataQE::return_ydat(int iExp) {return ydat[iExp];}
double* DataQE::return_yerr(int iExp) {return yerr[iExp];}
char* DataQE::return_experPlot(int iExp) {return experPlot[iExp];} 
char* DataQE::return_exper(int iExp) {return exper[iExp];}
int DataQE::return_numData(int iExp) {return numData[iExp];}
