#include <math.h>
void emu_vs_theta();
void emu_vs_theta(double q2)
{
  char title[120];
  char file_name[30];
  sprintf(title,"Muon Energy vs Theta, Q2=%d GeV",-q2);
  sprintf(file_name,"emu_theta_q2_%d_GeV.eps",-q2);
  Experiment Exp("Minerva_nu","nu","one","dipole","zero","dipole","dipole");
  Exp.InitExperiment();
  TH2F *qe2  = new TH2F("qe2",title,400,0,10.0,90,0,180.0);
  int nstep=800;
  double e_max=Exp.return_enuMaxFlux();
//  double e_min=-0.5*q2/m_P;
  double e_min=(-q2+sqrt(q2*q2-4*m_P*q2))/(4*m_P);
  double step=(e_max-e_min)/nstep;
  double eve_tot=0;
  for(int istep=0;istep<nstep;istep++)
  {
    double xstep=istep;
    double enu=e_min+(0.5+xstep)*step;
    double sig=Exp.dsigma_dq2(q2, enu);
    double flux=Exp.FluxSpline(enu);
    eve_tot+=flux*sig;
  }
  double eve_sum=0;
  for(int istep=0;istep<nstep;istep++)
  {
    double xstep=istep;
    double enu=e_min+xstep*step+0.005;
    double emu=enu+q2/(2.0*m_P);
    double epro=-q2/(2.0*m_P);
    double sin_theta_2= sqrt(-q2/(4.0*enu*emu));
    double cos_theta=1.0-2.0*sin_theta_2*sin_theta_2;
    double pt_mu=cos_theta*emu;
    double ppro=sqrt(epro*epro-m_P*m_P);
    double cos_theta_pro=cos_theta*pt_mu/ppro;
    if(sin_theta_2>1.0)
    {
     cout<<enu<<" "<<emu<<" "<<sin_theta_2<<" "<<flux<<endl;
    }
    double ang_mu=360.0*asin(sin_theta_2)/3.14156;
    double ang_pro=180.0*acos(cos_theta)/3.14156;
    double sig=Exp.dsigma_dq2(q2, enu);
    double flux=Exp.FluxSpline(enu);
    eve_sum+=sig*flux;
//   cout<<enu<<" "<<emu<<" "<<ang_mu<<" "<<flux<<endl;
    qe2->Fill(emu,ang_mu,eve_sum/eve_tot);
    qe2->Fill(epro,ang_pro,eve_sum/eve_tot);
  }
  gStyle->SetPalette(1,0);
  qe2->SetOption("COLZ");
  qe2->SetMinimum(0);
  qe2->SetMaximum(0.5);
  qe2->SetStats(kFALSE);
  qe2->GetXaxis()->SetTitle("Muon Energy");
  qe2->GetYaxis()->SetTitle("Theta");
  qe2->Draw();
  c1->Print(file_name);
}
