#include <math.h>
void emu_vs_theta();
void emu_vs_theta(double q2)
{
  char title[120];
  char file_name[30];
  sprintf(title,"Muon Energy vs Theta, Q2=%d",-q2);
  sprintf(file_name,"emu_theta_q2_%d.eps",-q2);
  Experiment Exp("Minerva_nu","nu","one","dipole","zero","dipole","dipole");
  Exp.InitExperiment();
  TH2F *qe2  = new TH2F("qe2",title,100,0,20.0,100,0,90.0);
  int nstep=100;
  double e_max=Exp.return_enuMaxFlux();
  double e_min=-0.5*q2/m_P;
  double step=(e_max-e_min)/nstep;
  double flux_tot=0;
  for(int istep=0;istep<nstep;istep++)
  {
    double xstep=istep;
    double enu=e_min+(0.5+xstep)*step;
    double flux=Exp.FluxSpline(enu);
    flux_tot+=flux;
  }
  double flux_sum=0;
  for(int istep=0;istep<nstep;istep++)
  {
    double xstep=istep;
    double enu=e_min+(0.5+xstep)*step;
    double emu=enu+0.5*q2/m_P;
    double cos_theta= 1+q2/(2.0*enu*emu);
    if(cos_theta<0)
    {
     cout<<enu<<" "<<emu<<" "<<cos_theta<<" "<<flux<<endl;
      cos_theta=-cos_theta;
    }
    if(cos_theta>1)
    {
     cout<<enu<<" "<<emu<<" "<<cos_theta<<" "<<flux<<endl;
      cos_theta=1.0;
    }
    double arccos=180.0*acos(cos_theta)/3.14156;
    double flux=Exp.FluxSpline(enu)/flux_tot;
    flux_sum+=flux;
//   double sig=Exp.dsigma_dq2(q2, enu);
//   cout<<enu<<" "<<emu<<" "<<arccos<<" "<<flux<<endl;
    qe2->Fill(emu,arccos,flux_sum);
  }
  gStyle->SetPalette(1,0);
  qe2->SetOption("COLZ");
  qe2->SetMinimum(0);
  qe2->SetMaximum(0.5);
  qe2->SetStats(kFALSE);
  qe2->GetXaxis()->SetTitle("Muon Energy");
  qe2->GetYaxis()->SetTitle("Theta");
  qe2->Draw();
  c1->Print(file_name);
}
