#include "Elastic.h"
#include "Experiment.h"
#include <iostream>
#include <fstream>
#include <stdio.h>
#include <stdlib.h>
#include<string.h>
#include<string>
#include<math.h>
const int NPARA = 3;
const int NPAR_FA0 = 2;
void FA_inter(Experiment&);
void syminv(double a[][NPARA] ,int  ,int& );
void NumberOfEvents(Experiment&);
void Write_td_file_F_A_calc(Experiment&, int);
int main()
{
  double fact_time_fa=1.00;
  double accu=0.02;
//  Experiment ExpB("Baker_81","nu","SinghD","Kelly","AB25","Kelly","AB25",1.04653,-1.267,0.105658,1.,.842615,accu);
  Experiment ExpB("Miller_82","nu","SinghD","Kelly","AB25","Kelly","AB25",1.08107,-1.267,0.105658,1.,.842615,accu);
//  Experiment ExpB("Kitagaki_83","nu","SinghD","Kelly","AB25","Kelly","AB25",1.17089,-1.267,0.105658,1.,.842615,accu);
  ExpB.set_fact_F_A(fact_time_fa);
  ExpB.InitExperiment();
  ExpB.Solve_F_A_by_integ_bin();
  NumberOfEvents(ExpB);
  ExpB.WriteExperiment();
//  Write_td_file_F_A_calc(ExpB,100);
  FA_inter(ExpB);
}
  void FA_inter(Experiment& Exp,double fa_norm,double fa_nor_err)
{
  double q2varFA[NPARA];
  double q2varQ2var[NPARA][NPARA];
  double xvarLasGain[NPARA];
  double xvarXvar[NPARA][NPARA];
  double para[NPARA];
  int num_nor=5;
  double step_nor=0.04;
  double fa_nom_nor=Exp.ret_fact_F_A();
  int n_data_pt=Exp.return_n_data_pt();
  Exp.WriteExperiment();
  cout<<"Exp="<<Exp.return_exper()
  <<" nucCorrecton="<<Exp.ret_nucCorrType()<<endl;
  for(int iPara=0;iPara<NPARA;iPara++)
  {
    xvarLasGain[iPara]=0;
    for(int jPara=0;jPara<NPARA;jPara++)
    {
      xvarXvar[iPara][jPara]=0;
    }
  }
  for(int ielas=0;ielas<num_nor;ielas++)
  {
    double fa_nor=fa_nom_nor+step_nor*(ielas-(num_nor-1)/2);
    Exp.set_fact_F_A(fa_nor);
    Exp.InitExperiment();
    Exp.Solve_F_A_by_integ_bin();
    double* Q2=Exp.return_Q2_bin_cent_ave_F_A_2_wt_coefFA2();
    double* F_A_calc=Exp.return_F_A_calc();
    double* F_A_error=Exp.return_F_A_error();
    double fa_val_nor=Exp.ret_fact_F_A();
    cout<<" normalization = "<<fa_val_nor<<endl;
    for(int iPar_FA0=0;iPar_FA0<NPAR_FA0;iPar_FA0++)
    {
      q2varFA[iPar_FA0]=0.0;
      for(int jPar_FA0=0;jPar_FA0<NPAR_FA0;jPar_FA0++)
      {
        q2varQ2var[iPar_FA0][jPar_FA0]=0.0;
      }
    }
    for (int i_data_pt=IBIN_CHI_START; Q2[i_data_pt]>0.1&&Q2[i_data_pt]<0.65&&i_data_pt<n_data_pt;i_data_pt++)
    {
      double y0=Exp.F_A_dipole(-Q2[i_data_pt]);
      double FA=F_A_calc[i_data_pt];
      double FA_err=F_A_error[i_data_pt]/y0;
//      FA_err=1.0;
      cout<<" i_data_pt = "<< i_data_pt<<" Q2 = "<<Q2[i_data_pt]<<
           " FA/y0 = "<<FA/y0<<"  FA_err = "<<FA_err<<endl;
      for(int iPara=0;iPara<NPAR_FA0;iPara++)
      {
        q2varFA[iPara]+=pow(Q2[i_data_pt],iPara)*FA/(y0*FA_err*FA_err);
//      cout<<" q2varFA"<<"["<<iPara<<"] = "<<q2varFA[iPara]<<endl;
        for(int jPara=0;jPara<NPAR_FA0;jPara++)
        {
          q2varQ2var[iPara][jPara]+=pow(Q2[i_data_pt],iPara+jPara)/(FA_err*FA_err);
//        cout<<" q2varQ2var"<<"["<<iPara<<"]["<<jPara<<"] = " <<q2varQ2var[iPara][jPara]<<endl;
        }
      }
    }
    double det=q2varQ2var[0][0]*q2varQ2var[1][1]-q2varQ2var[1][0]*q2varQ2var[0][1];
    double FA_Q2_0=(q2varQ2var[1][1]*q2varFA[0]-q2varQ2var[1][0]*q2varFA[1])/det;
    double err_FA_Q2_0=q2varQ2var[1][1]/det;
//   cout<<"  det = "<<det<<" FA_Q2_0 = "<<FA_Q2_0<<" err_FA_Q2_0 = "<<sqrt(err_FA_Q2_0)<<endl;
    for(int iPara=0;iPara<NPARA;iPara++)
    {
      xvarLasGain[iPara]+=pow(fa_nor,iPara)*FA_Q2_0/(err_FA_Q2_0*err_FA_Q2_0);
      for(int jPara=0;jPara<NPARA;jPara++)
      {
         xvarXvar[iPara][jPara]+=pow(fa_nor,iPara+jPara)/(err_FA_Q2_0*err_FA_Q2_0);
      }
    }
  }
  int ier;
  syminv(xvarXvar,NPARA,ier);
  cout<<" para = ";
  for(int iPara=0;iPara<NPARA;iPara++)
  {
    double parameter=0;
    for(int jPara=0;jPara<NPARA;jPara++)
    {
      parameter+=xvarLasGain[jPara]*xvarXvar[iPara][jPara];
    }
    para[iPara]=parameter;
    cout<<para[iPara]<<" ";
  }
  cout<<endl;
  double fa_normal=(-para[1]+sqrt(para[1]*para[1]-4.0*para[2]*(para[0]-1.0)))/(2.0*para[2]);
  double value= para[0]+para[1]*fa_normal+para[2]*fa_normal*fa_normal;
  cout<<" fa_normal ="<<fa_normal<<" value="<<value<<endl;
// need to get error
  Exp.set_fact_F_A(fa_normal);
  Exp.InitExperiment();
  Exp.Solve_F_A_by_integ_bin();
  double* Q2=Exp.return_Q2_bin_cent_ave_F_A_2_wt_coefFA2();
  double* F_A_calc=Exp.return_F_A_calc();
  double* F_A_error=Exp.return_F_A_error();
  double fa_val_nor=Exp.ret_fact_F_A();
  cout<<" final normalization = "<<fa_val_nor<<endl;
  for(int iPar_FA0=0;iPar_FA0<NPAR_FA0;iPar_FA0++)
  {
    q2varFA[iPar_FA0]=0.0;
    for(int jPar_FA0=0;jPar_FA0<NPAR_FA0;jPar_FA0++)
    {
      q2varQ2var[iPar_FA0][jPar_FA0]=0.0;
    }
  }
  for (int i_data_pt=IBIN_CHI_START; Q2[i_data_pt]>0.1&&Q2[i_data_pt]<0.65&&i_data_pt<n_data_pt;i_data_pt++)
  {
    double y0=Exp.F_A_dipole(-Q2[i_data_pt]);
    double FA=F_A_calc[i_data_pt];
    double FA_err=F_A_error[i_data_pt]/y0;
//      FA_err=1.0;
    cout<<" i_data_pt = "<< i_data_pt<<" Q2 = "<<Q2[i_data_pt]<<
         " FA/y0 = "<<FA/y0<<"  FA_err = "<<FA_err<<endl;
    for(int iPara=0;iPara<NPAR_FA0;iPara++)
    {
      q2varFA[iPara]+=pow(Q2[i_data_pt],iPara)*FA/(y0*FA_err*FA_err);
//      cout<<" q2varFA"<<"["<<iPara<<"] = "<<q2varFA[iPara]<<endl;
      for(int jPara=0;jPara<NPAR_FA0;jPara++)
      {
        q2varQ2var[iPara][jPara]+=pow(Q2[i_data_pt],iPara+jPara)/(FA_err*FA_err);
//        cout<<" q2varQ2var"<<"["<<iPara<<"]["<<jPara<<"] = " <<q2varQ2var[iPara][jPara]<<endl;
      }
    }
  }
  double det=q2varQ2var[0][0]*q2varQ2var[1][1]-q2varQ2var[1][0]*q2varQ2var[0][1];
  double FA_Q2_0=(q2varQ2var[1][1]*q2varFA[0]-q2varQ2var[1][0]*q2varFA[1])/det;
  double err_FA_Q2_0=q2varQ2var[1][1]/det;
   cout<<" final det = "<<det<<" FA_Q2_0 = "<<FA_Q2_0<<" err_FA_Q2_0 = "<<sqrt(err_FA_Q2_0)<<endl;
  }
}
