
//______________________________________________________________________________
//*-*-*-*-*-*-*-*-*-*-*-*The Minuit standard test program-*-*-*-*-*-*-*-*-*
//*-*                    ========================                         *
//*-*                                                                     *
//*-*    This program is the translation to C++ of the minMa program    *
//*-*    distributed with the Minuit/Fortran source file.                 *
//*-*         original author Fred James                                  *
//*-*                                                                     *
//*-*       Fit randomly-generated leptonic K0 decays to the              *
//*-*       time distribution expected for interfering K1 and K2,         *
//*-*       with free parameters Re(X), Im(X), DeltaM, and GammaS.        *
//*-*                                                                     *
//*-*   This program can be run in batch mode with the makefile           *
//*-*   or executed interactively with the command:                       *
//*-*         Root > .x minMa.cxx                                       *
//*-*                                                                     *
//*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*


void fcnk0(int &npar, double *gin, double &f, double *para, int iflag);
int minMa();

#ifndef __CINT__
#include "TVirtualFitter.h"
#include "TMath.h"
#include "TStopwatch.h"

#include<iostream>
#include<fstream>
#include <stdlib.h>
#include <stdio.h>

//______________________________________________________________________________
//int main()
//{
//   return minMa();
//}
#endif

int minMa()
{
   TStopwatch timer;

   // Initialize TMinuit via generic fitter interface with a mabparum of 2 params
   TVirtualFitter *minuit = TVirtualFitter::Fitter(0, 2);
   printf("Starting timern");
   timer.Start();
   Experiment ExpA(!1,0.105658,1.,!4,0.05);
   Double_t  double mA=ExpA.ret_m_A();
   minuit->SetFCN(fcnk0);
   minuit->SetParameter(0, "m_A", mA, 0.002, mA-0.4,mA+0.4 );
   Double_t  double xnor=!3;
   minuit->SetParameter(1, "Nor", xnor,0.005, xnor-0.2, xnor+0.2);
//*-*-       Request FCN to read in (or generate random) data (IFLAG=1)
   Double_t arglist[100];
   arglist[0] = 1;
   minuit->ExecuteCommand("CALL FCN", arglist, 1);
   minuit->ExecuteCommand("MIGRAD", arglist, 0);
   minuit->ExecuteCommand("MINOS", arglist, 0);
   minuit->ExecuteCommand("CALL FCN", arglist, 1);

   printf("Time at the end of job = %f secondsn",timer.CpuTime());
   return 0;
}

//______________________________________________________________________________
void fcnk0(Int_t &, Double_t *, Double_t &f, Double_t *para, Int_t iflag)
{
  char* chimax="chi"; // "chi"or"maxl";
  char* data_thy="data";
  static Experiment Exp(!1,0.105658,1.,!4,0.005);
//  static Experiment Exp("Allasia_90","nu","SinghD","dipole","zero","dipole","dipole",1.1136,-1.2546,0.105658,1.,.84,0.005);
// static Experiment Exp("Bonetti_77_nu","nu","SinghD","dipole","zero","dipole","dipole",0.96,-1.23,0.105658,1.,.84,0.005);
// static Experiment Exp("Bonetti_77_nub","nub","SinghD","dipole","zero","dipole","dipole",0.94,-1.23,0.105658,1.,.84,0.005);
// static Experiment Exp("Armenise_79","nub","SinghD","dipole","zero","dipole","dipole",0.91,-1.26,0.105658,1.,.84,0.005);
// static Experiment Exp("Astratyan_84","nub","SinghD","Olsson","zero","Olsson","Olsson",0.99,-1.26,0.105658,1.,.84,0.005);
// static Experiment Exp("Brunner_90_nub","nub","SinghD","Olsson","zero","Olsson","Olsson",0.79,-1.254,0.105658,1.,.84,0.005);
// static Experiment Exp("Brunner_90_nu","nu","SinghD","Olsson","zero","Olsson","Olsson",1.05,-1.254,0.105658,1.,.84,0.005);
// static Experiment Exp("Pohl_79","nu","SinghD","dipole","zero","dipole","dipole",0.99,-1.24,0.105658,1.,.84,0.005);
  if (iflag == 1) 
  {
    cout<<"initializing stuff"<<endl;     
    cout<<" chimax="<<chimax<<", data_thy="<<data_thy<<endl;
    Exp.InitExperiment();
  }
  Exp.set_m_A(para[0]);
  double f=Exp.ChiMaxl(para[1],chimax,data_thy);
//  cout<<"chisq, para = "<<f<<" "<<*para<<" "<<*(para+1)<<" "<<endl;
  if (iflag == 3) 
  {
    Exp.WriteExperiment();
    Double_t  double Ma0=!2;
    cout<<"Fit, exp = "<<Exp.return_exper()<<", ma =  "<<*para<<", nor = "<<*(para+1)
    << ", Ma0 = "<<Ma0<<", Ma - Ma0 = " << *para - Ma0<<endl;
  }
}

