
//______________________________________________________________________________
//*-*-*-*-*-*-*-*-*-*-*-*The Minuit standard test program-*-*-*-*-*-*-*-*-*
//*-*                    ========================                         *
//*-*                                                                     *
//*-*    This program is the translation to C++ of the minelas program    *
//*-*    distributed with the Minuit/Fortran source file.                 *
//*-*         original author Fred James                                  *
//*-*                                                                     *
//*-*       Fit randomly-generated leptonic K0 decays to the              *
//*-*       time distribution expected for interfering K1 and K2,         *
//*-*       with free parameters Re(X), Im(X), DeltaM, and GammaS.        *
//*-*                                                                     *
//*-*   This program can be run in batch mode with the makefile           *
//*-*   or executed interactively with the command:                       *
//*-*         Root > .x minelas.cxx                                       *
//*-*                                                                     *
//*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*


void fcnk0(int &npar, double *gin, double &f, double *para, int iflag);
int minelas();

#ifndef __CINT__
#include "TVirtualFitter.h"
#include "TMath.h"
#include "TStopwatch.h"

#include <stdlib.h>
#include <stdio.h>

//______________________________________________________________________________
int main()
{
   return minelas();
}
#endif

int minelas()
{
   TStopwatch timer;

   // Initialize TMinuit via generic fitter interface with a mabparum of 2 params
   TVirtualFitter *minuit = TVirtualFitter::Fitter(0, 2);
   printf("Starting timern");
   timer.Start();
   minuit->SetFCN(fcnk0);

   minuit->SetParameter(0, "a",    0,     0.1, 0,0);
   minuit->SetParameter(1, "b",   1.0,     0.1, 0,0);

//*-*-       Request FCN to read in (or generate random) data (IFLAG=1)
   Double_t arglist[100];
   arglist[0] = 1;
   minuit->ExecuteCommand("CALL FCN", arglist, 1);
   minuit->FixParameter(2);
   arglist[0] = 0;
   minuit->ExecuteCommand("SET PRINT", arglist, 1);
   minuit->ExecuteCommand("MIGRAD", arglist, 0);
   minuit->ExecuteCommand("MINOS", arglist, 0);
   minuit->ReleaseParameter(2);
   minuit->ExecuteCommand("MIGRAD", arglist, 0);
   minuit->ExecuteCommand("MINOS", arglist, 0);
   arglist[0] = 3;
   minuit->ExecuteCommand("CALL FCN", arglist, 1);

   printf("Time at the end of job = %f secondsn",timer.CpuTime());
   return 0;
}

//______________________________________________________________________________
void fcnk0(Int_t &, Double_t *, Double_t &f, Double_t *para, Int_t iflag)
{
  const Int_t nevtot = 7;
  static Double_t xdata[nevtot] = {0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0};
  static Double_t ydata[nevtot] = {0.0, 1.2, 1.8, 3.1, 3.9, 5.0, 5.8};
  static Double_t error=0.2;
  static  Elas quasi(1.0,2.0);

  //  generate random data
  if (iflag == 1) 
  {
    cout<<"initializing stuff"<<endl;     
  }
//                      calculate chisquared
  Double_t chisq=0;
  for(int iev=0;iev<nevtot;iev++)  
  {
    quasi.Set_a(para[0]);
    quasi.Set_b(para[1]);
    Double_t ycalc= quasi.func(xdata[iev]);
//    Double_t ycalc= para[0]+para[1]*xdata[iev];
    chisq+=(ydata[iev]- ycalc)*(ydata[iev]- ycalc)/error;
  }
//  cout<<"chisq, a, b = "<<chisq<<" "<<*para<<" "<<*(para+1)<<" "<<endl;
  f = chisq;
}

