#! /bin/csh -f
#
cat > CreatFun.C<<EOF
// Note, These are for plots so the x axis is always > 0, ie Q**2.
Double_t f_1_v_rat(Double_t , Double_t );
Double_t f_1_v_rat(Double_t *x, Double_t *par)
{
  return elas_Tsush.F_1_V(-x[0])/elas.F_1_V(-x[0]);
}
Double_t cf_2_v_rat(Double_t , Double_t );
Double_t cf_2_v_rat(Double_t *x, Double_t *par)
{
  return elas_Tsush.cF_2_V(-x[0])/elas.cF_2_V(-x[0]);
}
Double_t g_a_rat(Double_t , Double_t );
Double_t g_a_rat(Double_t *x, Double_t *par)
{
  return elas_Tsush.F_A(-x[0])/elas.F_A(-x[0]);
}
Double_t Nuke_nu(Double_t , Double_t );
Double_t Nuke_nu(Double_t *x, Double_t *par)
{
  return elas.Nuke(-1.0,x[0]);
        
}
Double_t Nuke_nub(Double_t , Double_t );
Double_t Nuke_nub(Double_t *x, Double_t *par)
{
  return elas_nub.Nuke(-1.0,x[0]);
        
}
EOF
cat > plt_fun2.C<<EOF
#include <ctype.h>
#include <string.h>
#include "Elastic.h"
#include "TGraph.h"
#include "TF1.h"
void plt_fun(TF1* , std::string , std::string, std::string 
 ,double ,double ,double ,double ,int ,int ,int ); 
void plt_fun(TF1* fun1 ,std::string title ,std::string txttit, std::string file
 ,double x_axis_min ,double x_axis_max ,double y_axis_min ,double y_axis_max
 ,int iColor,int iLineSty,int iEnter)
{
// nu_num states whether it is nu nub or both
//create titles
  double xtitle= 0.02;
  double ytitle=1.02;
//  double ystep = 0.10; // bound form factors
  double ystep = 0.08;
  float txtsize=0.04;
  Margin( 0.10, 0.04, 0.13, 0.12);
  if(iEnter==0)
  {
    TCanvas *c2 = new TCanvas("c2","",800,800);
    gPad->SetGrid();
    c2->Range(0,0,20,20);
    c2->SetFillColor(10);
  }
  double xlim[2];
  double ylim[2];
  xlim[0]=x_axis_min;
  xlim[1]=x_axis_max;
  ylim[0]=y_axis_min;
  ylim[1]=y_axis_max;
  double xposit=0.1; //bounded ff
  double yposit=1.01; //bounded ff
//  double xposit=0.5; // nuclear ratio 
//  double yposit=0.20; // nuclear ratio 
  double ylab_start=0.141;
  if(iEnter==0)
  {
//    TGraph  *gr2 = new TGraph(2,xlim,ylim);
    TH2F *gr2  = new TH2F("gr2", "gr2",300,xlim[0],xlim[1],300 ,ylim[0],ylim[1]);
    gr2->SetTitle("");
    FormatGraph(gr2,txtsize,txtsize+0.005,1.2,1.3);
    gr2->GetXaxis()->SetTitle("Q^{2} (GeV^{2})");
    gr2->GetYaxis()->SetTitle("F^{*}/F^{free}");
//    gr2->GetYaxis()->SetTitle("Nuclear Correction");
    gr2->Draw("AP");
    TLatex *titl = new TLatex();
    titl->SetTextSize(txtsize+0.005);
    titl->SetTextColor(1);
    double xtit=start_text(xlim,xtitle);
    double ytit=start_text(ylim,ytitle);
    titl->DrawLatex(xtit,ytit,title.c_str());
  }
// now start plotting
  double xtxt=start_text(xlim,xposit);
  double xline1=start_text(xlim,xposit-0.07);
  double xline2=start_text(xlim,xposit-0.01);
  static double ytxt;
  static double yline1;
  if(iEnter==0)
  {
    ytxt=start_text(ylim,yposit);
    yline1=start_text(ylim,yposit+0.025); //for form factor plot
//    yline1=start_text(ylim,yposit+0.015);
  }
//
  FormatFunc(fun1,iColor,iLineSty);
  fun1->SetLineWidth(5);
  fun1->Draw("same"); 
  TLatex *fun_lab1 = new TLatex();
  fun_lab1->SetTextSize(txtsize+0.0001);
  fun_lab1->SetTextColor(iColor);
  ytxt=move_text(ylim,ytxt,ystep);
  std::string text_title1;
  text_title1.append(txttit);
  fun_lab1->DrawLatex(xtxt,ytxt,text_title1.c_str());
  yline1=move_text(ylim,yline1,ystep);
//  put in line for label 
  TLine *line = new TLine(xline1,yline1,xline2,yline1);
  FormatLine(line,iColor,iLineSty);
  line->Draw();

   c2->Print(file.c_str());
}
EOF
root -b <<EOF
.L Elastic.C
.L Integrate.C
.L Spline.C
.L SplineFile.C
.L sakuda/ReadSakuda.C
.L data/NptReadData.C
.L SetGraphPt.C
.L CreatFun.C
.L FormatGraph.C
.L plt_fun2.C
// this need to be here
// Reference Plots with data
// Define the objects for the functions
// neutrino
  Elastic elas("nu","NucSpl","JRA_CS_HallA","Krutov","JRA_CS_HallA","JRA",1.00);
  Elastic elas_nub("nub","NucSpl","JRA_CS_HallA","Krutov","JRA_CS_HallA","JRA",1.00);
  Elastic elas_Tsush("nu","NucSpl","JRA_CS_HallA","Krutov","JRA_CS_HallA","JRA",1.00);
  Elastic elas_nub_Tsush("nub","NucSpl","JRA_CS_HallA","Krutov","JRA_CS_HallA","JRA",1.00);
  elas.InitElastic();
  elas_nub.InitElastic();
  elas_Tsush.InitElastic();
  elas_nub_Tsush.InitElastic();
  elas_Tsush.InitFF_Tsush_c12_G();
//  elas_Tsush.InitFF_Tsush_nucl_th_0307013(); // this is the same as the 3 lines below
//  elas_Tsush.set_fun_times_F_1_V("splF1","Tsushima/Tsushima_F1_rat.dat");
//  elas_Tsush.set_fun_times_cF_2_V("splF2","Tsushima/Tsushima_F2_rat.dat");
//  elas_Tsush.set_fun_times_F_A("splFA","Tsushima/Tsushima_GA_rat.dat");
  elas.WriteElastic();
  elas_Tsush.WriteElastic();
  double xmin=0.0;
  double xmax=2.0;
  double qsq=-0.5
  cout<<" rat F_1_V  = "<<elas_Tsush.F_1_V(qsq)/elas.F_1_V(qsq)<<endl;
  cout<<" rat cF_2_V = "<<elas_Tsush.cF_2_V(qsq)/elas.cF_2_V(qsq)<<endl;
  cout<<" rat F_A = "<<elas_Tsush.F_A(qsq)/elas.F_A(qsq)<<endl;
//
  TF1 *f_1_v_fun = new TF1("f_1_v_fun",f_1_v_rat,xmin,xmax,0);
  TF1 *cf_2_v_fun = new TF1("cf_2_v_fun",cf_2_v_rat,xmin,xmax,0);
  TF1 *f_a_fun = new TF1("f_a_fun",g_a_rat,xmin,xmax,0);
  double xmin=0.0;
  double xmax=3.0;
  TF1 *nuke_nu_fun = new TF1("nuke_nu_fun",Nuke_nu,xmin,xmax,0);
  TF1 *nuke_nub_fun = new TF1("nuke_nub_fun",Nuke_nub,xmin,xmax,0);
// 
  std::string tit  = "Ratios of Bounded to Free Form Factors " ;
  std::string tittxt  = "F_{1}^{*}(Q^{2})/F_{1}^{free}(Q^{2}) " ;
  std::string  file = "Tsushima_ff_g.eps" ; 
  double x_axis_min=0.0;
  double x_axis_max=2.0;
  double y_axis_min=0.85;
  double y_axis_max=1.25;
  int iColor=2;
  int iLineStyle=0;
  int iEnter=0;
  plt_fun(f_1_v_fun,tit,tittxt,file,x_axis_min,x_axis_max,y_axis_min,y_axis_max,iColor,iLineStyle,0);
  std::string tittxt  = "#xiF_{2}^{*}(Q^{2})/#xiF_{2}^{free}(Q^{2}) " ;
  int iColor=4;
  int iLineStyle=2;
  plt_fun(cf_2_v_fun,tit,tittxt,file,x_axis_min,x_axis_max,y_axis_min,y_axis_max,iColor,iLineStyle,1);
  std::string tittxt  = "F_{A}^{*}(Q^{2})/F_{A}^{free}(Q^{2}) " ;
  int iColor=6;
  int iLineStyle=4;
  plt_fun(f_a_fun,tit,tittxt,file,x_axis_min,x_axis_max,y_axis_min,y_axis_max,iColor,iLineStyle,1);
//
  std::string tit  = "Nucl. Corr.,  Fermi Gas, C_{12}, E_{BIND}=25 MeV" ;
  std::string tittxt  = "neutrino" ;
  std::string  file = "NukeFermiGasC12EBind25.eps" ; 
  double x_axis_min=0.0;
  double x_axis_max=3.0;
  double y_axis_min=0.0;
  double y_axis_max=1.0;
  int iColor=2;
  int iLineStyle=1;
plt_fun(nuke_nu_fun,tit,tittxt,file,x_axis_min,x_axis_max,y_axis_min,y_axis_max,iColor,iLineStyle,0);
//
  std::string tittxt  = "antineutrino" ;
  int iColor=4;
  int iLineStyle=2;
plt_fun(nuke_nub_fun,tit,tittxt,file,x_axis_min,x_axis_max,y_axis_min,y_axis_max,iColor,iLineStyle,1);
//
EOF
