#! /bin/csh -f
#
cat > CreatFun.C<<EOF
// Note, These are for plots so the x axis is always > 0, ie Q**2.
Double_t FA_f1a_v(Double_t , Double_t );
Double_t FA_f1a_v(Double_t *x, Double_t *par)
{
  return ExpE.F_A(-x[0])/ExpE.F_A_dipole(-x[0]);
}
// Note, These are for plots so the x axis is always > 0, ie Q**2.
Double_t FA_klink(Double_t , Double_t );
Double_t FA_klink(Double_t *x, Double_t *par)
{
  return ExpF.F_A(-x[0])/ExpF.F_A_dipole(-x[0]);
}
EOF
cat > funct.C<<EOF
#include <ctype.h>
//#include <string.h>
#include <cstring>
#include "Elastic.h"
#include "Experiment.h"
#include "TGraph.h"
#include "TF1.h"
void plt_fun(TF1* , std::string , std::string, std::string 
 ,double ,double ,double ,double ,double ,double & ,int ,int ,int ); 
//
void plt_dat(Experiment& ,std::string,std::string ,std::string ,std::string 
,double ,double ,double ,double ,double ,double & , int ,int,float,int ); 
//
void plt_dat(Experiment& Exp,std::string title ,std::string txt1,std::string txt2, 
std::string file ,double x_ax_min ,double x_ax_max ,double y_ax_min ,double y_ax_max
,double xposit,double& yposit ,int iColor,int marker, float symSiz,int iEnter)
{
// nu_num states whether it is nu nub or both
//create titles
  double xtitle= 0.02;
  double ytitle=1.02;
  double ystep = 0.07;
  float txtsize=0.04;
  Margin( 0.10, 0.04, 0.13, 0.12);
  if(iEnter==0)
  {
    TCanvas *c2 = new TCanvas("c2","",800,800);
    gPad->SetGrid();
    c2->Range(0,0,20,20);
    c2->SetFillColor(10);
  }
  double xlim[2];
  double ylim[2];
  xlim[0]=x_ax_min;
  xlim[1]=x_ax_max;
  ylim[0]=y_ax_min;
  ylim[1]=y_ax_max;
  if(iEnter==0)
  {
    TH2F *gr2  = new TH2F("gr2", "",300,xlim[0],xlim[1],300 ,ylim[0],ylim[1]);
    FormatGraph(gr2,txtsize,txtsize+0.005,1.2,1.3);
    gr2->GetXaxis()->SetTitle("Q^{2} (GeV/c)^{2}");
    gr2->GetYaxis()->SetTitle("F_{A}(Q^{2})/dipole");
    gr2->Draw("AP");
    TLatex *titl = new TLatex();
    titl->SetTextSize(txtsize+0.005);
    titl->SetTextColor(1);
    double xtit=start_text(xlim,xtitle);
    double ytit=start_text(ylim,ytitle);
    titl->DrawLatex(xtit,ytit,title.c_str());
  }
// now start plotting
  double xtxt=start_text(xlim,xposit);
  double ytxt=start_text(ylim,yposit);
//  now plot some points
  int line_width=2;
//
  float xval[100]={0};
  float yval[100]={0};
  float x_err[100]={0};
  float y_err[100]={0};
//
  int n_data_pt=Exp.return_n_data_pt();
  double* Q2=Exp.return_Q2_bin_cent_ave_F_A_2_wt_coefFA2();
  double* F_A_calc=Exp.return_F_A_calc();
  double* F_A_error=Exp.return_F_A_error();
  int index=0;
  for (int i_data_pt=IBIN_CHI_START; i_data_pt<n_data_pt-IBIN_CHI_END; i_data_pt++)
  {
    double FA=Exp.F_A(-Q2[i_data_pt]);
    double dipole=Exp.F_A_dipole(-Q2[i_data_pt]);
    index=i_data_pt-IBIN_CHI_START;
    xval[index]=Q2[i_data_pt];
    yval[index]=F_A_calc[i_data_pt]/dipole;
    x_err[index]=0.00001;
    y_err[index]=-F_A_error[i_data_pt]/dipole;
  }
  int npoint = n_data_pt-IBIN_CHI_START-IBIN_CHI_END;
  TGraphErrors *data = new TGraphErrors(npoint,xval,yval,x_err,y_err);
  FormatErrors(data,iColor,marker,symSiz,line_width);
  data->Draw("P");
  TLatex *label = new TLatex();
  label->SetTextSize(txtsize);
  label->SetTextColor(iColor);
  double xtxt=start_text(xlim,xposit);
  double ytxt=start_text(ylim,yposit);
  label->DrawLatex(xtxt,ytxt,txt1.c_str());
  double xsym=start_text(xlim,xposit-0.02);
  double ysym=start_text(ylim,yposit+0.01);
  TMarker *symb = new TMarker(xsym,ysym,marker);
  FormatMarker(symb,iColor,marker,symSiz);
  symb->Draw();
  c2->Print(file.c_str());
  yposit=yposit-ystep; // move y down
}
//
void plt_fun(TF1* fun1 ,std::string title ,std::string txttit, std::string file
 ,double x_axis_min ,double x_axis_max ,double y_axis_min ,double y_axis_max
,double xposit ,double& yposit ,int iColor,int iLineSty,int iEnter)
{
// nu_num states whether it is nu nub or both
//create titles
  double xtitle= 0.02;
  double ytitle= 1.02;
  double ystep = 0.07;
  float txtsize=0.04;
  Margin( 0.10, 0.04, 0.13, 0.12);
  if(iEnter==0)
  {
    TCanvas *c2 = new TCanvas("c2","",800,800);
    gPad->SetGrid();
    c2->Range(0,0,20,20);
    c2->SetFillColor(10);
  }
  double xlim[2];
  double ylim[2];
  xlim[0]=x_axis_min;
  xlim[1]=x_axis_max;
  ylim[0]=y_axis_min;
  ylim[1]=y_axis_max;
  if(iEnter==0)
  {
    TH2F *gr2  = new TH2F("gr2", "",300,xlim[0],xlim[1],300 ,ylim[0],ylim[1]);
    FormatGraph(gr2,txtsize,txtsize+0.005,1.2,1.3);
    gr2->GetXaxis()->SetTitle("Q^{2} (GeV/c)^{2}");
    gr2->GetYaxis()->SetTitle("F_{A}(Q^{2})/dipole");
    gr2->Draw("AP");
    TLatex *titl = new TLatex();
    titl->SetTextSize(txtsize+0.005);
    titl->SetTextColor(1);
    double xtit=start_text(xlim,xtitle);
    double ytit=start_text(ylim,ytitle);
    titl->DrawLatex(xtit,ytit,title.c_str());
  }
// now start plotting
  double xtxt=start_text(xlim,xposit);
  double xline1=start_text(xlim,xposit-0.07);
  double xline2=start_text(xlim,xposit-0.01);
  double ytxt=start_text(ylim,yposit);
  double yline1=start_text(ylim,yposit+0.015);
  FormatFunc(fun1,iColor,iLineSty);
  fun1->SetLineWidth(5);
  fun1->Draw("same"); 
  TLatex *fun_lab1 = new TLatex();
  fun_lab1->SetTextSize(txtsize+0.0001);
  fun_lab1->SetTextColor(iColor);
  std::string text_title1;
  text_title1.append(txttit);
  fun_lab1->DrawLatex(xtxt,ytxt,text_title1.c_str());
//  put in line for label 
  TLine *line = new TLine(xline1,yline1,xline2,yline1);
  FormatLine(line,iColor,iLineSty);
  line->Draw();
  c2->Print(file.c_str());
  yposit=yposit-ystep; // move y down
}
EOF
root -b <<EOF
.L Experiment.C
.L Elastic.C
.L Integrate.C
.L Spline.C
.L SplineArea.C
.L FindRoot.C
.L NucCorr.C
.L SplineFile.C
.L SetGraphPt.C
.L CreatFun.C
.L FormatGraph.C
.L funct.C
// this need to be here
// Reference Plots with data
// Define the objects for the functions
// neutrino
  Int_t npx=100;
  double x_ax_min=0.0; // axis boundry
  double x_ax_max=6.0;
  double y_ax_min=0.0;
  double y_ax_max=1.8;
  double xmin=x_ax_min;
  double xmax=x_ax_max;  
  double x_p=0.60; //start position of the text
  double y_p=0.30; // start position of the text
  char tit[100];
  char file[100];
  sprintf(tit,"QE scattering, #nu, F_{A}, M_{A} = 1.014");
  sprintf(file,"fa.eps");
//
  Experiment ExpE("Kitagaki_83","nu","SinghD","JRA_CS_HallA","Krutov","JRA_CS_HallA","JRA",1.014);
  ExpE.set_fun_F_A("F1_V_eq_A");
  ExpE.set_accurInteg(0.111);
  ExpE.InitExperiment();
  TF1 *fa_f1a_v = new TF1("fa_f1a_v",FA_f1a_v,xmin,xmax,0);
  fa_f1a_v->SetNpx(npx);
  std::string tittxt  = "F1, V=A" ;
  int iColor=2;
  int iLineStyle=1;
  cout<<" y_p="<<y_p<<endl;
  plt_fun(fa_f1a_v,tit,tittxt,file,x_ax_min,x_ax_max,y_ax_min,y_ax_max,x_p,y_p,iColor,iLineStyle,0);
  cout<<" y_p="<<y_p<<endl;
//
  Experiment ExpF("Kitagaki_83","nu","SinghD","JRA_CS_HallA","Krutov","JRA_CS_HallA","JRA",1.014);
  ExpF.set_fun_F_A("spline");
  ExpF.set_accurInteg(0.111);
  ExpF.InitExperiment();
  TF1 *fa_klink = new TF1("fa_klink",FA_klink,xmin,xmax,0);
  fa_klink->SetNpx(npx);
  std::string tittxt  = "Wagenbrunn" ;
  int iColor=7;
  int iLineStyle=1;
  cout<<" y_p="<<y_p<<endl;
  plt_fun(fa_klink,tit,tittxt,file,x_ax_min,x_ax_max,y_ax_min,y_ax_max,x_p,y_p,iColor,iLineStyle,1);
  cout<<" y_p="<<y_p<<endl;
  //
  Experiment ExpB("Baker_81","nu","SinghD","JRA_CS_HallA","Krutov","JRA_CS_HallA","JRA",1.014);
  ExpB.set_accurInteg(0.111);
  ExpB.InitExperiment();
  ExpB.Solve_F_A_by_integ_bin();
  ExpB.WriteExperiment();
  std::string txt1  = "BNL 1981" ;
  std::string txt2  = "" ;
  int iColor=4;
  int mark=20;
  float symSiz=1.1;
  cout<<" y_p="<<y_p<<endl;
  plt_dat(ExpB,tit,txt1,txt2,file,x_ax_min,x_ax_max,y_ax_min,y_ax_max,x_p,y_p,iColor,mark,symSiz,1);
  cout<<" y_p="<<y_p<<endl;
//
  Experiment ExpC("Miller_82","nu","SinghD","JRA_CS_HallA","Krutov","JRA_CS_HallA","JRA",1.014);
  ExpC.set_accurInteg(0.111);
  ExpC.InitExperiment();
  ExpC.Solve_F_A_by_integ_bin();
  ExpC.WriteExperiment();
  std::string txt1  = "ANL 1982" ;
  std::string txt2  = "" ;
  int iColor=6;
  int mark=20;
  float symSiz=1.1;
  plt_dat(ExpC,tit,txt1,txt2,file,x_ax_min,x_ax_max,y_ax_min,y_ax_max,x_p,y_p,iColor,mark,symSiz,1);
//
  Experiment ExpD("Kitagaki_83","nu","SinghD","JRA_CS_HallA","Krutov","JRA_CS_HallA","JRA",1.014);
  ExpD.set_accurInteg(0.111);
  ExpD.InitExperiment();
  ExpD.Solve_F_A_by_integ_bin();
  ExpD.WriteExperiment();
  std::string txt1  = "FNAL 1983" ;
  std::string txt2  = "" ;
  int iColor=3;
  int mark=20;
  float symSiz=1.1;
  plt_dat(ExpD,tit,txt1,txt2,file,x_ax_min,x_ax_max,y_ax_min,y_ax_max,x_p,y_p,iColor,mark,symSiz,1);
//
//  Experiment ExpB("Minerva_nu","nu","one","dipole","zero","dipole","dipole");
EOF
