#include <ctype.h>
#include <string.h>
#include "Elastic.h"
#include "TGraph.h"
#include "TF1.h"
void CS_2fun(TF1* ,TF1* ,TF1* , std::string , std::string, std::string, std::string, double x_max);
void CS_2fun
(TF1* fun1,TF1* fun2,TF1* fun3
 ,std::string title, std::string txttit, std::string file ,std::string nu_nub,double x_max)
{
// nu_num states whether it is nu nub or both
//create titles
  std::string txt_1 = "Free Nucleon";
  std::string txt_2 = "Fermi Gas, C_{12}, E_{BIND}=25 MeV";
  std::string txt_3 = "Fermi Gas, C_{12}, E_{BIND}=25 MeV, Bounded FF";
  double xtitle= 0.06;
  double ytitle=1.15;
  double ystep = 0.083;
  float txtsize=0.05;
  Margin( 0.10, 0.04, 0.13, 0.12);
  TCanvas *c2 = new TCanvas("c2","",800,370);
  gPad->SetGrid();
  c2->Range(0,0,20,20);
  c2->SetFillColor(10);
  double xlim[2] = {0.10.,11.7};
//  double xlim[2] = {0.10.,1.9};
  xlim[1]=x_max;
  if(strcmp(nu_nub.c_str(),"nu")==0&&x_max>5.0)
  {
    double xposit=0.53;
    double yposit=.475;
    double ylab_start=0.141;
    double ylim[2]= {0.1,1.35}; // for neutrino or both
  } 
  else if(strcmp(nu_nub.c_str(),"nu")==0&&x_max<5.0) 
  {
    double xposit=0.5;
    double yposit=.475;
    double ylab_start=0.141;
    double ylim[2]= {0.1,1.35}; // for neutrino or both
  } 
  else if(strcmp(nu_nub.c_str(),"nub")==0)
  {
    double xposit=0.482;
    double yposit=0.39 ;
    double ylab_start=0.118;
    double ylim[2]= {0.1,1.02}; // for antineutrino
  } 
  else
  {
    cout<<" nu_nub ="<<nu_nub.c_str()<<" not correct"<<endl; 
  } 
  TGraph  *gr2 = new TGraph(2,xlim,ylim);
  gr2->SetTitle("");
  TLatex *titl = new TLatex();
  titl->SetTextSize(txtsize+0.02);
  titl->SetTextColor(1);
  double xtxt=start_text(xlim,xtitle);
  double ytxt=start_text(ylim,ytitle);
  cout<<" ytxt="<<ytxt<<endl;
  titl->DrawLatex(xtxt,ytxt,title.c_str());
  gr2->SetMarkerSize(0);
  gr2->Draw("AP");
  FormatGraph(gr2);
  gr2->GetXaxis()->SetTitle("E_{#nu} (GeV)");
  gr2->GetYaxis()->SetTitle("#sigma( 10^{-38}cm^{2} )");
  gr2->GetXaxis()->SetLabelSize(txtsize+0.01);
  gr2->GetYaxis()->SetLabelSize(txtsize+0.01);
  gr2->Draw("AP");
  Int_t iColor;
  Int_t iLineSty; 
// now start plotting
  double xtxt=start_text(xlim,xposit);
  double ytxt=start_text(ylim,yposit);
  double xline1=start_text(xlim,xposit-0.07);
  double xline2=start_text(xlim,xposit-0.01);
  double yline1=start_text(ylim,yposit+0.025);
//
  iColor=2;
  iLineSty=1;
  FormatFunc(fun1,iColor,iLineSty);
  fun1->SetLineWidth(5);
  fun1->Draw("same"); 
  TLatex *fun_lab1 = new TLatex();
  fun_lab1->SetTextSize(txtsize+0.0001);
  fun_lab1->SetTextColor(iColor);
  double ytxt=move_text(ylim,ytxt,ystep);
  std::string text_title1;
  text_title1.append(txt_1);
  text_title1.append(txttit);
  fun_lab1->DrawLatex(xtxt,ytxt,text_title1.c_str());
  double yline1=move_text(ylim,yline1,ystep);
//  put in ine for label 
  TLine *line = new TLine(xline1,yline1,xline2,yline1);
  FormatLine(line,iColor,iLineSty);
  line->Draw();
//
  iColor=4;
  iLineSty=2;
  FormatFunc(fun2,iColor,iLineSty);
  fun2->SetLineWidth(5);
  fun2->Draw("same"); 
  TLatex *fun_lab2 = new TLatex();
  fun_lab2->SetTextSize(txtsize+0.0001);
  fun_lab2->SetTextColor(iColor);
  fun_lab2->SetIndiceSize(0.55);
  fun_lab2->SetLimitIndiceSize(0.55);
  double ytxt=move_text(ylim,ytxt,ystep);
  std::string text_title2;
  text_title2.append(txt_2);
  text_title2.append(txttit);
  fun_lab2->DrawLatex(xtxt,ytxt,text_title2.c_str());
  double yline1=move_text(ylim,yline1,ystep);
  TLine *line = new TLine(xline1,yline1,xline2,yline1);
  FormatLine(line,iColor,iLineSty);
  line->Draw();

   c2->Print(file.c_str());
}
