#! /bin/csh -f
#
cat > CreatFun.C<<EOF
// Note, These are for plots so the x axis is always > 0, ie Q**2.
Double_t GEP_GMP_AB25(Double_t , Double_t );
Double_t GEP_GMP_AB25(Double_t *x, Double_t *par)
{
  return elas_ab25.G_E_p(-x[0])/elas_ab25.G_M_p(-x[0]);
}
Double_t GEP_GMP_JRA_CS_HallA(Double_t , Double_t );
Double_t GEP_GMP_JRA_CS_HallA(Double_t *x, Double_t *par)
{
  return elas_jra_cs_halla.G_E_p(-x[0])/elas_jra_cs_halla.G_M_p(-x[0]);
}
Double_t GEP_GMP_JRA_CS(Double_t , Double_t );
Double_t GEP_GMP_JRA_CS(Double_t *x, Double_t *par)
{
  return elas_jra_cs.G_E_p(-x[0])/elas_jra_cs.G_M_p(-x[0]);
}
Double_t GEP_GMP_spline(Double_t , Double_t );
Double_t GEP_GMP_spline(Double_t *x, Double_t *par)
{
  return elas_spline.G_E_p(-x[0])/elas_spline.G_M_p(-x[0]);
}
Double_t GEP_GMP_Kelly(Double_t , Double_t );
Double_t GEP_GMP_Kelly(Double_t *x, Double_t *par)
{
  return elas_Kelly.G_E_p(-x[0])/elas_Kelly.G_M_p(-x[0]);
}
EOF
cat > funct.C<<EOF
#include <ctype.h>
//#include <string.h>
#include <cstring>
#include "Elastic.h"
#include "Elastic.h"
#include "TGraph.h"
#include "TF1.h"
void plt_fun(TF1* , std::string , std::string, std::string 
 ,double ,double ,double ,double ,double ,double & ,int ,int ,int ); 
//
void plot_ff(DataQE& ,Elastic&, std::string,std::string ,std::string ,std::string 
,double ,double ,double ,double ,double ,double & ,float,int ); 
//
void plot_ff(DataQE& ffdat,Elastic& elas, std::string title ,std::string txt1,std::string txt2, 
std::string file ,double x_ax_min ,double x_ax_max ,double y_ax_min ,double y_ax_max
,double xposit,double& yposit, float symSiz,int iEnter)
{
// nu_num states whether it is nu nub or both
//create titles
  double xtitle= 0.02;
  double ytitle=1.02;
  double ystep = 0.042;
  float txtsize=0.033;
  Margin( 0.10, 0.04, 0.13, 0.12);
  if(iEnter==0)
  {
    TCanvas *c2 = new TCanvas("c2","",800,800);
    gPad->SetGrid();
    c2->Range(0,0,20,20);
    c2->SetFillColor(10);
  }
  double xlim[2];
  double ylim[2];
  xlim[0]=x_ax_min;
  xlim[1]=x_ax_max;
  ylim[0]=y_ax_min;
  ylim[1]=y_ax_max;
  if(iEnter==0)
  {
    TH2F *gr2  = new TH2F("gr2", "",300,xlim[0],xlim[1],300 ,ylim[0],ylim[1]);
    FormatGraph(gr2,txtsize,txtsize+0.005,1.2,1.3);
    gr2->GetXaxis()->SetTitle("Q^{2} (GeV/c)^{2}");
//  gr2->GetYaxis()->SetTitle("F_{A}(Q^{2})/dipole");
    gr2->GetYaxis()->SetTitle("G_{M}^{p}(Q^{2})/G_{M}^{p}(Q^{2})");
    gr2->Draw("AP");
    TLatex *titl = new TLatex();
    titl->SetTextSize(txtsize+0.005);
    titl->SetTextColor(1);
    double xtit=start_text(xlim,xtitle);
    double ytit=start_text(ylim,ytitle);
    titl->DrawLatex(xtit,ytit,title.c_str());
  }
// now start plotting
  double xtxt=start_text(xlim,xposit);
  double ytxt=start_text(ylim,yposit);
//  now plot some points
  int line_width=2;
//
  double x_err[100]={0.0001};
  double yval_ratio[100]={0};
  double yerr_ratio[100]={0};
//
  int numExpPlot=ffdat.return_numExpPlot();
  int nPlot=-1;
  cout<<" numExpPlot = "<<numExpPlot<<endl;
  for (int iExpPlot=0; iExpPlot<numExpPlot; iExpPlot++)
  {
    char* ff_exp=ffdat.return_experPlot(iExpPlot);// get experiment from plot file
    int iExp=ffdat.iExperNum(ff_exp); // This is the experiment from the data file
    if(iExp>-1&&iExp<ffdat.return_numExp())
    {
      nPlot++;
      cout<<" iExpPlot = "<<iExpPlot<<" iExp = "<<iExp<<" ff_exp = "<<ff_exp<<endl;
      int numData =ffdat.return_numData(iExp);
      double* Q2=ffdat.return_xdat(iExp);
      double* yval=ffdat.return_ydat(iExp);
      double* yerr=ffdat.return_yerr(iExp);
      for (int iData=0; iData<numData; iData++)
      {
        yval_ratio[iData]=yval[iData]/(1.0+mu_p);
        yerr_ratio[iData]=yerr[iData]/(1.0+mu_p);
      }
      TGraphErrors *data = new TGraphErrors(numData,Q2,yval_ratio,x_err,yerr_ratio);
//    TGraphErrors *data = new TGraphErrors(npoint,xval,yval,x_err,y_err);
      int iColor=iColorPlt[nPlot];
      int marker=20+nPlot;
      if(marker==31)
      {
        marker=3;
      }
      if(marker==32)
      {
        marker=5;
      }
      if(marker>32)
      {
        marker=20;
      }
      double symbolSize=symSiz+sizeSymChange[nPlot];
      FormatErrors(data,iColor,marker,symbolSize,line_width);
      data->Draw("P");
      TLatex *lab25el = new TLatex();
      lab25el->SetTextSize(txtsize);
      lab25el->SetTextColor(iColor);
      double xtxt=start_text(xlim,xposit);
      double ytxt=start_text(ylim,yposit);
       std::string ff_txt=ffdat.return_experPlot(iExpPlot);
      lab25el->DrawLatex(xtxt,ytxt,ff_txt.c_str());
      double xsym=start_text(xlim,xposit-0.02);
      double ysym=start_text(ylim,yposit+0.01);
      TMarker *symb = new TMarker(xsym,ysym,marker);
      FormatMarker(symb,iColor,marker,symbolSize);
      symb->Draw();
      c2->Print(file.c_str());
      yposit=yposit-ystep; // move y down
    }
  }
}
//
void plt_fun(TF1* fun1 ,std::string title ,std::string txttit, std::string file
 ,double x_axis_min ,double x_axis_max ,double y_axis_min ,double y_axis_max
,double xposit ,double& yposit ,int iColor,int iLineSty,int iEnter)
{
// nu_num states whether it is nu nub or both
//create titles
  double xtitle= 0.02;
  double ytitle= 1.02;
  double ystep = 0.04;
  float txtsize=0.03;
  Margin( 0.10, 0.04, 0.13, 0.12);
  if(iEnter==0)
  {
    TCanvas *c2 = new TCanvas("c2","",800,800);
    gPad->SetGrid();
    c2->Range(0,0,20,20);
    c2->SetFillColor(10);
  }
  double xlim[2];
  double ylim[2];
  xlim[0]=x_axis_min;
  xlim[1]=x_axis_max;
  ylim[0]=y_axis_min;
  ylim[1]=y_axis_max;
  if(iEnter==0)
  {
    TH2F *gr2  = new TH2F("gr2", "",300,xlim[0],xlim[1],300 ,ylim[0],ylim[1]);
    FormatGraph(gr2,txtsize,txtsize+0.005,1.2,1.3);
    gr2->GetXaxis()->SetTitle("Q^{2} (GeV/c)^{2}");
//    gr2->GetYaxis()->SetTitle("F_{A}(Q^{2})/dipole");
    gr2->GetYaxis()->SetTitle("G_{E}^{p}/G_{M}^{p}");
    gr2->Draw("AP");
    TLatex *titl = new TLatex();
    titl->SetTextSize(txtsize+0.005);
    titl->SetTextColor(1);
    double xtit=start_text(xlim,xtitle);
    double ytit=start_text(ylim,ytitle);
    titl->DrawLatex(xtit,ytit,title.c_str());
  }
// now start plotting
  double xtxt=start_text(xlim,xposit);
  double xline1=start_text(xlim,xposit-0.07);
  double xline2=start_text(xlim,xposit-0.01);
  double ytxt=start_text(ylim,yposit);
  double yline1=start_text(ylim,yposit+0.015);
  FormatFunc(fun1,iColor,iLineSty);
  fun1->SetLineWidth(5);
  fun1->Draw("same"); 
  TLatex *fun_lab251 = new TLatex();
  fun_lab251->SetTextSize(txtsize+0.0001);
  fun_lab251->SetTextColor(iColor);
  std::string text_title1;
  text_title1.append(txttit);
  fun_lab251->DrawLatex(xtxt,ytxt,text_title1.c_str());
//  put in line for lab25el 
  TLine *line = new TLine(xline1,yline1,xline2,yline1);
  FormatLine(line,iColor,iLineSty);
  line->Draw();
  c2->Print(file.c_str());
  yposit=yposit-ystep; // move y down
}
EOF
root -b <<EOF
.L data_kelly/DataQE.C
.L Elastic.C
.L Integrate.C
.L Spline.C
.L SplineArea.C
.L FindRoot.C
.L NucCorr.C
.L SplineFile.C
.L SetGraphPt.C
.L CreatFun.C
.L FormatGraph.C
.L funct.C
// this need to be here
// Reference Plots with data
// Define the objects for the functions
// neutrino
  Int_t npx=100;
  double x_ax_min=0.0; // axis boundry
  double x_ax_max=6.05;
  double y_ax_min=0.0;
  double y_ax_max=0.4;
  double xmin=x_ax_min;
  double xmax=x_ax_max;  
  double x_p=0.1; //start position of the text
  double y_p=0.35; // start position of the text
  char tit[100];
  char file[100];
  sprintf(tit,"G_{E}^{p}(Q^{2})/G_{M}^{p}(Q^{2})");
  sprintf(file,"gep_gmp.eps");
//
  Elastic elas_ab25("nu","SinghD","Kelly","AB25","Kelly","AB25",1.014);
  elas_ab25.InitElastic();
  TF1 *ff_ab25= new TF1("ff_ab25",GEP_GMP_AB25,xmin,xmax,0);
  std::string tittxt  = "G_{E}^{p}=Kelly/G_{M}^{p}=BBBA 2006" ;
  int iColor=102;
  int iLineStyle=1;
  plt_fun(ff_ab25,tit,tittxt,file,x_ax_min,x_ax_max,y_ax_min,y_ax_max,x_p,y_p,iColor,iLineStyle,0);
//
  Elastic elas_jra_cs_halla("nu","SinghD","JRA_CS_HallA","Krutov","JRA_CS_HallA","JRA",1.014);
  elas_jra_cs_halla.InitElastic();
  TF1 *ff_jra_cs_halla= new TF1("ff_jra_cs_halla",GEP_GMP_JRA_CS_HallA,xmin,xmax,0);
  std::string tittxt  = "BBA 2003" ;
  int iColor=1;
  int iLineStyle=2;
  plt_fun(ff_jra_cs_halla,tit,tittxt,file,x_ax_min,x_ax_max,y_ax_min,y_ax_max,x_p,y_p,iColor,iLineStyle,1);
//
  Elastic elas_jra_cs("nu","SinghD","JRA_CS","Krutov","JRA_CS","JRA",1.014);
  elas_jra_cs.InitElastic();
  TF1 *ff_jra_cs = new TF1("ff_jra_cs",GEP_GMP_JRA_CS,xmin,xmax,0);
  std::string tittxt  = "CS" ;
  int iColor=7;
  int iLineStyle=3;
//  plt_fun(ff_jra_cs,tit,tittxt,file,x_ax_min,x_ax_max,y_ax_min,y_ax_max,x_p,y_p,iColor,iLineStyle,1);
//
  Elastic elas_Kelly("nu","SinghD","Kelly","Kelly","Kelly","Kelly",1.014);
  elas_Kelly.InitElastic();
  TF1 *ff_kel = new TF1("ff_kel",GEP_GMP_Kelly,xmin,xmax,0);
  std::string tittxt  = "Kelly" ;
  int iColor=51;
  int iLineStyle=3;
  plt_fun(ff_kel,tit,tittxt,file,x_ax_min,x_ax_max,y_ax_min,y_ax_max,x_p,y_p,iColor,iLineStyle,1);
//
  Elastic elas_spline("nu","SinghD","spline","spline","spline","spline",1.014);
  elas_spline.InitElastic();
  TF1 *ff_spl = new TF1("ff_spl",GEP_GMP_spline,xmin,xmax,0);
  std::string tittxt  = "Wagenbrunn" ;
  int iColor=96;
  int iLineStyle=4;
  plt_fun(ff_spl,tit,tittxt,file,x_ax_min,x_ax_max,y_ax_min,y_ax_max,x_p,y_p,iColor,iLineStyle,1);
//
  DataQE FFA("muGEp/GMp","data_kelly/ratio_p.dat","data_kelly/ratio_p_plot.txt");
  FFA.ReadFile();
  FFA.ReadExperPlotFile();
  std::string txt1  = "" ;
  std::string txt2  = "" ;
  float symSiz=1.1;
  plot_ff(FFA,elas_spline,tit,txt1,txt2,file,x_ax_min,x_ax_max,y_ax_min,y_ax_max,x_p,y_p,symSiz,1);
//
EOF
