#! /bin/csh -f
#
cat > CreatFun.C<<EOF
Double_t elasq2_101(Double_t , Double_t );
Double_t elasq2_101(Double_t *x, Double_t *par)
{
  double enu=$1;
  return nu_ff_101.dsigma_dq2(-x[0],enu);
}
Double_t elasq2_130(Double_t , Double_t );
Double_t elasq2_130(Double_t *x, Double_t *par)
{
  double enu=$1;
  return nu_ff_130.dsigma_dq2(-x[0],enu);
}
Double_t elasq2_mvm(Double_t , Double_t );
Double_t elasq2_mvm(Double_t *x, Double_t *par)
{
  double enu=$1;
  return nu_ff_mvm.dsigma_dq2(-x[0], enu);
}
Double_t elasq2_rtr(Double_t , Double_t );
Double_t elasq2_rtr(Double_t *x, Double_t *par)
{
  double enu=$1;
  return nu_ff_rtr.dsigma_dq2(-x[0], enu);
}
EOF
cat > funct.C<<EOF
#include <ctype.h>
//#include <string.h>
#include <cstring>
#include "Elastic.h"
#include "TGraph.h"
#include "TF1.h"
void plt_fun(TF1* , std::string , std::string, std::string 
 ,double ,double ,double ,double ,double ,double & ,int ,int ,int ); 
//
void plt_fun(TF1* fun1 ,std::string title ,std::string txttit, std::string file
 ,double x_axis_min ,double x_axis_max ,double y_axis_min ,double y_axis_max
,double xposit ,double& yposit ,int iColor,int iLineSty,int iEnter)
{
// nu_num states whether it is nu nu or both
//create titles
  double xtitle= 0.02;
  double ytitle= 1.02;
  double ystep = 0.06;
  float txtsize=0.032;
  Margin( 0.10, 0.04, 0.13, 0.12);
  if(iEnter==0)
  {
    TCanvas *c2 = new TCanvas("c2","",800,800);
    gPad->SetGrid();
    c2->Range(0,0,20,20);
    c2->SetFillColor(10);
  }
  double xlim[2];
  double ylim[2];
  xlim[0]=x_axis_min;
  xlim[1]=x_axis_max;
  ylim[0]=y_axis_min;
  ylim[1]=y_axis_max;
  if(iEnter==0)
  {
    TH2F *gr2  = new TH2F("gr2", "",300,xlim[0],xlim[1],300 ,ylim[0],ylim[1]);
    FormatGraph(gr2,txtsize,txtsize+0.005,1.2,1.3);
    gr2->GetXaxis()->SetTitle("Q^{2} (GeV/c)^{2}");
    gr2->GetYaxis()->SetTitle("d#sigma/dQ^{2}   (10^{-38}cm^{2}/(GeV/c)^{2})");
    gr2->Draw("AP");
    TLatex *titl = new TLatex();
    titl->SetTextSize(txtsize+0.005);
    titl->SetTextColor(1);
    double xtit=start_text(xlim,xtitle);
    double ytit=start_text(ylim,ytitle);
    titl->DrawLatex(xtit,ytit,title.c_str());
  }
// now start plotting
  double xtxt=start_text(xlim,xposit);
  double xline1=start_text(xlim,xposit-0.07);
  double xline2=start_text(xlim,xposit-0.01);
  double ytxt=start_text(ylim,yposit);
  double yline1=start_text(ylim,yposit+0.015);
  FormatFunc(fun1,iColor,iLineSty);
  fun1->SetLineWidth(5);
  fun1->Draw("same"); 
  TLatex *fun_lab1 = new TLatex();
  fun_lab1->SetTextSize(txtsize+0.0001);
  fun_lab1->SetTextColor(iColor);
  std::string text_title1;
  text_title1.append(txttit);
  fun_lab1->DrawLatex(xtxt,ytxt,text_title1.c_str());
//  put in line for label 
  TLine *line = new TLine(xline1,yline1,xline2,yline1);
  FormatLine(line,iColor,iLineSty);
  line->Draw();
  c2->Print(file.c_str());
  yposit=yposit-ystep; // move y down
}
double x_axis_max(double, double);
double x_axis_max(double x_ax_max, double Q2max)
{
  double xmax=x_ax_max;
  if(Q2max<=x_ax_max)
  {
    double xmax = Q2max;
  }
  return xmax;
}
EOF
root -b <<EOF
//.L data_kelly/DataQE.C
.L Elastic.C
.L Lagrange.C
.L Integrate.C
.L Spline.C
.L SplineArea.C
.L FindRoot.C
.L NucCorr.C
.L SplineFile.C
.L SetGraphPt.C
.L CreatFun.C
.L FormatGraph.C
.L funct.C
// this need to be here
// Reference Plots with data
// Define the objects for the functions
// neutrino
  Int_t npx=100;
  double x_ax_min=0.0; // axis boundry
  double x_ax_max=2.5;
  double y_ax_min=0.0;
  double y_ax_max=2.0;
  double xmin=x_ax_min;
  double xmax=x_ax_max;  
  double x_p=0.3; //start position of the text
  double y_p=0.95; // start position of the text
  char tit[100];
  char file[100];
//  sprintf(tit,"d#sigma/dQ^{2}, #bar{#nu} + p #rightarrow n + #mu^{+}, E_{#nu}=$1 GeV");
  sprintf(tit,"d#sigma/dQ^{2}, #nu + n #rightarrow p + #mu^{-}, E_{#nu}=$1 GeV");
  sprintf(file,"nu_nrat_q2_meson_lagr_$1.eps");
//
  Elastic nu_ff_101("nu","NeugQE","Lagr","Lagr25","Lagr_dip","Lagr25_dip",1.014,-1.267,0.105658,1.0,.842615,.1);
          nu_ff_101.InitElastic();
//
  Elastic nu_ff_130("nu","NeugQE","Lagr","Lagr25","Lagr_dip","Lagr25_dip",1.30,-1.267,0.105658,1.0,.842615,.1);
          nu_ff_130.InitElastic();
//
  Elastic nu_ff_mvm("nu","NeugQE","Lagr","Lagr25","Lagr_dip_mVM","Lagr25_dip_mVM",1.014,-1.267,0.105658,1.0,.842615,.1);
          nu_ff_mvm.InitElastic();
//
  Elastic nu_ff_rtr("nu","NeugQE","Lagr","Lagr25","Lagr_dip","Lagr25_dip",1.014,-1.267,0.105658,1.0,.842615,.1);
          nu_ff_rtr.set_fun_times_G_M_p("r_trunc","Tsushima/Tsushima_F1_rat.dat");
          nu_ff_rtr.set_fun_times_G_M_n("r_trunc","Tsushima/Tsushima_F1_rat.dat");
          nu_ff_rtr.InitElastic();

//
    double Q2max=-nu_ff_101.q2_max($1);
    xmax = x_axis_max(x_ax_max, Q2max);
//
  TF1 *q101 = new TF1("q101",elasq2_101,xmin,xmax,0);
  std::string tittxt  = "M_{A}=1.014" ;
  int iColor=95;
  int iLineStyle=3;
  plt_fun(q101,tit,tittxt,file,x_ax_min,xmax,y_ax_min,y_ax_max,x_p,y_p,iColor,iLineStyle,0);
//
  TF1 *q130 = new TF1("q130",elasq2_130,xmin,xmax,0);
  std::string tittxt  = "M_{A}=1.30" ;
  int iColor=4;
  int iLineStyle=2;
  plt_fun(q130,tit,tittxt,file,x_ax_min,xmax,y_ax_min,y_ax_max,x_p,y_p,iColor,iLineStyle,1);
//
  TF1 *qmvm = new TF1("qmvm",elasq2_mvm,xmin,xmax,0);
  std::string tittxt  = "m_{V}=1.0 in G_{M}^{V}, M_{A}=1.014" ;
  int iColor=2;
  int iLineStyle=8;
//  plt_fun(qmvm,tit,tittxt,file,x_ax_min,xmax,y_ax_min,y_ax_max,x_p,y_p,iColor,iLineStyle,1);
//
  TF1 *qrtr = new TF1("qrtr",elasq2_rtr,xmin,xmax,0);
  std::string tittxt  = "Tranv Enhance in G_{M}^{V}, M_{A}=1.014" ;
  int iColor=102;
  int iLineStyle=1;
  plt_fun(qrtr,tit,tittxt,file,x_ax_min,xmax,y_ax_min,y_ax_max,x_p,y_p,iColor,iLineStyle,1);
//
EOF
