#! /bin/csh -f
#
cat > CreatFun.C<<EOF
// Note, These are for plots so the x axis is always > 0, ie Q**2.
Double_t dsigmadq2_d0dd(Double_t , Double_t );
Double_t dsigmadq2_d0dd(Double_t *x, Double_t *par)
{
  return elas.dsigma_dq2_d0dd(-x[0],$1);
}
Double_t dsigmadq2(Double_t , Double_t );
Double_t dsigmadq2(Double_t *x, Double_t *par)
{
  return elas.dsigma_dq2(-x[0],$1);
}
Double_t dsigmadq2_tsush(Double_t , Double_t );
Double_t dsigmadq2_tsush(Double_t *x, Double_t *par)
{
  return elas_tsush.dsigma_dq2(-x[0],$1);
}
Double_t dsigmadq2_tsush_f1(Double_t , Double_t );
Double_t dsigmadq2_tsush_f1(Double_t *x, Double_t *par)
{
  return elas_tsush_f1.dsigma_dq2(-x[0],$1);
}
EOF
cat > funct.C<<EOF
#include <ctype.h>
#include <string.h>
#include "Elastic.h"
#include "TGraph.h"
#include "TF1.h"
void plt_fun(TF1* , std::string , std::string, std::string 
 ,double ,double ,double ,double ,int ,int ,int ); 
void plt_fun(TF1* fun1 ,std::string title ,std::string txttit, std::string file
 ,double x_axis_min ,double x_axis_max ,double y_axis_min ,double y_axis_max
 ,int iColor,int iLineSty,int iEnter)
{
// nu_num states whether it is nu nub or both
//create titles
  double xtitle= 0.02;
  double ytitle=1.02;
//  double ystep = 0.10; // bound form factors
  double ystep = 0.08;
  float txtsize=0.04;
  Margin( 0.10, 0.04, 0.13, 0.12);
  if(iEnter==0)
  {
    TCanvas *c2 = new TCanvas("c2","",800,800);
    gPad->SetGrid();
    c2->Range(0,0,20,20);
    c2->SetFillColor(10);
  }
  double xlim[2];
  double ylim[2];
  xlim[0]=x_axis_min;
  xlim[1]=x_axis_max;
  ylim[0]=y_axis_min;
  ylim[1]=y_axis_max;
//  double xposit=0.1; \\bounded ff
//  double yposit=1.01; \\bounded ff
  double xposit=0.30;
  double yposit=1.00;
  double ylab_start=0.141;
  if(iEnter==0)
  {
//    TGraph  *gr2 = new TGraph(2,xlim,ylim);
    TH2F *gr2  = new TH2F("gr2", "",300,xlim[0],xlim[1],300 ,ylim[0],ylim[1]);
    FormatGraph(gr2,txtsize,txtsize+0.005,1.2,1.3);
    gr2->GetXaxis()->SetTitle("Q^{2} (GeV^{2})");
//    gr2->GetXaxis()->SetTitle("E_{#nu} (GeV)");
    gr2->GetYaxis()->SetTitle("d#sigma/dQ^{2}   (10^{-38}cm^{2}/(GeV/c)^{2})");
    gr2->Draw("AP");
    TLatex *titl = new TLatex();
    titl->SetTextSize(txtsize+0.005);
    titl->SetTextColor(1);
    double xtit=start_text(xlim,xtitle);
    double ytit=start_text(ylim,ytitle);
    titl->DrawLatex(xtit,ytit,title.c_str());
  }
// now start plotting
  double xtxt=start_text(xlim,xposit);
  double xline1=start_text(xlim,xposit-0.07);
  double xline2=start_text(xlim,xposit-0.01);
  static double ytxt;
  static double yline1;
  if(iEnter==0)
  {
    ytxt=start_text(ylim,yposit);
//    yline1=start_text(ylim,yposit+0.025); //for form factor plot
    yline1=start_text(ylim,yposit+0.015);
  }
//
  FormatFunc(fun1,iColor,iLineSty);
  fun1->SetLineWidth(5);
  fun1->Draw("same"); 
  TLatex *fun_lab1 = new TLatex();
  fun_lab1->SetTextSize(txtsize+0.0001);
  fun_lab1->SetTextColor(iColor);
  ytxt=move_text(ylim,ytxt,ystep);
  std::string text_title1;
  text_title1.append(txttit);
  fun_lab1->DrawLatex(xtxt,ytxt,text_title1.c_str());
  yline1=move_text(ylim,yline1,ystep);
//  put in line for label 
  TLine *line = new TLine(xline1,yline1,xline2,yline1);
  FormatLine(line,iColor,iLineSty);
  line->Draw();

   c2->Print(file.c_str());
}
EOF
root -b <<EOF
.L Elastic.C
.L Integrate.C
.L Spline.C
.L NucCorr.C
.L SplineFile.C
.L sakuda/ReadSakuda.C
.L data/NptReadData.C
.L SetGraphPt.C
.L CreatFun.C
.L FormatGraph.C
.L funct.C
// this need to be here
// Reference Plots with data
// Define the objects for the functions
// neutrino
  Elastic d0dd("nu","one","dipole","zero","dipole","dipole",1.00);
  Elastic elas("nu","one","JRA_CS_HallA","Krutov","JRA_CS_HallA","JRA",1.00);
  Elastic elas_tsush("nu","one","JRA_CS_HallA","Krutov","JRA_CS_HallA","JRA",1.00);
  Elastic elas_tsush_f1("nu","one","JRA_CS_HallA","Krutov","JRA_CS_HallA","JRA",1.00);
  double enu=$1;
  elas.InitElastic();
  elas.WriteElastic();
  elas_tsush.InitElastic();
  elas_tsush.InitFF_Tsush_c12_G_to_1_gt_2GeV(); //does everything
  elas_tsush.WriteElastic();
  elas_tsush_f1.set_fun_F_A("F1_V_eq_A");
  elas_tsush_f1.InitElastic();
  elas_tsush_f1.InitFF_Tsush_c12_G_to_1_gt_2GeV(); //does everything
  elas_tsush_f1.WriteElastic();
  cout<<" q2_min = "<<elas.q2_min(enu)<<" q2_max="<<elas.q2_max(enu)<<endl;
  double xmin=0.0;
  double xmax=enu;  
//
  Int_t npx=100;
  TF1 *dsigdq2 = new TF1("dsigdq2",dsigmadq2,xmin,xmax,0);
  dsigdq2->SetNpx(npx);
  TF1 *dsigdq2_tsush = new TF1("dsigdq2_tsush",dsigmadq2_tsush,xmin,xmax,0);
  dsigdq2_tsush->SetNpx(npx);
  TF1 *dsigdq2_tsush_f1 = new TF1("dsigdq2_tsush_f1",dsigmadq2_tsush_f1,xmin,xmax,0);
  dsigdq2_tsush_f1->SetNpx(npx);
// 
  char tit[100]
  char file[100]
  sprintf(tit,"d#sigma/dQ^{2}, E_{#nu}=$1 GeV");
  std::string tittxt  = "Free FF" ;
  sprintf(file,"q2_tsushima_$1.eps");
  cout<<file<<endl;
  double x_axis_min=0.0;
  double x_axis_max=enu;
  double y_axis_min=0.0;
  double y_axis_max=2.5;
  int iColor=2;
  int iLineStyle=0;
  int iEnter=0;
  plt_fun(dsigdq2,tit,tittxt,file,x_axis_min,x_axis_max,y_axis_min,y_axis_max,iColor,iLineStyle,0);
  std::string tittxt  = "Bounded FF " ;
  int iColor=4;
  int iLineStyle=1;
  plt_fun(dsigdq2_tsush,tit,tittxt,file,x_axis_min,x_axis_max,y_axis_min,y_axis_max,iColor,iLineStyle,1);
  std::string tittxt  = "Bounded FF, V = A, Q2>0.5 GeV " ;
  int iColor=3;
  int iLineStyle=2;
  plt_fun(dsigdq2_tsush_f1,tit,tittxt,file,x_axis_min,x_axis_max,y_axis_min,y_axis_max,iColor,iLineStyle,1);
//
EOF
