#! /bin/csh -f
#
root -b <<EOF
.L Elastic.C
.L Integrate.C
.L SetGraphPt.C
.L CreateFunct.C
.L FormatGraph.C
.L CS_ratio.C
// this need to be here
  double xmin=0.12;
  double xmax=10.0;
// Define the objects for the functions
// Define the objects for the functions
// Define the objects for the functions
//                             nuc    GEP     GEN    GMP     GMN      mA    gAcon
//  neutrino
  Elastic nu_d0dd_ma1032("nu","one","dipole","zero","dipole","dipole",1.032);
  Elastic nu_d0dd_ga123("nu","one","dipole","zero","dipole","dipole",1.02,-1.23);
  Elastic nu_d_0_d_d("nu","one","dipole","zero","dipole","dipole");
  Elastic nu_jha_k_jha_j("nu","one","JRA_CS_HallA","Krutov","JRA_CS_HallA","JRA");
  Elastic nu_jha_0_jha_j("nu","one","JRA_CS_HallA","zero","JRA_CS_HallA","JRA");
  Elastic nu_j_k_j_j("nu","one","JRA_CS","Krutov","JRA_CS","JRA");
  Elastic nu_j_0_j_j("nu","one","JRA_CS","zero","JRA_CS","JRA");
  Elastic nu_d_k_d_d("nu","one","dipole","Krutov","dipole","dipole");
  Elastic nu_d_0_d_j("nu","one","dipole","zero","dipole","JRA");
  Elastic nu_d_g_d_d("nu","one","dipole","Galster","dipole","dipole");
  Elastic nu_d_g_d_d("nu","one","dipole","Galster","dipole","dipole");
  Elastic nu_d0dd_gp15("nu","one","dipole","zero","dipole","dipole",1.02,-1.267,1.5);

// anti- neutrino
  Elastic nub_d0dd_ma1032("nub","one","dipole","zero","dipole","dipole",1.032);
  Elastic nub_d0dd_ga123("nub","one","dipole","zero","dipole","dipole",1.02,-1.23);
  Elastic nub_d_0_d_d("nub","one","dipole","zero","dipole","dipole");
  Elastic nub_jha_k_jha_j("nub","one","JRA_CS_HallA","Krutov","JRA_CS_HallA","JRA");
  Elastic nub_jha_0_jha_j("nub","one","JRA_CS_HallA","zero","JRA_CS_HallA","JRA");
  Elastic nub_j_k_j_j("nub","one","JRA_CS","Krutov","JRA_CS","JRA");
  Elastic nub_j_0_j_j("nub","one","JRA_CS","zero","JRA_CS","JRA");
  Elastic nub_d_k_d_d("nub","one","dipole","Krutov","dipole","dipole");
  Elastic nub_d_0_d_j("nub","one","dipole","zero","dipole","JRA");
  Elastic nub_d_g_d_d("nub","one","dipole","Galster","dipole","dipole");
  Elastic nub_d0dd_gp15("nub","one","dipole","zero","dipole","dipole",1.02,-1.267,1.5);

// ratios
  TF1 *ratio_nu_d0dd_ga123 = new TF1("ratio_nu_d0dd_ga123",ratNu_ga123_D0DD,xmin,xmax,0);
  TF1 *ratio_nub_d0dd_ga123 = new TF1("ratio_nub_d0dd_ga123",ratNub_ga123_D0DD,xmin,xmax,0);
// ratios
  TF1 *ratio_nu_d0dd_ma1032 = new TF1("ratio_nu_d0dd_ma1032",ratNu_ma1032_D0DD,xmin,xmax,0);
  TF1 *ratio_nub_d0dd_ma1032 = new TF1("ratio_nub_d0dd_ma1032",ratNub_ma1032_D0DD,xmin,xmax,0);
//
  TF1 *ratio_nu_JKJJ_D0DD = new TF1("ratio_nu_JKJJ_D0DD",ratNuJKJJ_D0DD,xmin,xmax,0);
  TF1 *ratio_nub_JKJJ_D0DD = new TF1("ratio_nub_JKJJ_D0DD",ratNubJKJJ_D0DD,xmin,xmax,0);
// 
  TF1 *ratio_nu_JhaKJhaJ_D0DD = new TF1("ratio_nu_JhaKJhaJ_D0DD",ratNuJhaKJhaJ_D0DD,xmin,xmax,0);
  TF1 *ratio_nub_JhaKJhaJ_D0DD = new TF1("ratio_nub_JhaKJhaJ_D0DD",ratNubJhaKJhaJ_D0DD,xmin,xmax,0);
//
  TF1 *ratio_nu_J0JJ_D0DD = new TF1("ratio_nu_J0JJ_D0DD",ratNuJ0JJ_D0DD,xmin,xmax,0);
  TF1 *ratio_nub_J0JJ_D0DD = new TF1("ratio_nub_J0JJ_D0DD",ratNubJ0JJ_D0DD,xmin,xmax,0);
//
  TF1 *ratio_nu_DKDD_D0DD = new TF1("ratio_nu_DKDD_D0DD",ratNuDKDD_D0DD,xmin,xmax,0);
  TF1 *ratio_nub_DKDD_D0DD = new TF1("ratio_nub_DKDD_D0DD",ratNubDKDD_D0DD,xmin,xmax,0);
//
  TF1 *ratio_nu_D0DJ_D0DD = new TF1("ratio_nu_D0DJ_D0DD",ratNuD0DJ_D0DD,xmin,xmax,0);
  TF1 *ratio_nub_D0DJ_D0DD = new TF1("ratio_nub_D0DJ_D0DD",ratNubD0DJ_D0DD,xmin,xmax,0);
//
  TF1 *ratio_nu_Jha0JhaJ_D0DD = new TF1("ratio_nu_Jha0JhaJ_D0DD",ratNuJha0JhaJ_D0DD,xmin,xmax,0);
  TF1 *ratio_nub_Jha0JhaJ_D0DD = new TF1("ratio_nub_Jha0JhaJ_D0DD",ratNubJha0JhaJ_D0DD,xmin,xmax,0);
//
  TF1 *ratio_nu_DGDD_D0DD = new TF1("ratio_nu_DGDD_D0DD",ratNuDGDD_D0DD,xmin,xmax,0);
  TF1 *ratio_nub_DGDD_D0DD = new TF1("ratio_nub_DGDD_D0DD",ratNubDGDD_D0DD,xmin,xmax,0);
//
  TF1 *ratio_nu_d0dd_gp15 = new TF1("ratio_nu_d0dd_gp15",ratNu_gp15_D0DD,xmin,xmax,0);
  TF1 *ratio_nub_d0dd_gp15 = new TF1("ratio_nub_d0dd_gp15",ratNub_gp15_D0DD,xmin,xmax,0);
//

  std::string tit = "Ratio, Dipole GEn=0, (g_{A}=-1.23)/(g_{A}=-1.267) " ;
  std::string txt = "" ;
  std::string  file = "ratio_ga123_D0DD.eps" ; 
CS_ratio(ratio_nu_d0dd_ga123,ratio_nub_d0dd_ga123 ,tit,txt,file);
//
  std::string tit = "Ratio, Dipole GEn=0, (m_{A}=1.032)/(m_{A}=1.02) " ;
  std::string txt = "" ;
  std::string  file = "ratio_ma1032_D0DD.eps" ; 
CS_ratio(ratio_nu_d0dd_ma1032,ratio_nub_d0dd_ma1032 ,tit,txt,file);
//
//
  std::string tit = "Ratio, (JRA fit with CS,Krutov)/(Dip, GEn =0)" ;
  std::string txt = "" ;
  std::string  file = "ratio_JKJJ_D0DD.eps" ; 
CS_ratio(ratio_nu_JKJJ_D0DD,ratio_nub_JKJJ_D0DD ,tit,txt,file);
//
//
  std::string tit = "Ratio, BBA 2003(CS+HallA,Krutov)/(Dip, GEn =0) " ;
  std::string txt = "" ;
  std::string  file = "ratio_JhaKJhaJ_D0DD.eps" ; 
CS_ratio(ratio_nu_JhaKJhaJ_D0DD,ratio_nub_JhaKJhaJ_D0DD,tit,txt,file);
//
//
  std::string tit = "Ratio, (JRA fit with CS,GEn=0)/(Dipole, GEn =0)" ;
  std::string txt = "" ;
  std::string  file = "ratio_J0JJ_D0DD.eps" ; 
CS_ratio(ratio_nu_J0JJ_D0DD,ratio_nub_J0JJ_D0DD ,tit,txt,file);
//
  std::string tit = "Ratio, (Dipole, GEn=Krutov)/(Dipole, GEn =0)" ;
  std::string txt = "" ;
  std::string  file = "ratio_DKDD_D0DD.eps" ; 
CS_ratio(ratio_nu_DKDD_D0DD,ratio_nub_DKDD_D0DD ,tit,txt,file);
//
//
  std::string tit = "Ratio,(Dipole,GEn=0,GMn is JRA fit)/(Dipole,GEn=0)" ;
  std::string txt = "" ;
  std::string  file = "ratio_D0DJ_D0DD.eps" ; 
CS_ratio(ratio_nu_D0DJ_D0DD,ratio_nub_D0DJ_D0DD ,tit,txt,file);
//
//
  std::string tit = "Ratio, (JRA fit, CS+HallA, GEn =0)/(Dip, GEn =0) " ;
  std::string txt = "" ;
  std::string  file = "ratio_Jha0JhaJ_D0DD.eps" ; 
CS_ratio(ratio_nu_Jha0JhaJ_D0DD,ratio_nub_Jha0JhaJ_D0DD,tit,txt,file);
//
//
  std::string tit = "Ratio, (Dipole, GEn=Galster)/(Dipole, GEn =0)" ;
  std::string txt = "" ;
  std::string  file = "ratio_DGDD_D0DD.eps" ;
CS_ratio(ratio_nu_DGDD_D0DD,ratio_nub_DGDD_D0DD ,tit,txt,file);
//
  std::string tit = "Ratio, Dipole GEn=0, 1.5*g_{P}(q^{2})/g_{P}(q^{2}) " ;
  std::string txt = "" ;
  std::string  file = "ratio_gp15_D0DD.eps" ;
CS_ratio(ratio_nu_d0dd_gp15,ratio_nub_d0dd_gp15 ,tit,txt,file);
//
EOF

