#! /bin/csh -f
#
root -b <<EOF
.L Elastic.C
.L SplineFile.C
.L Spline.C
.L NucCorr.C
.L Integrate.C
.L SetGraphPt.C
.L CreateFunct.C
.L FormatGraph.C
.L CS_ratio.C
// this need to be here
  double xmin=0.12;
  double xmax=10.0;
// Define the objects for the functions
// Define the objects for the functions
// Define the objects for the functions
//                             nuc    GEP     GEN    GMP     GMN      mA    gAcon
//  neutrino
  Elastic nu_d0dd_ma1032("nu","one","dipole","zero","dipole","dipole",1.032);
  Elastic nu_d0dd_ga123("nu","one","dipole","zero","dipole","dipole",1.02,-1.23);
  Elastic nu_d_0_d_d("nu","one","dipole","zero","dipole","dipole");
  Elastic nu_jha_k_jha_j("nu","one","JRA_CS_HallA","Krutov","JRA_CS_HallA","JRA");
  Elastic nu_jha_0_jha_j("nu","one","JRA_CS_HallA","zero","JRA_CS_HallA","JRA");
  Elastic nu_j_k_j_j("nu","one","JRA_CS","Krutov","JRA_CS","JRA");
  Elastic nu_j_0_j_j("nu","one","JRA_CS","zero","JRA_CS","JRA");
  Elastic nu_d_k_d_d("nu","one","dipole","Krutov","dipole","dipole");
  Elastic nu_d_0_d_j("nu","one","dipole","zero","dipole","JRA");
  Elastic nu_d_g_d_d("nu","one","dipole","Galster","dipole","dipole");
  Elastic nu_d_g_d_d("nu","one","dipole","Galster","dipole","dipole");
  Elastic nu_d0dd_gp15("nu","one","dipole","zero","dipole","dipole",1.02,-1.267,1.5);

// anti- neutrino
  Elastic nub_d0dd_ma1032("nub","one","dipole","zero","dipole","dipole",1.032);
  Elastic nub_d0dd_ga123("nub","one","dipole","zero","dipole","dipole",1.02,-1.23);
  Elastic nub_d_0_d_d("nub","one","dipole","zero","dipole","dipole");
  Elastic nub_jha_k_jha_j("nub","one","JRA_CS_HallA","Krutov","JRA_CS_HallA","JRA");
  Elastic nub_jha_0_jha_j("nub","one","JRA_CS_HallA","zero","JRA_CS_HallA","JRA");
  Elastic nub_j_k_j_j("nub","one","JRA_CS","Krutov","JRA_CS","JRA");
  Elastic nub_j_0_j_j("nub","one","JRA_CS","zero","JRA_CS","JRA");
  Elastic nub_d_k_d_d("nub","one","dipole","Krutov","dipole","dipole");
  Elastic nub_d_0_d_j("nub","one","dipole","zero","dipole","JRA");
  Elastic nub_d_g_d_d("nub","one","dipole","Galster","dipole","dipole");
  Elastic nub_d0dd_gp15("nub","one","dipole","zero","dipole","dipole",1.02,-1.267,1.5);

// ratios
//
  TF1 *ratio_nu_JKJJ_JhaKJhaJ = new TF1("ratio_nu_JKJJ_JhaKJhaJ",ratNuJKJJ_JhaKJhaJ,xmin,xmax,0);
  TF1 *ratio_nub_JKJJ_JhaKJhaJ = new TF1("ratio_nub_JKJJ_JhaKJhaJ",ratNubJKJJ_JhaKJhaJ,xmin,xmax,0);
// 
  TF1 *ratio_nu_JhaKJhaJ_D0DD = new TF1("ratio_nu_JhaKJhaJ_D0DD",ratNuJhaKJhaJ_D0DD,xmin,xmax,0);
  TF1 *ratio_nub_JhaKJhaJ_D0DD = new TF1("ratio_nub_JhaKJhaJ_D0DD",ratNubJhaKJhaJ_D0DD,xmin,xmax,0);
//
  double ene;
  int ibin;
  for(ibin=0;ibin<20;ibin++)
  {
    ene=0.020*ibin;
    cout<<ene<<endl;
//    cout<<ene<<" "<<nu_jha_k_jha_j.sigma(ene)/nu_d_0_d_d.sigma(ene)<<endl;
  }
  cout<<endl;
//
  for(ibin=0;ibin<20;ibin++)
  {
    ene=0.020*ibin;
    cout<<ene<<endl;
//    cout<<ene<<" "<<nub_jha_k_jha_j.sigma(ene)/nub_d_0_d_d.sigma(ene)<<endl;
  }
//
//
  std::string tit = "Ratio, (JRA fit with CS,Krutov)/(BBA 2003)" ;
  std::string txt = "" ;
  std::string  file = "ratio_JKJJ_JhaKJhaJ.eps" ; 
CS_ratio(ratio_nu_JKJJ_JhaKJhaJ,ratio_nub_JKJJ_JhaKJhaJ ,tit,txt,file);
//
//
  std::string tit = "Ratio, BBA-2003(CS+HallA,Krutov)/(Dip, GEn =0) " ;
  std::string txt = "" ;
  std::string  file = "ratio_JhaKJhaJ_D0DD.eps" ; 
CS_ratio(ratio_nu_JhaKJhaJ_D0DD,ratio_nub_JhaKJhaJ_D0DD,tit,txt,file);
//
//
EOF

