#include <math.h>
#include <cstdlib>
#include <cstring>
#include <iostream.h>
#include <fstream.h>
#include "Spline.h"
//
Spline::Spline()
{
}
Spline::Spline
  (int n_dat
  ,double* x_dat
  ,double* y_dat)
{
  PutDataInSplineObj(n_dat,x_dat,y_dat);
}
Spline::Spline
  (int n_dat
  ,double* x_dat
  ,double* y_dat
  ,double y_dat_p1_1
  ,double y_dat_p1_n)
{
  PutDataInSplineObj(n_dat,x_dat,y_dat,y_dat_p1_1,y_dat_p1_n);
}
void Spline::PutDataInSplineObj(const int n_dat,double* x_dat,double* y_dat)
{
  numDataPts=n_dat;
  for(int i=0;i<numDataPts;i++)
  {
    xd[i]=x_dat[i];
    yd[i]=y_dat[i];
  }
  yd_p1_1=(yd[1]-yd[0])/(xd[1]-xd[0]);
  yd_p1_n=(yd[numDataPts-1]-yd[numDataPts-2])/(xd[numDataPts-1]-xd[numDataPts-2]);
  CalcFunctDoublePrime();
  xMinSpline=xd[0];
  xMaxSpline=xd[numDataPts-1];
}
void Spline::PutDataInSplineObj
  (const int n_dat
  ,double* x_dat
  ,double* y_dat
  ,double y_dat_p1_1
  ,double y_dat_p1_n)
{
  numDataPts=n_dat;
  for(int i=0;i<numDataPts;i++)
  {
    xd[i]=x_dat[i];
    yd[i]=y_dat[i];
  }
  yd_p1_1=y_dat_p1_1;
  yd_p1_n=y_dat_p1_n;
  yd_p1_1=(yd[1]-yd[0])/(xd[1]-xd[0]);
  yd_p1_n=(yd[numDataPts-1]-yd[numDataPts-2])/(xd[numDataPts-1]-xd[numDataPts-2]);
  CalcFunctDoublePrime();
  xMinSpline=xd[0];
  xMaxSpline=xd[numDataPts-1];
}
void Spline::CalcFunctDoublePrime()
{
  const int nmax=100;
  const double big=9.0e20;
  double u[nmax];
  if(yd_p1_1>big)
  {
    yd_p2[0]=0.0;
    u[0]=0.0;
  }
  else
  {
    yd_p2[0]=-0.5;
    u[0]=(3.0/(xd[1]-xd[0]))*((yd[1]-yd[0])/(xd[1]-xd[0])-yd_p1_1);
  }
  for(int i=1;i<numDataPts-1;i++)
  {
      double sig=(xd[i]-xd[i-1])/(xd[i+1]-xd[i-1]);
      double p=sig*yd_p2[i-1]+2.0;
      yd_p2[i]=(sig-1.0)/p;
      u[i]=(6.0*((yd[i+1]-yd[i])/(xd[i+1]-xd[i])-(yd[i]-yd[i-1])
     /(xd[i]-xd[i-1]))/(xd[i+1]-xd[i-1])-sig*u[i-1])/p;
  }
  double qn;
  double un;
  if(yd_p1_n>big)
  {
    qn=0.0;
    un=0.0;
  }
  else
  {
    qn=0.5;
    un=(3.0/(xd[numDataPts-1]-xd[numDataPts-2]))
    *(yd_p1_n-(yd[numDataPts-1]-yd[numDataPts-2])/(xd[numDataPts-1]-xd[numDataPts-2]));
  }
  yd_p2[numDataPts-1]=(un-qn*u[numDataPts-2])/(qn*yd_p2[numDataPts-2]+1.0);
  for(int k=numDataPts-2;k>=0;k--)
  {
    yd_p2[k]=yd_p2[k]*yd_p2[k+1]+u[k];
  }
}  

double Spline::Splint(double x)
{
  if(x<xd[0]||x>xd[numDataPts-1])
  {
    return 0;
  }
  int klo=0;
  int khi=numDataPts-1;
  while(khi-klo>1)
  {
    int k=(khi+klo)/2;
    if(xd[k]>x)
    {
      khi=k;
    }
    else
    {
      klo=k;
    }
  }
  double  h=xd[khi]-xd[klo];
  if(h==0)
  {
    cout<< " bad xd input."<<endl;
    exit(1);
  }
  double a=(xd[khi]-x)/h;
  double b=(x-xd[klo])/h;
  return a*yd[klo]+b*yd[khi]+
    ((a*a*a-a)*yd_p2[klo]+(b*b*b-b)*yd_p2[khi])*(h*h)/6.0;
}
void Spline::WrtInput()
{
  for (int j=0;j<numDataPts;j++)
  {
    cout<<j<<" xd= "<<xd[j]<<" yd="<<yd[j]<<" yd_p2="<<yd_p2[j]<<endl;
  }
  cout<<"yd_p1_1="<<yd_p1_1<<" yd_p1_n="<<yd_p1_n<<endl;
}
double Spline::Return_xMinSpline(){return xMinSpline;}
double Spline::Return_xMaxSpline(){return xMaxSpline;}
int Spline::Return_numDataPts(){return numDataPts;}
 
