#include "Elastic.h"
#include "Experiment.h"
#include <iostream>
#include <iomanip>
#include <ios>
#include <algorithm>
void Write_td_file_F_A_calc_ratio(Experiment&,int );
void Write_td_file_F_A_calc_ratio(Experiment& Exp,int isel)
{
  cout<< " ( Write_td_file_F_A_calc_ratio, isel = "<<isel<<endl;
  cout<<" set font duplex"<<endl;
  if(isel==4)
  {
    cout<<" title top \' QE scattering, N0M1, F0A1(Q223)/dipole, "
      <<Exp.return_exper()<<" \'  size 3.0"<<endl;
  }
  else
  { 
    cout<<" title top \' QE, N0M1, G0E12p3(Q223) ratio, F0A1(Q223) errors, "
       <<Exp.return_exper()<<" \'  size 3.0"<<endl;
    cout<<" case      \'     GXGX   X XX X  X X          X X  X X    \'"<<endl;
  }
//
  if(isel==1)
  {
    cout<<" title left \'  G0E12p3(Q223), (CS + Polar)/CS \' size 3.0"<<endl;
    cout<<" case       \'   X XX X  X X                       \'"<<endl;
  }
//
  if(isel==2)
  {
    cout<<" title left \'  G0E12p3(Q223), CS/dipole \' size 3.0"<<endl;
    cout<<" case       \'   X XX X  X X             \'"<<endl;
  }
//
  if(isel==3)
  {
    cout<<" title left \'  G0E12p3(Q223), (CS + Polar)/dipole \' size 3.0"<<endl;
    cout<<" case       \'   X XX X  X X                       \'"<<endl;
  }
//
  if(isel==4)
  {
  cout<<" title left \' F0A1(Q223)/dipole \' size 3.0"<<endl;
  cout<<" case       \'  X X  X X \'"<<endl;
  }
//
  cout<<" title bottom \' Q223 (GeV/c)223 \' size 3.0 "<<endl;
  cout<<" case         \'  X X        X X \'" <<endl;
//
  cout<<" set label size 3.0"<<endl;
  cout<<" set intensity 2"<<endl;
  cout<<" set tick size 0.05"<<endl;
  cout<<" set symbol size 2.0"<<endl;
  cout<<" set bar size 0"<<endl;
  cout<<" set symbol 5O"<<endl;
  cout<<" set title size 2.5"<<endl;
  cout<<" set scale x lin"<<endl;
  cout<<" set scale y lin "<<endl;
  if(isel==1)
  {
    cout<<" set limit x 0.00 "<<6.1<<" y 0.2 1.1 "<<endl;
  }
  if(isel==2)
  {
    cout<<" set limit x 0.00 "<<6.1<<" y 0.8 1.2 "<<endl;
  }
  if(isel==3)
  {
    cout<<" set limit x 0.00 "<<6.1<<" y 0.0 1.1 "<<endl;
  }
  if(isel==3)
  {
    cout<<" set limit x 0.00 "<<6.1<<" y 0.0 2.0 "<<endl;
  }
  cout<<" set color white"<<endl;
  cout<<" 100. 8000."<<endl;
  cout<<" plot"<<endl;
  cout<<" set order x y dy "<<endl;
  int n_data_pt=Exp.return_n_data_pt();
  double* Q2=Exp.return_Q2_bin_cent_ave_F_A_2_wt_coefFA2();
  double* F_A_calc=Exp.return_F_A_calc();
  double* F_A_error=Exp.return_F_A_error();
  int ibin_chi_start=Exp.return_ibin_chi_start();
  int ibin_chi_end=Exp.return_ibin_chi_end();
  for (int i_data_pt=ibin_chi_start; i_data_pt<n_data_pt-ibin_chi_end; i_data_pt++)
  {
    double FA=Exp.F_A(-Q2[i_data_pt]);
    double y0=Exp.F_A_dipole(-Q2[i_data_pt]);
    double y1=Exp.G_E_p_JRA_CS(-Q2[i_data_pt]);
    double y2=Exp.G_E_p_JRA_CS_HallA(-Q2[i_data_pt]);
    double y3=Exp.G_E_p_dipole(-Q2[i_data_pt]);
    if(isel==1)
    {
      cout<<Q2[i_data_pt]<<" " <<FA/y0<<"  " <<F_A_error[i_data_pt]/y0<<" (dipole/dipole)"<<endl;
    }
    if(isel==2)
    {
      cout<<Q2[i_data_pt]<<" " <<FA/y0<<"  " <<F_A_error[i_data_pt]/y0<<" (CS/dipole)"<<endl;
    }
    if(isel==3)
    {
      cout<<Q2[i_data_pt]<<" " <<FA/y0<<"  " <<F_A_error[i_data_pt]/y0<<" (Polar+CS)/dipole"<<endl;
    }
    if(isel==4)
    {
      cout<<Q2[i_data_pt]<<" " <<F_A_calc[i_data_pt]/FA<<"  " <<-F_A_error[i_data_pt]/FA<<endl;
    }
  }
  cout<<"plot"<<endl;
}
void Write_td_file_perc_ff(Experiment&,Experiment&,char*);
void Write_td_file_perc_ff(Experiment& Exp1,Experiment& Exp2,char* write)
{
  cout<< " ( Write_td_file_perc_ff " <<endl;
  if(strcmp(write,"write")==0)
  {
    cout<<" set font duplex"<<endl;
    cout<<" title top \' QE, N0M1,F0A1(Q223) contribution, M0A1=1\'  size 3.0"<<endl;
    cout<<" case      \'     GXGX  X X  X X                 X X \' "<<endl;
    cout<<" title left \' F0A1(Q223) contribution \' size 3.0"<<endl;
    cout<<" case       \'  X X  X X \'"<<endl;
    cout<<" title bottom \' Q223 (GeV/c)223 \' size 3.0 "<<endl;
    cout<<" case         \'  X X        X X \'" <<endl;
    cout<<" set label size 3.0"<<endl;
    cout<<" set intensity 2"<<endl;
    cout<<" set tick size 0.05"<<endl;
    cout<<" set symbol size 2.0"<<endl;
    cout<<" set bar size 0"<<endl;
    cout<<" set symbol 5O"<<endl;
    cout<<" set title size 2.5"<<endl;
    cout<<" set scale x lin"<<endl;
    cout<<" set scale y lin "<<endl;
    cout<<" set limit x 0.00 "<<6.1<<" y 0.1 1.1 "<<endl;
    cout<<" set color white"<<endl;
    cout<<" 100. 8000."<<endl;
    cout<<" plot"<<endl;
  }
  cout<<" set order x y dy "<<endl;
  int n_data_pt=Exp2.return_n_data_pt();
  double* Q2=Exp2.return_Q2();
  double* sig_q2_thy1=Exp1.return_sig_q2_thy();
  double* sig_q2_thy2=Exp2.return_sig_q2_thy();
  int ibin_chi_start=Exp1.return_ibin_chi_start();
  int ibin_chi_end=Exp1.return_ibin_chi_end();
  for (int i_data_pt=ibin_chi_start; i_data_pt<n_data_pt-ibin_chi_end; i_data_pt++)
  {
    double y1=sig_q2_thy1[i_data_pt];
    double y2=sig_q2_thy2[i_data_pt];
    cout<<Q2[i_data_pt]<<" "<<(y2-y1)/y2<<"  " <<endl;
  }
  cout<<"plot"<<endl;
}
void Write_td_file_dsigma_dff(Experiment&,Experiment&,double,char*);
void Write_td_file_dsigma_dff(Experiment& Exp1,Experiment& Exp2,double delta,char* write)
// calculates the (Exp1-Exp2)/Exp2*del i.e. for % change in cs/% change is form factor
{
  cout<< " ( Write_td_file_dsigma_dff, delta = "<<delta<<endl;
  if(strcmp(write,"write")==0)
  {
    cout<<" set font duplex"<<endl;
    cout<<" title top \' QE, N0M1, d(% dS/dQ223)/d(% F0A1) , M0A1=1\'  size 3.0"<<endl;
    cout<<" case      \'     GXGX       G   X X       X X     X X \' "<<endl;
    cout<<" title left \' d(% dS/dQ223)/d(% F0A1) \' size 3.0"<<endl;
    cout<<" case       \'      G   X X       X X  \'"<<endl;
    cout<<" title bottom \' Q223 (GeV/c)223 \' size 3.0 "<<endl;
    cout<<" case         \'  X X        X X \'" <<endl;
    cout<<" set label size 3.0"<<endl;
    cout<<" set intensity 2"<<endl;
    cout<<" set tick size 0.05"<<endl;
    cout<<" set symbol size 2.0"<<endl;
    cout<<" set bar size 0"<<endl;
    cout<<" set symbol 5O"<<endl;
    cout<<" set title size 2.5"<<endl;
    cout<<" set scale x lin"<<endl;
    cout<<" set scale y lin "<<endl;
    cout<<" set limit x 0.00 "<<6.1<<" y 0.7 1.2 "<<endl;
    cout<<" set color white"<<endl;
    cout<<" 100. 8000."<<endl;
    cout<<" plot"<<endl;
  }
  cout<<" set order x y dy "<<endl;
  int n_data_pt=Exp2.return_n_data_pt();
  double* Q2=Exp2.return_Q2();
  double* sig_q2_thy1=Exp1.return_sig_q2_thy();
  double* sig_q2_thy2=Exp2.return_sig_q2_thy();
  int ibin_chi_start=Exp1.return_ibin_chi_start();
  int ibin_chi_end=Exp1.return_ibin_chi_end();
  for (int i_data_pt=ibin_chi_start; i_data_pt<n_data_pt-ibin_chi_end; i_data_pt++)
  {
    double y1=sig_q2_thy1[i_data_pt];
    double y2=sig_q2_thy2[i_data_pt];
    cout<<Q2[i_data_pt]<<" "<<(y1-y2)/(y2*delta)<<"  " <<endl;
  }
  cout<<"plot"<<endl;
}
void Write_td_file_F_A_calc(Experiment&, int);
void Write_td_file_F_A_calc(Experiment& Exp, int numThyPts)
{
  cout<< " ( Write_td_file_F_A_calc, numThyPts = "<<numThyPts<<endl;
  cout<<" set font duplex"<<endl;
  cout<<" title top \' QE scattering, N0M1, F0A1(Q223), "
    <<Exp.return_exper()<<" \'  size 3.0"<<endl;
  cout<<" case      \'                GXGX   X X  X X    \'"<<endl;
  cout<<" title left \' F0A1(Q223) \' size 3.0"<<endl;
  cout<<" case       \'  X X  X X  \'"<<endl;
  cout<<" title bottom \' Q223 (GeV/c)223 \' size 3.0 "<<endl;
  cout<<" case         \'  X X        X X \'" <<endl;
  cout<<" set label size 3.0"<<endl;
  cout<<" set intensity 2"<<endl;
  cout<<" set tick size 0.05"<<endl;
  cout<<" set symbol size 2.0"<<endl;
  cout<<" set bar size 0"<<endl;
  cout<<" set symbol 5O"<<endl;
  cout<<" set title size 2.5"<<endl;
  cout<<" set scale x lin"<<endl;
  cout<<" set scale y lin "<<endl;
  cout<<" set limit x 0.00 "<<6.1<<" y 0.00001   1.3 "<<endl;
  cout<<" set color white"<<endl;
  cout<<" 100. 8000."<<endl;
  cout<<" plot"<<endl;
  cout<<" set order x y dy "<<endl;
  int n_data_pt=Exp.return_n_data_pt();
  double* Q2=Exp.return_Q2_bin_cent_ave_F_A_2_wt_coefFA2();
  double* F_A_calc=Exp.return_F_A_calc();
  double* F_A_error=Exp.return_F_A_error();
  int ibin_chi_start=Exp.return_ibin_chi_start();
  int ibin_chi_end=Exp.return_ibin_chi_end();
  for (int i_data_pt=ibin_chi_start; i_data_pt<n_data_pt-ibin_chi_end; i_data_pt++)
  {
    cout<<Q2[i_data_pt]<<" " <<-F_A_calc[i_data_pt]<<"  " <<F_A_error[i_data_pt]<<endl;
  }
  cout<<"plot"<<endl;
  cout<<" set order x y "<<endl;
  cout<<" set color red"<<endl;
  double q2_low=0.0;
  double q2_high=Exp.return_q2MaxData();
  double q2_step= (q2_high-q2_low)/(numThyPts-1);
  for(int i_data_pt=0; i_data_pt<numThyPts;i_data_pt++)
  {
    double q2_val=q2_low+i_data_pt*q2_step;
    cout<<q2_val<<" "<<-Exp.F_A(-q2_val)<<endl;
  }
  cout<<"join"<<endl;
}
void Write_td_file_F_A_calc_dip(Experiment&, int);
void Write_td_file_F_A_calc_dip(Experiment& Exp, int numThyPts)
{
  cout<< " ( Write_td_file_F_A_calc, numThyPts = "<<numThyPts<<endl;
  cout<<" set font duplex"<<endl;
  cout<<" title top \' QE scattering, N0M1, F0A1(Q223), "
    <<Exp.return_exper()<<" \'  size 3.0"<<endl;
  cout<<" case      \'                GXGX   X X  X X    \'"<<endl;
  cout<<" title left \' F0A1(Q223) \' size 3.0"<<endl;
  cout<<" case       \'  X X  X X  \'"<<endl;
  cout<<" title bottom \' Q223 (GeV/c)223 \' size 3.0 "<<endl;
  cout<<" case         \'  X X        X X \'" <<endl;
  cout<<" set label size 3.0"<<endl;
  cout<<" set intensity 2"<<endl;
  cout<<" set tick size 0.05"<<endl;
  cout<<" set symbol size 2.0"<<endl;
  cout<<" set bar size 0"<<endl;
  cout<<" set symbol 5O"<<endl;
  cout<<" set title size 2.5"<<endl;
  cout<<" set scale x lin"<<endl;
  cout<<" set scale y lin "<<endl;
  cout<<" set limit x 0.00 "<<6.1<<" y 0.00001   1.3 "<<endl;
  cout<<" set color white"<<endl;
  cout<<" 100. 8000."<<endl;
  cout<<" plot"<<endl;
  cout<<" set order x y dy "<<endl;
  int n_data_pt=Exp.return_n_data_pt();
  double* Q2=Exp.return_Q2_bin_cent_ave_F_A_2_wt_coefFA2();
  double* F_A_calc=Exp.return_F_A_calc();
  double* F_A_error=Exp.return_F_A_error();
  int ibin_chi_start=Exp.return_ibin_chi_start();
  int ibin_chi_end=Exp.return_ibin_chi_end();
  for (int i_data_pt=ibin_chi_start; i_data_pt<n_data_pt-ibin_chi_end; i_data_pt++)
  {
    double dip=Exp.F_A_dipole(-Q2[i_data_pt]);
    cout<<Q2[i_data_pt]<<" " <<F_A_calc[i_data_pt]/dip<<"  " <<-F_A_error[i_data_pt]/dip<<endl;
  }
  cout<<"plot"<<endl;
  cout<<" set order x y "<<endl;
  cout<<" set color red"<<endl;
  double Q2_low=0.0;
  double Q2_high=Exp.return_q2MaxData();
  double Q2_step= (Q2_high-Q2_low)/(numThyPts-1);
  for(int i_data_pt=0; i_data_pt<numThyPts;i_data_pt++)
  {
    double Q2_val=Q2_low+i_data_pt*Q2_step;
    cout<<Q2_val<<" "<<Exp.F_A(-Q2_val)/Exp.F_A_dipole(-Q2_val)<<endl;
  }
  cout<<"join"<<endl;
}
void NumberOfEvents(Experiment&);
void NumberOfEvents(Experiment& Exp)
//For minerva
{
   double avogadro = 6.022e23;
   double flux_scale = 1.0e-42;// e-38 def, 10-4 from m**2 def
   double scin_density = 1.032;//gm/cm**3
   double xyzsize=97.61; // cube for ton of scintillator
   double sigma_theory = Exp.return_sigma_thy();// CS*flux, 1/(m**2 2.5e20pot)
   double nucleons=avogadro*scin_density; // nucleons/cm**3
   double events = pow(xyzsize,3)*nucleons*sigma_theory*flux_scale;
   cout<<" ( sigma_theory = "<<sigma_theory<<", nucleons="<<nucleons<<", flux_scale = "<<flux_scale<<endl;
   cout<<" ( cube size = "<<xyzsize<<endl;
   cout<<" ( number of QE events = "<<events<<endl;
} 
void Write_td_file_ene(Experiment&, int);
void Write_td_file_ene(Experiment& Exp, int numThyPts)
{
  cout<< " ( Write_td_file_ene, numThyPts = "<<numThyPts<<endl;
  cout<<" set font duplex"<<endl;
  cout<<" title top \' QE scattering, N0M1, F0A1(Q223), "
    <<Exp.return_exper()<<" \'  size 3.0"<<endl;
  cout<<" case      \'                GXGX   X X  X X    \'"<<endl;
  cout<<" title left \' F0A1(Q223) \' size 3.0"<<endl;
  cout<<" case       \'  X X  X X  \'"<<endl;
  cout<<" title bottom \' Q223 (GeV/c)223 \' size 3.0 "<<endl;
  cout<<" case         \'  X X        X X \'" <<endl;
  cout<<" set label size 3.0"<<endl;
  cout<<" set intensity 2"<<endl;
  cout<<" set tick size 0.05"<<endl;
  cout<<" set symbol size 2.0"<<endl;
  cout<<" set bar size 0"<<endl;
  cout<<" set symbol 5O"<<endl;
  cout<<" set title size 2.5"<<endl;
  cout<<" set scale x lin"<<endl;
  cout<<" set scale y lin "<<endl;
  cout<<" set limit x 0.00 "<<12.5<<" y 0.0 1.3 "<<endl;
  cout<<" set color white"<<endl;
  cout<<" 100. 8000."<<endl;
  cout<<" plot"<<endl;
  cout<<" set order x y dy "<<endl;
  double sigma_data=Exp.return_sigma_data();
  double sigma_thy=Exp.return_sigma_thy();
  cout<<" ( sigma_thy = "<<sigma_thy<<" sigma_data = "<<sigma_data<<endl;
  double xbinsize=0.25;
  double estart=0.25;
  double tot_events=0;
  double e_hi_last=0.25;
  double e_shift_q2_cut=0.001;
  double q2_hi_const=-6.0; // Limit integration
  double q2_low_const=-0.05; // Test # of events printed out
  for (int i_data_pt=0; i_data_pt<15; i_data_pt++)
  {
    double e_low_bin=estart+i_data_pt*xbinsize;
    double e_hi_bin=estart+(i_data_pt+1)*xbinsize;
    e_hi_last=e_hi_bin;
    double e_bin=(e_low_bin+e_hi_bin)/2.0;
    double q2_low=Exp.q2_min(e_hi_bin-e_shift_q2_cut);
    q2_low=min(q2_low,q2_low_const); // test q2
    double q2_hi=Exp.q2_max(e_hi_bin-e_shift_q2_cut);
    q2_hi=max(q2_hi,q2_hi_const);
    double sig = Exp.sigma(e_bin);
    double cs=Exp.Integ_dsigma_dq2_thy(q2_low,q2_hi,e_low_bin,e_hi_bin);
    double events=sigma_data*cs/sigma_thy;
    double error=sig/pow(events,0.5);
    tot_events+=events;
    cout<<e_bin<<" " <<sig<<"  " <<error<<endl;
  }
  xbinsize=0.5;
  estart=e_hi_last;
  for (int i_data_pt=0; i_data_pt<2; i_data_pt++)
  {
    double e_low_bin=estart+i_data_pt*xbinsize;
    double e_hi_bin=estart+(i_data_pt+1)*xbinsize;
    e_hi_last=e_hi_bin;
    double e_bin=(e_low_bin+e_hi_bin)/2.0;
    double q2_low=Exp.q2_min(e_hi_bin-e_shift_q2_cut);
    q2_low=min(q2_low,q2_low_const); // test q2
    double q2_hi=Exp.q2_max(e_hi_bin-e_shift_q2_cut);
    q2_hi=max(q2_hi,q2_hi_const);
    double sig = Exp.sigma(e_bin);
    double cs=Exp.Integ_dsigma_dq2_thy(q2_low,q2_hi,e_low_bin,e_hi_bin);
    double events=sigma_data*cs/sigma_thy;
    double error=sig/pow(events,0.5);
    tot_events+=events;
    cout<<e_bin<<" " <<sig<<"  " <<error<<endl;
  }
  xbinsize=1.0;
  estart=e_hi_last;
  for (int i_data_pt=0; i_data_pt<5; i_data_pt++)
  {
    double e_low_bin=estart+i_data_pt*xbinsize;
    double e_hi_bin=estart+(i_data_pt+1)*xbinsize;
    e_hi_last=e_hi_bin;
    double e_bin=(e_low_bin+e_hi_bin)/2.0;
    double q2_low=Exp.q2_min(e_hi_bin-e_shift_q2_cut);
    q2_low=min(q2_low,q2_low_const); // test q2
    double q2_hi=Exp.q2_max(e_hi_bin-e_shift_q2_cut);
    q2_hi=max(q2_hi,q2_hi_const);
    double sig = Exp.sigma(e_bin);
    double cs=Exp.Integ_dsigma_dq2_thy(q2_low,q2_hi,e_low_bin,e_hi_bin);
    double events=sigma_data*cs/sigma_thy;
    double error=sig/pow(events,0.5);
    tot_events+=events;
    cout<<e_bin<<" " <<sig<<"  " <<error<<endl;
  }
  xbinsize=2.0;
  estart=e_hi_last;
  for (int i_data_pt=0; i_data_pt<1; i_data_pt++)
  {
    double e_low_bin=estart+i_data_pt*xbinsize;
    double e_hi_bin=estart+(i_data_pt+1)*xbinsize;
    e_hi_last=e_hi_bin;
    double e_bin=(e_low_bin+e_hi_bin)/2.0;
    double q2_low=Exp.q2_min(e_hi_bin-e_shift_q2_cut);
    q2_low=min(q2_low,q2_low_const); // test q2
    double q2_hi=Exp.q2_max(e_hi_bin-e_shift_q2_cut);
    q2_hi=max(q2_hi,q2_hi_const);
    double sig = Exp.sigma(e_bin);
    double cs=Exp.Integ_dsigma_dq2_thy(q2_low,q2_hi,e_low_bin,e_hi_bin);
    double events=sigma_data*cs/sigma_thy;
    double error=sig/pow(events,0.5);
    tot_events+=events;
    cout<<e_bin<<" " <<sig<<"  " <<error<<endl;
  }
  xbinsize=3.0;
  estart=e_hi_last;
  for (int i_data_pt=0; i_data_pt<1; i_data_pt++)
  {
    double e_low_bin=estart+i_data_pt*xbinsize;
    double e_hi_bin=estart+(i_data_pt+1)*xbinsize;
    e_hi_last=e_hi_bin;
    double e_bin=(e_low_bin+e_hi_bin)/2.0;
    double q2_low=Exp.q2_min(e_hi_bin-e_shift_q2_cut);
    q2_low=min(q2_low,q2_low_const); // test q2
    double q2_hi=Exp.q2_max(e_hi_bin-e_shift_q2_cut);
    q2_hi=max(q2_hi,q2_hi_const);
    double sig = Exp.sigma(e_bin);
    double cs=Exp.Integ_dsigma_dq2_thy(q2_low,q2_hi,e_low_bin,e_hi_bin);
    double events=sigma_data*cs/sigma_thy;
    double error=sig/pow(events,0.5);
    tot_events+=events;
    cout<<e_bin<<" " <<sig<<"  " <<error<<endl;
  }
  xbinsize=20.0;
  estart=e_hi_last;
  for (int i_data_pt=0; i_data_pt<3; i_data_pt++)
  {
    double e_low_bin=estart+i_data_pt*xbinsize;
    double e_hi_bin=estart+(i_data_pt+1)*xbinsize;
    e_hi_last=e_hi_bin;
    double e_bin=(e_low_bin+e_hi_bin)/2.0;
    double q2_low=Exp.q2_min(e_hi_bin-e_shift_q2_cut);
    q2_low=min(q2_low,q2_low_const); // test q2
    double q2_hi=Exp.q2_max(e_hi_bin-e_shift_q2_cut);
    q2_hi=max(q2_hi,q2_hi_const);
    cout<<" q2_low="<<q2_low<<" q2_hi="<<q2_hi<<endl;
    double sig = Exp.sigma(e_bin);
    double cs=Exp.Integ_dsigma_dq2_thy(q2_low,q2_hi,e_low_bin,e_hi_bin);
    double events=sigma_data*cs/sigma_thy;
    double error=sig/pow(events,0.5);
    tot_events+=events;
    cout<<e_bin<<" " <<sig<<"  " <<error<<endl;
  }
  cout<<" ( total events = "<<tot_events<<endl;
  cout<<"plot"<<endl;
  cout<<" set order x y "<<endl;
  cout<<" set color red"<<endl;
  double e_low=0.25;
  double e_high=50.0;
  double e_step= (e_high-e_low)/(numThyPts-1);
  for(int i_data_pt=0; i_data_pt<numThyPts;i_data_pt++)
  {
    double e_bin=e_low+i_data_pt*e_step;
    cout<<e_bin<<" "<<Exp.sigma(e_bin)<<endl;
  }
  cout<<"join"<<endl;
}
void Write_td_file_ene_q2(Experiment&, int);
void Write_td_file_ene_q2(Experiment& Exp, int numThyPts)
{
  cout<< " ( Write_td_file_ene, numThyPts = "<<numThyPts<<endl;
  cout<<" set font duplex"<<endl;
  cout<<" title top \' QE scattering, N0M1, F0A1(Q223), "
    <<Exp.return_exper()<<" \'  size 3.0"<<endl;
  cout<<" case      \'                GXGX   X X  X X    \'"<<endl;
  cout<<" title left \' F0A1(Q223) \' size 3.0"<<endl;
  cout<<" case       \'  X X  X X  \'"<<endl;
  cout<<" title bottom \' Q223 (GeV/c)223 \' size 3.0 "<<endl;
  cout<<" case         \'  X X        X X \'" <<endl;
  cout<<" set label size 3.0"<<endl;
  cout<<" set intensity 2"<<endl;
  cout<<" set tick size 0.05"<<endl;
  cout<<" set symbol size 2.0"<<endl;
  cout<<" set bar size 0"<<endl;
  cout<<" set symbol 5O"<<endl;
  cout<<" set title size 2.5"<<endl;
  cout<<" set scale x lin"<<endl;
  cout<<" set scale y lin "<<endl;
  cout<<" set limit x 0.00 "<<12.5<<" y 0.0 1.3 "<<endl;
  cout<<" set color white"<<endl;
  cout<<" 100. 8000."<<endl;
  cout<<" plot"<<endl;
  cout<<" set order x y dy "<<endl;
  double sigma_data=Exp.return_sigma_data();
  double sigma_thy=Exp.return_sigma_thy();
  cout<<" ( sigma_thy = "<<sigma_thy<<" sigma_data = "<<sigma_data<<endl;
  double tot_events=0;
  double e_hi_last=0.25;
  const int num_bin_ene=26;
  const double ene_bin[num_bin_ene+1]= 
    {0.25, 0.50, 0.75, 1.00, 1.25, 1.50, 1.75, 2.00, 2.25, 2.50,
     2.75, 3.00, 3.25, 3.50, 3.75, 4.00, 4.50, 5.00, 6.00, 7.00,
     8.00, 9.00, 10.0, 12.0, 15.0, 20.0, 25.0};
  const int num_bin_q2=3;
  const double q2_max=-6.0;
  const double q2_bin_fixed[num_bin_q2+1]={0,-0.2,-0.9,-6.0};
  double q2_bin[num_bin_q2+1]={0,-0.2,-0.9,-6.0};
  double e_shift_q2_cut=0.001;
  cout<<" elow      ehigh     Q2low          Q2hi        #     "<<endl;
  for (int i_ene=0; i_ene<num_bin_ene; i_ene++)
  {
    double e_low_bin=ene_bin[i_ene];
    double e_hi_bin=ene_bin[i_ene+1];
// Need to shift the q2_limits slightly to prevent Intergration
// routine from complaining
    double e_bin_q2_lim=e_hi_bin-e_shift_q2_cut;
    e_hi_last=e_hi_bin;
    for (int i_q2=0;i_q2<num_bin_q2+1;i_q2++)
    {
      q2_bin[i_q2]=q2_bin_fixed[i_q2];
    }
//    double sig = Exp.sigma(e_bin_q2_lim);
    for (int i_q2=0;i_q2<num_bin_q2+1;i_q2++)
    {
      if(q2_bin[i_q2]<=Exp.q2_max(e_bin_q2_lim))
      {
        q2_bin[i_q2]=Exp.q2_max(e_bin_q2_lim);
      }
    }
//    cout<<" q2_bin= "<<q2_bin[0]<<" "<<q2_bin[1]<<" "<<q2_bin[2]<<" "<<q2_bin[3]<<endl;
    for (int i_q2=0;i_q2<num_bin_q2;i_q2++)
    {
      if (q2_bin[i_q2]>q2_bin[i_q2+1])
      {
        double cs=Exp.Integ_dsigma_dq2_thy(q2_bin[i_q2],q2_bin[i_q2+1],e_low_bin,e_hi_bin);
        double events=sigma_data*cs/sigma_thy;
//        double error=sig/pow(events,0.5);
        tot_events+=events;
//        cout<<e_bin<<" " <<sig<<"  " <<error<<endl;
        streamsize prec = cout.precision();
        cout<< setprecision(4) <<" "<<e_low_bin<<" "<<e_hi_bin 
        <<" "<<-q2_bin[i_q2]<<" "<<-q2_bin[i_q2+1]
        << setprecision(5) <<" "<<events<< setprecision(prec) <<endl;
//        cout<<" "<<endl;
      }
    }
  }
  cout<<" ( total events = "<<tot_events<<endl;
  cout<<"plot"<<endl;
  cout<<" set order x y "<<endl;
  cout<<" set color red"<<endl;
  double e_low=0.25;
  double e_high=50.0;
  double e_step= (e_high-e_low)/(numThyPts-1);
  for(int i_data_pt=0; i_data_pt<numThyPts;i_data_pt++)
  {
    double e_bin=e_low+i_data_pt*e_step;
    cout<<e_bin<<" "<<Exp.sigma(e_bin)<<endl;
  }
  cout<<"join"<<endl;
}
void FillCSArrays_BinCen(Experiment&,Experiment&,double delta,char* write);
void FillCSArrays_BinCen(Experiment& Exp1,Experiment& Exp2,double delta,char* write)
{
  Exp1.FillWithSpline_sig_q2_thy_integ_bin();
  Exp2.FillWithSpline_sig_q2_thy_integ_bin();
  Exp1.Q2BinCenter();
  Exp2.Q2BinCenter();
  cout<<" (delta= "<<delta<<endl; 
  Exp1.WriteExperiment();
  if(strcmp(write,"write")==0)
  {
    Exp2.WriteExperiment();
  }
}
